/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.raft.messages;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.opendaylight.controller.cluster.raft.messages.AbstractRaftRPC;
import org.opendaylight.controller.cluster.raft.messages.VR;

public final class RequestVoteReply
extends AbstractRaftRPC {
    private static final long serialVersionUID = 8427899326488775660L;
    private final boolean voteGranted;

    public RequestVoteReply(long term, boolean voteGranted) {
        super(term);
        this.voteGranted = voteGranted;
    }

    public boolean isVoteGranted() {
        return this.voteGranted;
    }

    public String toString() {
        return "RequestVoteReply [term=" + this.getTerm() + ", voteGranted=" + this.voteGranted + "]";
    }

    @Override
    Object writeReplace() {
        return new VR(this);
    }

    @Deprecated(since="7.0.0", forRemoval=true)
    private static class Proxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private RequestVoteReply requestVoteReply;

        @Override
        public void writeExternal(ObjectOutput out) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException {
            long term = in.readLong();
            boolean voteGranted = in.readBoolean();
            this.requestVoteReply = new RequestVoteReply(term, voteGranted);
        }

        private Object readResolve() {
            return this.requestVoteReply;
        }
    }
}

