/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.raft.persisted;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Objects;
import org.apache.commons.lang3.SerializationUtils;
import org.opendaylight.controller.cluster.raft.ReplicatedLogEntry;
import org.opendaylight.controller.cluster.raft.messages.Payload;
import org.opendaylight.controller.cluster.raft.persisted.LE;
import org.opendaylight.controller.cluster.raft.persisted.LegacySerializable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public class SimpleReplicatedLogEntry
implements ReplicatedLogEntry,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int PROXY_SIZE = SerializationUtils.serialize((Serializable)new LE((Void)null)).length;
    private final long index;
    private final long term;
    private final Payload payload;
    private boolean persistencePending;

    public SimpleReplicatedLogEntry(long index, long term, Payload payload) {
        this.index = index;
        this.term = term;
        this.payload = Objects.requireNonNull(payload);
    }

    @Override
    public final Payload getData() {
        return this.payload;
    }

    @Override
    public final long getTerm() {
        return this.term;
    }

    @Override
    public final long getIndex() {
        return this.index;
    }

    @Override
    public final int size() {
        return this.payload.size();
    }

    @Override
    public final int serializedSize() {
        return PROXY_SIZE + this.payload.serializedSize();
    }

    @Override
    public final boolean isPersistencePending() {
        return this.persistencePending;
    }

    @Override
    public final void setPersistencePending(boolean pending) {
        this.persistencePending = pending;
    }

    public final Object writeReplace() {
        return new LE(this);
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.payload.hashCode();
        result = 31 * result + (int)(this.index ^ this.index >>> 32);
        result = 31 * result + (int)(this.term ^ this.term >>> 32);
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof SimpleReplicatedLogEntry)) return false;
        SimpleReplicatedLogEntry other = (SimpleReplicatedLogEntry)obj;
        if (this.index != other.index) return false;
        if (this.term != other.term) return false;
        if (!this.payload.equals(other.payload)) return false;
        return true;
    }

    public final String toString() {
        return "SimpleReplicatedLogEntry [index=" + this.index + ", term=" + this.term + ", payload=" + this.payload + "]";
    }

    @Deprecated(since="7.0.0", forRemoval=true)
    private static final class Proxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private long index;
        private long term;
        private Payload data;

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeLong(this.index);
            out.writeLong(this.term);
            out.writeObject(this.data);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.index = in.readLong();
            this.term = in.readLong();
            this.data = (Payload)in.readObject();
        }

        private Object readResolve() {
            return new Legacy(this.index, this.term, this.data);
        }
    }

    @Deprecated(since="7.0.0", forRemoval=true)
    private static final class Legacy
    extends SimpleReplicatedLogEntry
    implements LegacySerializable {
        private static final long serialVersionUID = 1L;

        Legacy(long index, long term, Payload payload) {
            super(index, term, payload);
        }
    }
}

