/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeConfiguration;
import org.opendaylight.yangtools.yang.data.tree.api.TreeType;
import org.opendaylight.yangtools.yang.data.tree.impl.MandatoryLeafEnforcer;
import org.opendaylight.yangtools.yang.data.tree.impl.SchemaAwareApplyOperation;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextNode;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;

class CaseEnforcer
implements Immutable {
    private final ImmutableMap<YangInstanceIdentifier.NodeIdentifier, DataSchemaNode> children;
    private final ImmutableMap<YangInstanceIdentifier.AugmentationIdentifier, AugmentationSchemaNode> augmentations;

    CaseEnforcer(ImmutableMap<YangInstanceIdentifier.NodeIdentifier, DataSchemaNode> children, ImmutableMap<YangInstanceIdentifier.AugmentationIdentifier, AugmentationSchemaNode> augmentations) {
        this.children = Objects.requireNonNull(children);
        this.augmentations = Objects.requireNonNull(augmentations);
    }

    static CaseEnforcer forTree(CaseSchemaNode schema, DataTreeConfiguration treeConfig) {
        ImmutableMap children;
        TreeType type = treeConfig.getTreeType();
        ImmutableMap.Builder childrenBuilder = ImmutableMap.builder();
        ImmutableMap.Builder augmentationsBuilder = ImmutableMap.builder();
        if (SchemaAwareApplyOperation.belongsToTree(type, (DataSchemaNode)schema)) {
            for (DataSchemaNode child2 : schema.getChildNodes()) {
                if (!SchemaAwareApplyOperation.belongsToTree(type, child2)) continue;
                childrenBuilder.put((Object)YangInstanceIdentifier.NodeIdentifier.create((QName)child2.getQName()), (Object)child2);
            }
            for (AugmentationSchemaNode augment : schema.getAvailableAugmentations()) {
                if (!augment.getChildNodes().stream().anyMatch(child -> SchemaAwareApplyOperation.belongsToTree(type, child))) continue;
                augmentationsBuilder.put((Object)DataSchemaContextNode.augmentationIdentifierFrom((AugmentationSchemaNode)augment), (Object)augment);
            }
        }
        if ((children = childrenBuilder.build()).isEmpty()) {
            return null;
        }
        ImmutableMap augmentations = augmentationsBuilder.build();
        Optional<MandatoryLeafEnforcer> enforcer = MandatoryLeafEnforcer.forContainer((DataNodeContainer)schema, treeConfig);
        return enforcer.isPresent() ? new EnforcingMandatory((ImmutableMap<YangInstanceIdentifier.NodeIdentifier, DataSchemaNode>)children, (ImmutableMap<YangInstanceIdentifier.AugmentationIdentifier, AugmentationSchemaNode>)augmentations, enforcer.orElseThrow()) : new CaseEnforcer((ImmutableMap<YangInstanceIdentifier.NodeIdentifier, DataSchemaNode>)children, (ImmutableMap<YangInstanceIdentifier.AugmentationIdentifier, AugmentationSchemaNode>)augmentations);
    }

    final Set<Map.Entry<YangInstanceIdentifier.NodeIdentifier, DataSchemaNode>> getChildEntries() {
        return this.children.entrySet();
    }

    final Set<YangInstanceIdentifier.NodeIdentifier> getChildIdentifiers() {
        return this.children.keySet();
    }

    final Set<Map.Entry<YangInstanceIdentifier.AugmentationIdentifier, AugmentationSchemaNode>> getAugmentationEntries() {
        return this.augmentations.entrySet();
    }

    final Set<YangInstanceIdentifier.AugmentationIdentifier> getAugmentationIdentifiers() {
        return this.augmentations.keySet();
    }

    final Set<YangInstanceIdentifier.PathArgument> getAllChildIdentifiers() {
        return Sets.union((Set)this.children.keySet(), (Set)this.augmentations.keySet());
    }

    void enforceOnTreeNode(NormalizedNode normalizedNode) {
    }

    private static final class EnforcingMandatory
    extends CaseEnforcer {
        private final MandatoryLeafEnforcer enforcer;

        EnforcingMandatory(ImmutableMap<YangInstanceIdentifier.NodeIdentifier, DataSchemaNode> children, ImmutableMap<YangInstanceIdentifier.AugmentationIdentifier, AugmentationSchemaNode> augmentations, MandatoryLeafEnforcer enforcer) {
            super(children, augmentations);
            this.enforcer = Objects.requireNonNull(enforcer);
        }

        @Override
        void enforceOnTreeNode(NormalizedNode normalizedNode) {
            this.enforcer.enforceOnData(normalizedNode);
        }
    }
}

