/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.remote.rpc;

import akka.actor.ActorRef;
import akka.actor.OneForOneStrategy;
import akka.actor.Props;
import akka.actor.SupervisorStrategy;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.opendaylight.controller.cluster.common.actor.AbstractUntypedActor;
import org.opendaylight.controller.remote.rpc.OpsInvoker;
import org.opendaylight.controller.remote.rpc.OpsListener;
import org.opendaylight.controller.remote.rpc.OpsRegistrar;
import org.opendaylight.controller.remote.rpc.RemoteOpsProviderConfig;
import org.opendaylight.controller.remote.rpc.registry.ActionRegistry;
import org.opendaylight.controller.remote.rpc.registry.RpcRegistry;
import org.opendaylight.mdsal.dom.api.DOMActionProviderService;
import org.opendaylight.mdsal.dom.api.DOMActionService;
import org.opendaylight.mdsal.dom.api.DOMRpcAvailabilityListener;
import org.opendaylight.mdsal.dom.api.DOMRpcProviderService;
import org.opendaylight.mdsal.dom.api.DOMRpcService;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;

public class OpsManager
extends AbstractUntypedActor {
    private final DOMRpcProviderService rpcProvisionRegistry;
    private final RemoteOpsProviderConfig config;
    private final DOMRpcService rpcServices;
    private final DOMActionProviderService actionProvisionRegistry;
    private final DOMActionService actionService;
    private ListenerRegistration<OpsListener> listenerReg;
    private ActorRef opsInvoker;
    private ActorRef actionRegistry;
    private ActorRef rpcRegistry;
    private ActorRef opsRegistrar;

    OpsManager(DOMRpcProviderService rpcProvisionRegistry, DOMRpcService rpcServices, RemoteOpsProviderConfig config, DOMActionProviderService actionProviderService, DOMActionService actionService) {
        this.rpcProvisionRegistry = Objects.requireNonNull(rpcProvisionRegistry);
        this.rpcServices = Objects.requireNonNull(rpcServices);
        this.config = Objects.requireNonNull(config);
        this.actionProvisionRegistry = Objects.requireNonNull(actionProviderService);
        this.actionService = Objects.requireNonNull(actionService);
    }

    public static Props props(DOMRpcProviderService rpcProvisionRegistry, DOMRpcService rpcServices, RemoteOpsProviderConfig config, DOMActionProviderService actionProviderService, DOMActionService actionService) {
        Objects.requireNonNull(rpcProvisionRegistry, "RpcProviderService can not be null!");
        Objects.requireNonNull(rpcServices, "RpcService can not be null!");
        Objects.requireNonNull(config, "RemoteOpsProviderConfig can not be null!");
        Objects.requireNonNull(actionProviderService, "ActionProviderService can not be null!");
        Objects.requireNonNull(actionService, "ActionService can not be null!");
        return Props.create(OpsManager.class, (Object[])new Object[]{rpcProvisionRegistry, rpcServices, config, actionProviderService, actionService});
    }

    public void preStart() throws Exception {
        super.preStart();
        this.opsInvoker = this.getContext().actorOf(OpsInvoker.props(this.rpcServices, this.actionService).withMailbox(this.config.getMailBoxName()), this.config.getRpcBrokerName());
        this.LOG.debug("Listening for RPC invocation requests with {}", (Object)this.opsInvoker);
        this.opsRegistrar = this.getContext().actorOf(OpsRegistrar.props(this.config, this.rpcProvisionRegistry, this.actionProvisionRegistry).withMailbox(this.config.getMailBoxName()), this.config.getRpcRegistrarName());
        this.LOG.debug("Registering remote RPCs with {}", (Object)this.opsRegistrar);
        this.rpcRegistry = this.getContext().actorOf(RpcRegistry.props(this.config, this.opsInvoker, this.opsRegistrar).withMailbox(this.config.getMailBoxName()), this.config.getRpcRegistryName());
        this.LOG.debug("Propagating RPC information with {}", (Object)this.rpcRegistry);
        this.actionRegistry = this.getContext().actorOf(ActionRegistry.props(this.config, this.opsInvoker, this.opsRegistrar).withMailbox(this.config.getMailBoxName()), this.config.getActionRegistryName());
        this.LOG.debug("Propagating action information with {}", (Object)this.actionRegistry);
        OpsListener opsListener = new OpsListener(this.rpcRegistry, this.actionRegistry);
        this.LOG.debug("Registering local availability listener {}", (Object)opsListener);
        this.listenerReg = this.rpcServices.registerRpcListener((DOMRpcAvailabilityListener)opsListener);
    }

    public void postStop() throws Exception {
        if (this.listenerReg != null) {
            this.listenerReg.close();
            this.listenerReg = null;
        }
        super.postStop();
    }

    protected void handleReceive(Object message) {
        this.unknownMessage(message);
    }

    public SupervisorStrategy supervisorStrategy() {
        return new OneForOneStrategy(10, (Duration)FiniteDuration.create((long)1L, (TimeUnit)TimeUnit.MINUTES), t -> {
            this.LOG.error("An exception happened actor will be resumed", t);
            return SupervisorStrategy.resume();
        });
    }
}

