/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.remote.rpc;

import akka.actor.ActorRef;
import com.google.common.util.concurrent.ListenableFuture;
import org.opendaylight.controller.remote.rpc.AbstractRemoteImplementation;
import org.opendaylight.controller.remote.rpc.RemoteDOMActionFuture;
import org.opendaylight.controller.remote.rpc.RemoteOpsProviderConfig;
import org.opendaylight.controller.remote.rpc.messages.ExecuteAction;
import org.opendaylight.mdsal.dom.api.DOMActionImplementation;
import org.opendaylight.mdsal.dom.api.DOMActionResult;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RemoteActionImplementation
extends AbstractRemoteImplementation<ExecuteAction>
implements DOMActionImplementation {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteActionImplementation.class);

    RemoteActionImplementation(ActorRef remoteInvoker, RemoteOpsProviderConfig config) {
        super(remoteInvoker, config);
    }

    public ListenableFuture<DOMActionResult> invokeAction(SchemaNodeIdentifier.Absolute type, DOMDataTreeIdentifier path, ContainerNode input) {
        LOG.debug("invoking action {} with path {}", (Object)type, (Object)path);
        return new RemoteDOMActionFuture(type, this.ask(ExecuteAction.from(type, path, input)));
    }

    public long invocationCost() {
        return 2L;
    }
}

