/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.remote.rpc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.opendaylight.mdsal.dom.api.DOMRpcException;
import org.opendaylight.yangtools.yang.common.ErrorSeverity;
import org.opendaylight.yangtools.yang.common.ErrorTag;
import org.opendaylight.yangtools.yang.common.ErrorType;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;

public class RpcErrorsException
extends DOMRpcException {
    private static final long serialVersionUID = 1L;
    private final List<RpcErrorData> rpcErrorDataList = new ArrayList<RpcErrorData>();

    public RpcErrorsException(String message, Iterable<? extends RpcError> rpcErrors) {
        super(message);
        for (RpcError rpcError : rpcErrors) {
            this.rpcErrorDataList.add(new RpcErrorData(rpcError.getSeverity(), rpcError.getErrorType(), rpcError.getTag(), rpcError.getApplicationTag(), rpcError.getMessage(), rpcError.getInfo(), rpcError.getCause()));
        }
    }

    public Collection<RpcError> getRpcErrors() {
        ArrayList<RpcError> rpcErrors = new ArrayList<RpcError>();
        for (RpcErrorData ed : this.rpcErrorDataList) {
            RpcError rpcError = ed.severity == ErrorSeverity.ERROR ? RpcResultBuilder.newError((ErrorType)ed.errorType, (ErrorTag)ed.tag, (String)ed.message, (String)ed.applicationTag, (String)ed.info, (Throwable)ed.cause) : RpcResultBuilder.newWarning((ErrorType)ed.errorType, (ErrorTag)ed.tag, (String)ed.message, (String)ed.applicationTag, (String)ed.info, (Throwable)ed.cause);
            rpcErrors.add(rpcError);
        }
        return rpcErrors;
    }

    private static class RpcErrorData
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final ErrorSeverity severity;
        final ErrorType errorType;
        final ErrorTag tag;
        final String applicationTag;
        final String message;
        final String info;
        final Throwable cause;

        RpcErrorData(ErrorSeverity severity, ErrorType errorType, ErrorTag tag, String applicationTag, String message, String info, Throwable cause) {
            this.severity = severity;
            this.errorType = errorType;
            this.tag = tag;
            this.applicationTag = applicationTag;
            this.message = message;
            this.info = info;
            this.cause = cause;
        }
    }
}

