/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.remote.rpc.registry;

import akka.actor.ActorRef;
import akka.actor.ExtendedActorSystem;
import akka.serialization.JavaSerializer;
import akka.serialization.Serialization;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.opendaylight.controller.remote.rpc.registry.AbstractRoutingTable;
import org.opendaylight.mdsal.dom.api.DOMRpcIdentifier;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.codec.binfmt.NormalizedNodeDataInput;
import org.opendaylight.yangtools.yang.data.codec.binfmt.NormalizedNodeDataOutput;
import org.opendaylight.yangtools.yang.data.codec.binfmt.NormalizedNodeStreamVersion;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;

public final class RoutingTable
extends AbstractRoutingTable<RoutingTable, DOMRpcIdentifier> {
    private static final long serialVersionUID = 1L;

    RoutingTable(ActorRef invoker, Collection<DOMRpcIdentifier> table) {
        super(invoker, table);
    }

    RoutingTable addRpcs(Collection<DOMRpcIdentifier> toAdd) {
        HashSet<DOMRpcIdentifier> newRpcs = new HashSet<DOMRpcIdentifier>((Collection<DOMRpcIdentifier>)this.getItems());
        newRpcs.addAll(toAdd);
        return new RoutingTable(this.getInvoker(), (Collection<DOMRpcIdentifier>)newRpcs);
    }

    RoutingTable removeRpcs(Collection<DOMRpcIdentifier> toRemove) {
        HashSet<DOMRpcIdentifier> newRpcs = new HashSet<DOMRpcIdentifier>((Collection<DOMRpcIdentifier>)this.getItems());
        newRpcs.removeAll(toRemove);
        return new RoutingTable(this.getInvoker(), (Collection<DOMRpcIdentifier>)newRpcs);
    }

    @Override
    Object writeReplace() {
        return new Proxy(this);
    }

    private static final class Proxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="We deal with the field in serialization methods.")
        private Collection<DOMRpcIdentifier> rpcs;
        private ActorRef opsInvoker;

        public Proxy() {
        }

        Proxy(RoutingTable table) {
            this.rpcs = table.getItems();
            this.opsInvoker = table.getInvoker();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(Serialization.serializedActorPath((ActorRef)this.opsInvoker));
            try (NormalizedNodeDataOutput nnout = NormalizedNodeStreamVersion.current().newDataOutput((DataOutput)out);){
                nnout.writeInt(this.rpcs.size());
                for (DOMRpcIdentifier id : this.rpcs) {
                    nnout.writeSchemaNodeIdentifier((SchemaNodeIdentifier)SchemaNodeIdentifier.Absolute.of((QName)id.getType()));
                    nnout.writeYangInstanceIdentifier(id.getContextReference());
                }
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.opsInvoker = ((ExtendedActorSystem)JavaSerializer.currentSystem().value()).provider().resolveActorRef((String)in.readObject());
            NormalizedNodeDataInput nnin = NormalizedNodeDataInput.newDataInput((DataInput)in);
            int size = nnin.readInt();
            this.rpcs = new ArrayList<DOMRpcIdentifier>(size);
            for (int i = 0; i < size; ++i) {
                this.rpcs.add(DOMRpcIdentifier.create((QName)nnin.readSchemaNodeIdentifier().firstNodeIdentifier(), (YangInstanceIdentifier)nnin.readYangInstanceIdentifier()));
            }
        }

        private Object readResolve() {
            return new RoutingTable(this.opsInvoker, this.rpcs);
        }
    }
}

