/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.remote.rpc.registry.gossip;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.opendaylight.controller.remote.rpc.registry.gossip.Bucket;
import org.opendaylight.controller.remote.rpc.registry.gossip.BucketData;
import org.opendaylight.controller.remote.rpc.registry.gossip.BucketImpl;

final class LocalBucket<T extends BucketData<T>> {
    private long version;
    private T data;
    private boolean bumpVersion;

    LocalBucket(int incarnation, T data) {
        Preconditions.checkArgument((incarnation >= 0 ? 1 : 0) != 0);
        this.version = (long)incarnation << 32;
        this.data = (BucketData)Objects.requireNonNull(data);
    }

    T getData() {
        return this.data;
    }

    long getVersion() {
        return this.version;
    }

    Bucket<T> snapshot() {
        this.bumpVersion = true;
        return new BucketImpl<T>(this.version, this.data);
    }

    boolean setData(T newData) {
        this.data = (BucketData)Objects.requireNonNull(newData);
        if (!this.bumpVersion) {
            return false;
        }
        this.bumpVersion = false;
        return (++this.version & 0xFFFFFFFFL) == 0L;
    }
}

