/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.eos.akka.owner.checker.command;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.eos.akka.owner.checker.command.StateCheckerReply;
import org.opendaylight.controller.eos.akka.owner.supervisor.command.GetEntitiesBackendReply;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingInstanceIdentifierCodec;
import org.opendaylight.mdsal.eos.dom.api.DOMEntity;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.entity.owners.norev.EntityName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.entity.owners.norev.EntityType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.entity.owners.norev.GetEntitiesOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.entity.owners.norev.GetEntitiesOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.entity.owners.norev.NodeName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.entity.owners.norev.get.entities.output.EntitiesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.core.general.entity.rev150930.Entity;
import org.opendaylight.yangtools.yang.binding.util.BindingMap;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

public final class GetEntitiesReply
extends StateCheckerReply
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ImmutableSetMultimap<DOMEntity, String> candidates;
    private final ImmutableMap<DOMEntity, String> owners;

    public GetEntitiesReply(GetEntitiesBackendReply response) {
        this.owners = response.getOwners();
        this.candidates = response.getCandidates();
    }

    public GetEntitiesReply(Map<DOMEntity, Set<String>> candidates, Map<DOMEntity, String> owners) {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        for (Map.Entry<DOMEntity, Set<String>> entry : candidates.entrySet()) {
            builder.putAll((Object)entry.getKey(), (Iterable)entry.getValue());
        }
        this.candidates = builder.build();
        this.owners = ImmutableMap.copyOf(owners);
    }

    public @NonNull GetEntitiesOutput toOutput(BindingInstanceIdentifierCodec iidCodec) {
        HashSet entities = new HashSet();
        entities.addAll(this.owners.keySet());
        entities.addAll(this.candidates.keySet());
        return new GetEntitiesOutputBuilder().setEntities((Map)entities.stream().map(entity -> {
            EntitiesBuilder eb = new EntitiesBuilder().setType(new EntityType(entity.getType())).setName(GetEntitiesReply.extractName(entity, iidCodec)).setCandidateNodes(this.candidates.get(entity).stream().map(NodeName::new).collect(Collectors.toUnmodifiableList()));
            String owner = (String)this.owners.get(entity);
            if (owner != null) {
                eb.setOwnerNode(new NodeName(owner));
            }
            return eb.build();
        }).collect(BindingMap.toMap())).build();
    }

    private static EntityName extractName(DOMEntity entity, BindingInstanceIdentifierCodec iidCodec) {
        YangInstanceIdentifier id = (YangInstanceIdentifier)entity.getIdentifier();
        if (id.isEmpty() || !((YangInstanceIdentifier.PathArgument)id.getPathArguments().get(0)).getNodeType().equals((Object)Entity.QNAME)) {
            return new EntityName(iidCodec.toBinding(id));
        }
        YangInstanceIdentifier.PathArgument last = id.getLastPathArgument();
        Verify.verify((boolean)(last instanceof YangInstanceIdentifier.NodeIdentifierWithPredicates), (String)"Unexpected last argument %s", (Object)last);
        Object value = Iterables.getOnlyElement((Iterable)((YangInstanceIdentifier.NodeIdentifierWithPredicates)last).values());
        Verify.verify((boolean)(value instanceof String), (String)"Unexpected predicate value %s", (Object)value);
        return new EntityName((String)value);
    }
}

