/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.eos.akka.owner.supervisor;

import akka.actor.typed.ActorSystem;
import akka.actor.typed.Behavior;
import akka.actor.typed.javadsl.ActorContext;
import akka.actor.typed.javadsl.Behaviors;
import akka.actor.typed.javadsl.Receive;
import akka.cluster.Member;
import akka.cluster.typed.Cluster;
import akka.japi.function.Function;
import akka.pattern.StatusReply;
import java.io.Serializable;
import java.util.Objects;
import org.opendaylight.controller.eos.akka.owner.supervisor.AbstractSupervisor;
import org.opendaylight.controller.eos.akka.owner.supervisor.OwnerSyncer;
import org.opendaylight.controller.eos.akka.owner.supervisor.command.ActivateDataCenter;
import org.opendaylight.controller.eos.akka.owner.supervisor.command.ClearCandidates;
import org.opendaylight.controller.eos.akka.owner.supervisor.command.ClearCandidatesForMember;
import org.opendaylight.controller.eos.akka.owner.supervisor.command.GetEntitiesBackendRequest;
import org.opendaylight.controller.eos.akka.owner.supervisor.command.GetEntityBackendRequest;
import org.opendaylight.controller.eos.akka.owner.supervisor.command.GetEntityOwnerBackendRequest;
import org.opendaylight.controller.eos.akka.owner.supervisor.command.OwnerSupervisorCommand;
import org.opendaylight.controller.eos.akka.owner.supervisor.command.OwnerSupervisorRequest;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingInstanceIdentifierCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IdleSupervisor
extends AbstractSupervisor {
    private static final Logger LOG = LoggerFactory.getLogger(IdleSupervisor.class);
    private static final String DATACENTER_PREFIX = "dc-";
    private static final String DEFAULT_DATACENTER = "dc-default";
    private final BindingInstanceIdentifierCodec iidCodec;

    private IdleSupervisor(ActorContext<OwnerSupervisorCommand> context, BindingInstanceIdentifierCodec iidCodec) {
        super(context);
        this.iidCodec = Objects.requireNonNull(iidCodec);
        Cluster cluster = Cluster.get((ActorSystem)context.getSystem());
        String datacenterRole = IdleSupervisor.extractDatacenterRole(cluster.selfMember());
        if (datacenterRole.equals(DEFAULT_DATACENTER)) {
            LOG.debug("No datacenter configured, activating default data center");
            context.getSelf().tell((Object)new ActivateDataCenter(null));
        }
        LOG.debug("Idle supervisor started on {}.", (Object)cluster.selfMember());
    }

    public static Behavior<OwnerSupervisorCommand> create(BindingInstanceIdentifierCodec iidCodec) {
        return Behaviors.setup((Function & Serializable)context -> new IdleSupervisor((ActorContext<OwnerSupervisorCommand>)context, iidCodec));
    }

    public Receive<OwnerSupervisorCommand> createReceive() {
        return this.newReceiveBuilder().onMessage(ActivateDataCenter.class, this::onActivateDataCenter).onMessage(GetEntitiesBackendRequest.class, this::onFailEntityRpc).onMessage(GetEntityBackendRequest.class, this::onFailEntityRpc).onMessage(GetEntityOwnerBackendRequest.class, this::onFailEntityRpc).onMessage(ClearCandidatesForMember.class, this::onClearCandidatesForMember).onMessage(ClearCandidates.class, this::finishClearCandidates).build();
    }

    private Behavior<OwnerSupervisorCommand> onFailEntityRpc(OwnerSupervisorRequest message) {
        LOG.debug("Failing rpc request. {}", (Object)message);
        message.getReplyTo().tell((Object)StatusReply.error((String)"OwnerSupervisor is inactive so it cannot handle entity rpc requests."));
        return this;
    }

    private Behavior<OwnerSupervisorCommand> onActivateDataCenter(ActivateDataCenter message) {
        LOG.debug("Received ActivateDataCenter command switching to syncer behavior,");
        return OwnerSyncer.create(message.getReplyTo(), this.iidCodec);
    }

    private static String extractDatacenterRole(Member selfMember) {
        return selfMember.getRoles().stream().filter(role -> role.startsWith(DATACENTER_PREFIX)).findFirst().orElseThrow(() -> new IllegalArgumentException(selfMember + " does not have a valid role"));
    }

    @Override
    Logger getLogger() {
        return LOG;
    }
}

