/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.eos.akka.owner.supervisor;

import akka.actor.typed.ActorRef;
import akka.actor.typed.ActorSystem;
import akka.actor.typed.Behavior;
import akka.actor.typed.javadsl.ActorContext;
import akka.actor.typed.javadsl.Behaviors;
import akka.actor.typed.javadsl.Receive;
import akka.cluster.ClusterEvent;
import akka.cluster.Member;
import akka.cluster.ddata.Key;
import akka.cluster.ddata.LWWRegister;
import akka.cluster.ddata.LWWRegisterKey;
import akka.cluster.ddata.ORMap;
import akka.cluster.ddata.ORSet;
import akka.cluster.ddata.ReplicatedData;
import akka.cluster.ddata.SelfUniqueAddress;
import akka.cluster.ddata.typed.javadsl.DistributedData;
import akka.cluster.ddata.typed.javadsl.Replicator;
import akka.cluster.ddata.typed.javadsl.ReplicatorMessageAdapter;
import akka.cluster.typed.Cluster;
import akka.cluster.typed.Subscribe;
import akka.japi.function.Function;
import akka.pattern.StatusReply;
import com.google.common.base.Verify;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.opendaylight.controller.eos.akka.owner.supervisor.AbstractSupervisor;
import org.opendaylight.controller.eos.akka.owner.supervisor.IdleSupervisor;
import org.opendaylight.controller.eos.akka.owner.supervisor.command.AbstractEntityRequest;
import org.opendaylight.controller.eos.akka.owner.supervisor.command.CandidatesChanged;
import org.opendaylight.controller.eos.akka.owner.supervisor.command.ClearCandidates;
import org.opendaylight.controller.eos.akka.owner.supervisor.command.ClearCandidatesForMember;
import org.opendaylight.controller.eos.akka.owner.supervisor.command.DataCenterDeactivated;
import org.opendaylight.controller.eos.akka.owner.supervisor.command.DeactivateDataCenter;
import org.opendaylight.controller.eos.akka.owner.supervisor.command.GetEntitiesBackendReply;
import org.opendaylight.controller.eos.akka.owner.supervisor.command.GetEntitiesBackendRequest;
import org.opendaylight.controller.eos.akka.owner.supervisor.command.GetEntityBackendReply;
import org.opendaylight.controller.eos.akka.owner.supervisor.command.GetEntityBackendRequest;
import org.opendaylight.controller.eos.akka.owner.supervisor.command.GetEntityOwnerBackendReply;
import org.opendaylight.controller.eos.akka.owner.supervisor.command.GetEntityOwnerBackendRequest;
import org.opendaylight.controller.eos.akka.owner.supervisor.command.MemberDownEvent;
import org.opendaylight.controller.eos.akka.owner.supervisor.command.MemberReachableEvent;
import org.opendaylight.controller.eos.akka.owner.supervisor.command.MemberUnreachableEvent;
import org.opendaylight.controller.eos.akka.owner.supervisor.command.MemberUpEvent;
import org.opendaylight.controller.eos.akka.owner.supervisor.command.OwnerChanged;
import org.opendaylight.controller.eos.akka.owner.supervisor.command.OwnerSupervisorCommand;
import org.opendaylight.controller.eos.akka.registry.candidate.CandidateRegistry;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingInstanceIdentifierCodec;
import org.opendaylight.mdsal.eos.dom.api.DOMEntity;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.entity.owners.norev.EntityName;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.JavaConverters;
import scala.collection.Set;

public final class OwnerSupervisor
extends AbstractSupervisor {
    private static final Logger LOG = LoggerFactory.getLogger(OwnerSupervisor.class);
    private static final String DATACENTER_PREFIX = "dc-";
    private final ReplicatorMessageAdapter<OwnerSupervisorCommand, LWWRegister<String>> ownerReplicator;
    private static final LWWRegister.Clock<String> CLOCK = (currentTimestamp, value) -> currentTimestamp + 1L;
    private final Cluster cluster;
    private final SelfUniqueAddress node;
    private final String dataCenter;
    private final java.util.Set<String> activeMembers;
    private final Map<DOMEntity, java.util.Set<String>> currentCandidates;
    private final Map<DOMEntity, String> currentOwners;
    private final Multimap<String, DOMEntity> ownerToEntity = HashMultimap.create();
    private final BiPredicate<DOMEntity, String> reassignPredicate = (entity, candidate) -> !this.isActiveCandidate((String)candidate) || !this.isCandidateFor((DOMEntity)entity, (String)candidate);
    private final BindingInstanceIdentifierCodec iidCodec;

    private OwnerSupervisor(ActorContext<OwnerSupervisorCommand> context, Map<DOMEntity, java.util.Set<String>> currentCandidates, Map<DOMEntity, String> currentOwners, BindingInstanceIdentifierCodec iidCodec) {
        super(context);
        this.iidCodec = Objects.requireNonNull(iidCodec);
        DistributedData distributedData = DistributedData.get((ActorSystem)context.getSystem());
        ActorRef replicator = distributedData.replicator();
        this.cluster = Cluster.get((ActorSystem)context.getSystem());
        this.ownerReplicator = new ReplicatorMessageAdapter(context, replicator, Duration.ofSeconds(5L));
        this.dataCenter = OwnerSupervisor.extractDatacenterRole(this.cluster.selfMember());
        this.node = distributedData.selfUniqueAddress();
        this.activeMembers = this.getActiveMembers();
        this.currentCandidates = currentCandidates;
        this.currentOwners = currentOwners;
        for (Map.Entry<DOMEntity, String> entry : currentOwners.entrySet()) {
            this.ownerToEntity.put((Object)entry.getValue(), (Object)entry.getKey());
        }
        this.reassignUnreachableOwners();
        this.assignMissingOwners();
        ActorRef memberEventAdapter = context.messageAdapter(ClusterEvent.MemberEvent.class, (Function & Serializable)event -> {
            if (event instanceof ClusterEvent.MemberUp) {
                return new MemberUpEvent(event.member().address(), event.member().getRoles());
            }
            return new MemberDownEvent(event.member().address(), event.member().getRoles());
        });
        this.cluster.subscriptions().tell((Object)Subscribe.create((ActorRef)memberEventAdapter, ClusterEvent.MemberEvent.class));
        ActorRef reachabilityEventAdapter = context.messageAdapter(ClusterEvent.ReachabilityEvent.class, (Function & Serializable)event -> {
            if (event instanceof ClusterEvent.ReachableMember) {
                return new MemberReachableEvent(event.member().address(), event.member().getRoles());
            }
            return new MemberUnreachableEvent(event.member().address(), event.member().getRoles());
        });
        this.cluster.subscriptions().tell((Object)Subscribe.create((ActorRef)reachabilityEventAdapter, ClusterEvent.ReachabilityEvent.class));
        this.candidateReplicator.subscribe(CandidateRegistry.KEY, CandidatesChanged::new);
        LOG.debug("Owner Supervisor started");
    }

    public static Behavior<OwnerSupervisorCommand> create(Map<DOMEntity, java.util.Set<String>> currentCandidates, Map<DOMEntity, String> currentOwners, BindingInstanceIdentifierCodec iidCodec) {
        return Behaviors.setup((Function & Serializable)ctx -> new OwnerSupervisor((ActorContext<OwnerSupervisorCommand>)ctx, currentCandidates, currentOwners, iidCodec));
    }

    public Receive<OwnerSupervisorCommand> createReceive() {
        return this.newReceiveBuilder().onMessage(CandidatesChanged.class, this::onCandidatesChanged).onMessage(DeactivateDataCenter.class, this::onDeactivateDatacenter).onMessage(OwnerChanged.class, this::onOwnerChanged).onMessage(MemberUpEvent.class, this::onPeerUp).onMessage(MemberDownEvent.class, this::onPeerDown).onMessage(MemberReachableEvent.class, this::onPeerReachable).onMessage(MemberUnreachableEvent.class, this::onPeerUnreachable).onMessage(GetEntitiesBackendRequest.class, this::onGetEntities).onMessage(GetEntityBackendRequest.class, this::onGetEntity).onMessage(GetEntityOwnerBackendRequest.class, this::onGetEntityOwner).onMessage(ClearCandidatesForMember.class, this::onClearCandidatesForMember).onMessage(ClearCandidates.class, this::finishClearCandidates).build();
    }

    private Behavior<OwnerSupervisorCommand> onDeactivateDatacenter(DeactivateDataCenter command) {
        LOG.debug("Deactivating Owner Supervisor on {}", (Object)this.cluster.selfMember());
        command.getReplyTo().tell((Object)DataCenterDeactivated.INSTANCE);
        return IdleSupervisor.create(this.iidCodec);
    }

    private Behavior<OwnerSupervisorCommand> onOwnerChanged(OwnerChanged command) {
        LOG.debug("Owner has changed for {}", (Object)command.getResponse().key());
        return this;
    }

    private void reassignUnreachableOwners() {
        HashSet<String> ownersToReassign = new HashSet<String>();
        for (String owner : this.ownerToEntity.keys()) {
            if (this.isActiveCandidate(owner)) continue;
            ownersToReassign.add(owner);
        }
        for (String owner : ownersToReassign) {
            this.reassignCandidatesFor(owner, (Collection<DOMEntity>)ImmutableList.copyOf((Collection)this.ownerToEntity.get((Object)owner)), this.reassignPredicate);
        }
    }

    private void assignMissingOwners() {
        for (Map.Entry<DOMEntity, java.util.Set<String>> entry : this.currentCandidates.entrySet()) {
            if (this.currentOwners.containsKey(entry.getKey())) continue;
            this.assignOwnerFor(entry.getKey());
        }
    }

    private Behavior<OwnerSupervisorCommand> onCandidatesChanged(CandidatesChanged message) {
        LOG.debug("onCandidatesChanged {}", message.getResponse());
        if (message.getResponse() instanceof Replicator.Changed) {
            Replicator.Changed changed = (Replicator.Changed)message.getResponse();
            this.processCandidateChanges((ORMap<DOMEntity, ORSet<String>>)((ORMap)changed.get(CandidateRegistry.KEY)));
        }
        return this;
    }

    private void processCandidateChanges(ORMap<DOMEntity, ORSet<String>> candidates) {
        Map entries = candidates.getEntries();
        for (Map.Entry entry : entries.entrySet()) {
            this.processCandidatesFor((DOMEntity)entry.getKey(), (ORSet<String>)((ORSet)entry.getValue()));
        }
    }

    private void processCandidatesFor(DOMEntity entity, ORSet<String> receivedCandidates) {
        LOG.debug("Processing candidates for : {}, new value: {}", (Object)entity, (Object)receivedCandidates.elements());
        java.util.Set candidates = JavaConverters.asJava((Set)receivedCandidates.elements());
        if (!this.currentCandidates.containsKey(entity) && !candidates.isEmpty()) {
            LOG.debug("Candidates missing for entity: {} adding all candidates", (Object)entity);
            this.currentCandidates.put(entity, new HashSet(candidates));
            LOG.debug("Current state for {} : {}", (Object)entity, (Object)this.currentCandidates.get(entity).toString());
            this.assignOwnerFor(entity);
            return;
        }
        java.util.Set currentlyPresent = this.currentCandidates.getOrDefault(entity, java.util.Set.of());
        ImmutableSet difference = ImmutableSet.copyOf((Collection)Sets.symmetricDifference(currentlyPresent, (java.util.Set)candidates));
        LOG.debug("currently present candidates: {}", currentlyPresent);
        LOG.debug("difference: {}", (Object)difference);
        ArrayList<String> ownersToReassign = new ArrayList<String>();
        for (String toCheck : difference) {
            if (!currentlyPresent.contains(toCheck)) {
                LOG.debug("Adding new candidate for entity: {} : {}", (Object)entity, (Object)toCheck);
                this.currentCandidates.get(entity).add(toCheck);
                String currentOwner = this.currentOwners.get(entity);
                if (currentOwner == null || !this.activeMembers.contains(currentOwner)) {
                    this.assignOwnerFor(entity);
                }
                LOG.debug("Current state for entity: {} : {}", (Object)entity, (Object)this.currentCandidates.get(entity).toString());
                continue;
            }
            if (candidates.contains(toCheck)) continue;
            LOG.debug("Removing candidate from entity: {} - {}", (Object)entity, (Object)toCheck);
            this.currentCandidates.get(entity).remove(toCheck);
            if (!this.ownerToEntity.containsKey((Object)toCheck)) continue;
            ownersToReassign.add(toCheck);
        }
        for (String toReassign : ownersToReassign) {
            this.reassignCandidatesFor(toReassign, (Collection<DOMEntity>)ImmutableList.copyOf((Collection)this.ownerToEntity.get((Object)toReassign)), this.reassignPredicate);
        }
        if (this.currentCandidates.get(entity) == null) {
            LOG.debug("Last candidate removed for {}", (Object)entity);
        } else {
            LOG.debug("Current state for entity: {} : {}", (Object)entity, (Object)this.currentCandidates.get(entity).toString());
        }
    }

    private void reassignCandidatesFor(String oldOwner, Collection<DOMEntity> entities, BiPredicate<DOMEntity, String> predicate) {
        LOG.debug("Reassigning owners for {}", entities);
        for (DOMEntity entity : entities) {
            if (!predicate.test(entity, oldOwner)) continue;
            if (!this.isActiveCandidate(oldOwner) && this.isCandidateFor(entity, oldOwner) && this.hasSingleCandidate(entity)) {
                LOG.debug("{} is the only candidate for {}. Skipping reassignment.", (Object)oldOwner, (Object)entity);
                continue;
            }
            this.ownerToEntity.remove((Object)oldOwner, (Object)entity);
            this.assignOwnerFor(entity);
        }
    }

    private boolean isActiveCandidate(String candidate) {
        return this.activeMembers.contains(candidate);
    }

    private boolean isCandidateFor(DOMEntity entity, String candidate) {
        return this.currentCandidates.getOrDefault(entity, java.util.Set.of()).contains(candidate);
    }

    private boolean hasSingleCandidate(DOMEntity entity) {
        return this.currentCandidates.getOrDefault(entity, java.util.Set.of()).size() == 1;
    }

    private void assignOwnerFor(DOMEntity entity) {
        java.util.Set<String> candidatesForEntity = this.currentCandidates.get(entity);
        if (candidatesForEntity.isEmpty()) {
            LOG.debug("No candidates present for entity: {}", (Object)entity);
            this.removeOwner(entity);
            return;
        }
        String pickedCandidate = null;
        for (String candidate : candidatesForEntity) {
            if (!this.activeMembers.contains(candidate)) continue;
            pickedCandidate = candidate;
            break;
        }
        if (pickedCandidate == null) {
            LOG.debug("No candidate is reachable for {}, activeMembers: {}, currentCandidates: {}", new Object[]{entity, this.activeMembers, this.currentCandidates.get(entity)});
            this.removeOwner(entity);
            return;
        }
        this.ownerToEntity.put(pickedCandidate, (Object)entity);
        LOG.debug("Entity {} new owner: {}", (Object)entity, (Object)pickedCandidate);
        this.currentOwners.put(entity, pickedCandidate);
        this.writeNewOwner(entity, pickedCandidate);
    }

    private void removeOwner(DOMEntity entity) {
        if (this.currentOwners.containsKey(entity)) {
            this.currentOwners.remove(entity);
            this.writeNewOwner(entity, "");
        }
    }

    private void writeNewOwner(DOMEntity entity, String candidate) {
        this.ownerReplicator.askUpdate(askReplyTo -> new Replicator.Update((Key)new LWWRegisterKey(entity.toString()), (ReplicatedData)new LWWRegister(this.node.uniqueAddress(), (Object)candidate, 0L), Replicator.writeLocal(), askReplyTo, register -> register.withValue(this.node, (Object)candidate, CLOCK)), OwnerChanged::new);
    }

    private Behavior<OwnerSupervisorCommand> onPeerUp(MemberUpEvent event) {
        LOG.debug("Received MemberUp : {}", (Object)event);
        this.handleReachableEvent(event.getRoles());
        return this;
    }

    private Behavior<OwnerSupervisorCommand> onPeerReachable(MemberReachableEvent event) {
        LOG.debug("Received MemberReachable : {}", (Object)event);
        this.handleReachableEvent(event.getRoles());
        return this;
    }

    private Behavior<OwnerSupervisorCommand> onGetEntities(GetEntitiesBackendRequest request) {
        request.getReplyTo().tell((Object)StatusReply.success((Object)new GetEntitiesBackendReply(this.currentOwners, this.currentCandidates)));
        return this;
    }

    private Behavior<OwnerSupervisorCommand> onGetEntity(GetEntityBackendRequest request) {
        DOMEntity entity = this.extractEntity(request);
        request.getReplyTo().tell((Object)StatusReply.success((Object)new GetEntityBackendReply(this.currentOwners.get(entity), this.currentCandidates.get(entity))));
        return this;
    }

    private Behavior<OwnerSupervisorCommand> onGetEntityOwner(GetEntityOwnerBackendRequest request) {
        request.getReplyTo().tell((Object)StatusReply.success((Object)new GetEntityOwnerBackendReply(this.currentOwners.get(this.extractEntity(request)))));
        return this;
    }

    private void handleReachableEvent(java.util.Set<String> roles) {
        if (roles.contains(this.dataCenter)) {
            this.activeMembers.add(OwnerSupervisor.extractRole(roles));
            this.assignMissingOwners();
        } else {
            LOG.debug("Received reachable event from a foreign datacenter, Ignoring... Roles: {}", roles);
        }
    }

    private Behavior<OwnerSupervisorCommand> onPeerDown(MemberDownEvent event) {
        LOG.debug("Received MemberDown : {}", (Object)event);
        this.handleUnreachableEvent(event.getRoles());
        return this;
    }

    private Behavior<OwnerSupervisorCommand> onPeerUnreachable(MemberUnreachableEvent event) {
        LOG.debug("Received MemberUnreachable : {}", (Object)event);
        this.handleUnreachableEvent(event.getRoles());
        return this;
    }

    private void handleUnreachableEvent(java.util.Set<String> roles) {
        if (roles.contains(this.dataCenter)) {
            this.activeMembers.remove(OwnerSupervisor.extractRole(roles));
            this.reassignUnreachableOwners();
        } else {
            LOG.debug("Received unreachable event from a foreign datacenter, Ignoring... Roles: {}", roles);
        }
    }

    private java.util.Set<String> getActiveMembers() {
        ClusterEvent.CurrentClusterState clusterState = this.cluster.state();
        java.util.Set unreachableRoles = clusterState.getUnreachable().stream().map(OwnerSupervisor::extractRole).collect(Collectors.toSet());
        return StreamSupport.stream(clusterState.getMembers().spliterator(), false).map(Member::getRoles).filter(roles -> roles.contains(this.dataCenter)).map(OwnerSupervisor::extractRole).filter(role -> !unreachableRoles.contains(role)).collect(Collectors.toSet());
    }

    private DOMEntity extractEntity(AbstractEntityRequest<?> request) {
        EntityName name = request.getName();
        InstanceIdentifier<?> iid = name.getInstanceIdentifier();
        if (iid != null) {
            return new DOMEntity(request.getType().getValue(), this.iidCodec.fromBinding(iid));
        }
        String str = (String)Verify.verifyNotNull((Object)name.getString(), (String)"Unhandled entity name %s", (Object[])new Object[]{name});
        return new DOMEntity(request.getType().getValue(), str);
    }

    private static String extractRole(Member member) {
        return OwnerSupervisor.extractRole(member.getRoles());
    }

    private static String extractRole(java.util.Set<String> roles) {
        return roles.stream().filter(role -> !role.startsWith(DATACENTER_PREFIX)).findFirst().orElseThrow(() -> new IllegalArgumentException("No valid role found."));
    }

    private static String extractDatacenterRole(Member member) {
        return member.getRoles().stream().filter(role -> role.startsWith(DATACENTER_PREFIX)).findFirst().orElseThrow(() -> new IllegalArgumentException("No valid role found."));
    }

    @Override
    Logger getLogger() {
        return LOG;
    }
}

