/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.eos.akka.registry.listener.type;

import akka.actor.typed.ActorRef;
import akka.actor.typed.Behavior;
import akka.actor.typed.javadsl.AbstractBehavior;
import akka.actor.typed.javadsl.ActorContext;
import akka.actor.typed.javadsl.Behaviors;
import akka.actor.typed.javadsl.Receive;
import akka.japi.function.Function;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.opendaylight.controller.eos.akka.registry.listener.type.EntityTypeListenerActor;
import org.opendaylight.controller.eos.akka.registry.listener.type.command.RegisterListener;
import org.opendaylight.controller.eos.akka.registry.listener.type.command.TerminateListener;
import org.opendaylight.controller.eos.akka.registry.listener.type.command.TypeListenerCommand;
import org.opendaylight.controller.eos.akka.registry.listener.type.command.TypeListenerRegistryCommand;
import org.opendaylight.controller.eos.akka.registry.listener.type.command.UnregisterListener;
import org.opendaylight.mdsal.eos.dom.api.DOMEntityOwnershipListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityTypeListenerRegistry
extends AbstractBehavior<TypeListenerRegistryCommand> {
    private static final Logger LOG = LoggerFactory.getLogger(EntityTypeListenerRegistry.class);
    private final Map<DOMEntityOwnershipListener, ActorRef<TypeListenerCommand>> spawnedListenerActors = new HashMap<DOMEntityOwnershipListener, ActorRef<TypeListenerCommand>>();
    private final String localMember;

    public EntityTypeListenerRegistry(ActorContext<TypeListenerRegistryCommand> context, String localMember) {
        super(context);
        this.localMember = Objects.requireNonNull(localMember);
    }

    public static Behavior<TypeListenerRegistryCommand> create(String role) {
        return Behaviors.setup((Function & Serializable)ctx -> new EntityTypeListenerRegistry((ActorContext<TypeListenerRegistryCommand>)ctx, role));
    }

    public Receive<TypeListenerRegistryCommand> createReceive() {
        return this.newReceiveBuilder().onMessage(RegisterListener.class, this::onRegisterListener).onMessage(UnregisterListener.class, this::onUnregisterListener).build();
    }

    private Behavior<TypeListenerRegistryCommand> onRegisterListener(RegisterListener command) {
        LOG.debug("Spawning entity type listener actor for: {}", (Object)command.getEntityType());
        ActorRef listenerActor = this.getContext().spawn(EntityTypeListenerActor.create(this.localMember, command.getEntityType(), command.getDelegateListener()), "TypeListener:" + EntityTypeListenerRegistry.encodeEntityToActorName(command.getEntityType()));
        this.spawnedListenerActors.put(command.getDelegateListener(), (ActorRef<TypeListenerCommand>)listenerActor);
        return this;
    }

    private Behavior<TypeListenerRegistryCommand> onUnregisterListener(UnregisterListener command) {
        LOG.debug("Stopping entity type listener actor for: {}", (Object)command.getEntityType());
        ActorRef<TypeListenerCommand> actor = this.spawnedListenerActors.remove(command.getDelegateListener());
        if (actor != null) {
            actor.tell((Object)TerminateListener.INSTANCE);
        }
        return this;
    }

    private static String encodeEntityToActorName(String entityType) {
        return "type=" + entityType + "-" + UUID.randomUUID();
    }
}

