/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.security.condpermadmin;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.felix.framework.security.condpermadmin.ConditionalPermissionAdminImpl;
import org.apache.felix.framework.security.util.Permissions;
import org.osgi.service.condpermadmin.ConditionInfo;
import org.osgi.service.condpermadmin.ConditionalPermissionInfo;
import org.osgi.service.permissionadmin.PermissionInfo;

public final class ConditionalPermissionInfoImpl
implements ConditionalPermissionInfo {
    private static final Random RANDOM = new Random();
    static final ConditionInfo[] CONDITION_INFO = new ConditionInfo[0];
    static final PermissionInfo[] PERMISSION_INFO = new PermissionInfo[0];
    private final Object m_lock = new Object();
    private final String m_name;
    private final boolean m_allow;
    private volatile ConditionalPermissionAdminImpl m_cpai;
    private ConditionInfo[] m_conditions;
    private PermissionInfo[] m_permissions;

    private int parseConditionInfo(char[] encoded, int idx, List conditions) {
        try {
            char c;
            int pos = idx;
            while (Character.isWhitespace(encoded[pos])) {
                ++pos;
            }
            if (encoded[pos] != '[') {
                throw new IllegalArgumentException("expecting open bracket");
            }
            ++pos;
            while (Character.isWhitespace(encoded[pos])) {
                ++pos;
            }
            int begin = pos;
            while (!Character.isWhitespace(encoded[pos]) && encoded[pos] != ']') {
                ++pos;
            }
            if (pos == begin || encoded[begin] == '\"') {
                throw new IllegalArgumentException("expecting type");
            }
            String type = new String(encoded, begin, pos - begin);
            while (Character.isWhitespace(encoded[pos])) {
                ++pos;
            }
            ArrayList<String> argsList = new ArrayList<String>();
            while (encoded[pos] == '\"') {
                begin = ++pos;
                while (encoded[pos] != '\"') {
                    if (encoded[pos] == '\\') {
                        ++pos;
                    }
                    ++pos;
                }
                argsList.add(ConditionalPermissionInfoImpl.unescapeString(encoded, begin, pos));
                if (!Character.isWhitespace(encoded[++pos])) continue;
                while (Character.isWhitespace(encoded[pos])) {
                    ++pos;
                }
            }
            String[] args = argsList.toArray(new String[argsList.size()]);
            if ((c = encoded[pos++]) != ']') {
                throw new IllegalArgumentException("expecting close bracket");
            }
            conditions.add(new ConditionInfo(type, args));
            return pos;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("parsing terminated abruptly");
        }
    }

    private int parsePermissionInfo(char[] encoded, int idx, List permissions) {
        String parsedType = null;
        String parsedName = null;
        String parsedActions = null;
        try {
            char c;
            int pos = idx;
            while (Character.isWhitespace(encoded[pos])) {
                ++pos;
            }
            if (encoded[pos] != '(') {
                throw new IllegalArgumentException("expecting open parenthesis");
            }
            ++pos;
            while (Character.isWhitespace(encoded[pos])) {
                ++pos;
            }
            int begin = pos;
            while (!Character.isWhitespace(encoded[pos]) && encoded[pos] != ')') {
                ++pos;
            }
            if (pos == begin || encoded[begin] == '\"') {
                throw new IllegalArgumentException("expecting type");
            }
            parsedType = new String(encoded, begin, pos - begin);
            while (Character.isWhitespace(encoded[pos])) {
                ++pos;
            }
            if (encoded[pos] == '\"') {
                begin = ++pos;
                while (encoded[pos] != '\"') {
                    if (encoded[pos] == '\\') {
                        ++pos;
                    }
                    ++pos;
                }
                parsedName = ConditionalPermissionInfoImpl.unescapeString(encoded, begin, pos);
                if (Character.isWhitespace(encoded[++pos])) {
                    while (Character.isWhitespace(encoded[pos])) {
                        ++pos;
                    }
                    if (encoded[pos] == '\"') {
                        begin = ++pos;
                        while (encoded[pos] != '\"') {
                            if (encoded[pos] == '\\') {
                                ++pos;
                            }
                            ++pos;
                        }
                        parsedActions = ConditionalPermissionInfoImpl.unescapeString(encoded, begin, pos);
                        ++pos;
                        while (Character.isWhitespace(encoded[pos])) {
                            ++pos;
                        }
                    }
                }
            }
            if ((c = encoded[pos++]) != ')') {
                throw new IllegalArgumentException("expecting close parenthesis");
            }
            permissions.add(new PermissionInfo(parsedType, parsedName, parsedActions));
            return pos;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("parsing terminated abruptly");
        }
    }

    private static String unescapeString(char[] str, int begin, int end) {
        StringBuffer output = new StringBuffer(end - begin);
        for (int i = begin; i < end; ++i) {
            int c = str[i];
            if (c == 92 && ++i < end) {
                c = str[i];
                switch (c) {
                    case 34: 
                    case 92: {
                        break;
                    }
                    case 114: {
                        c = 13;
                        break;
                    }
                    case 110: {
                        c = 10;
                        break;
                    }
                    default: {
                        c = 92;
                        --i;
                    }
                }
            }
            output.append((char)c);
        }
        return output.toString();
    }

    public ConditionalPermissionInfoImpl(String encoded) {
        encoded = encoded.trim();
        String toUpper = encoded.toUpperCase();
        if (!toUpper.startsWith("ALLOW {") && !toUpper.startsWith("DENY {")) {
            throw new IllegalArgumentException();
        }
        this.m_allow = toUpper.startsWith("ALLOW {");
        this.m_cpai = null;
        ArrayList conditions = new ArrayList();
        ArrayList permissions = new ArrayList();
        try {
            char[] chars = encoded.substring(this.m_allow ? "ALLOW {".length() : "DENY {".length()).toCharArray();
            int idx = 0;
            while (idx < chars.length) {
                if (Character.isWhitespace(chars[idx])) {
                    ++idx;
                    continue;
                }
                if (chars[idx] == '[') {
                    idx = this.parseConditionInfo(chars, idx, conditions);
                    continue;
                }
                if (chars[idx] == '(') {
                    idx = this.parsePermissionInfo(chars, idx, permissions);
                    continue;
                }
                if (chars[idx] != '}') {
                    throw new IllegalArgumentException("Expected } but was: " + chars[idx]);
                }
                ++idx;
                break;
            }
            while (Character.isWhitespace(chars[idx])) {
                ++idx;
            }
            if (chars[idx] == '\"') {
                int begin = ++idx;
                while (chars[idx] != '\"') {
                    if (chars[idx] == '\\') {
                        ++idx;
                    }
                    ++idx;
                }
                this.m_name = ConditionalPermissionInfoImpl.unescapeString(chars, begin, idx);
            } else {
                this.m_name = Long.toString(RANDOM.nextLong() ^ System.currentTimeMillis());
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            ex.printStackTrace();
            throw new IllegalArgumentException("Unable to parse conditional permission info: " + ex.getMessage());
        }
        this.m_conditions = conditions.isEmpty() ? CONDITION_INFO : conditions.toArray(new ConditionInfo[conditions.size()]);
        this.m_permissions = permissions.isEmpty() ? PERMISSION_INFO : permissions.toArray(new PermissionInfo[permissions.size()]);
    }

    public ConditionalPermissionInfoImpl(ConditionalPermissionAdminImpl cpai, String name, boolean access) {
        this.m_allow = access;
        this.m_name = name;
        this.m_cpai = cpai;
        this.m_conditions = CONDITION_INFO;
        this.m_permissions = PERMISSION_INFO;
    }

    public ConditionalPermissionInfoImpl(ConditionInfo[] conditions, PermissionInfo[] permisions, ConditionalPermissionAdminImpl cpai, boolean access) {
        this.m_allow = access;
        this.m_name = Long.toString(RANDOM.nextLong() ^ System.currentTimeMillis());
        this.m_cpai = cpai;
        this.m_conditions = conditions == null ? CONDITION_INFO : conditions;
        this.m_permissions = permisions == null ? PERMISSION_INFO : permisions;
    }

    public ConditionalPermissionInfoImpl(String name, ConditionInfo[] conditions, PermissionInfo[] permisions, ConditionalPermissionAdminImpl cpai, boolean access) {
        this.m_allow = access;
        this.m_name = name != null ? name : Long.toString(RANDOM.nextLong() ^ System.currentTimeMillis());
        this.m_conditions = conditions == null ? CONDITION_INFO : conditions;
        this.m_permissions = permisions == null ? PERMISSION_INFO : permisions;
        this.m_cpai = cpai;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(Permissions.ALL_PERMISSION);
        }
        Object object = this.m_lock;
        synchronized (object) {
            this.m_cpai.write(this.m_name, null);
            this.m_conditions = CONDITION_INFO;
            this.m_permissions = PERMISSION_INFO;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConditionInfo[] getConditionInfos() {
        Object object = this.m_lock;
        synchronized (object) {
            return (ConditionInfo[])this.m_conditions.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConditionInfo[] _getConditionInfos() {
        Object object = this.m_lock;
        synchronized (object) {
            return this.m_conditions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setConditionsAndPermissions(ConditionInfo[] conditions, PermissionInfo[] permissions) {
        Object object = this.m_lock;
        synchronized (object) {
            this.m_conditions = conditions;
            this.m_permissions = permissions;
        }
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PermissionInfo[] getPermissionInfos() {
        Object object = this.m_lock;
        synchronized (object) {
            return (PermissionInfo[])this.m_permissions.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PermissionInfo[] _getPermissionInfos() {
        Object object = this.m_lock;
        synchronized (object) {
            return this.m_permissions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getEncoded() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.m_allow ? "ALLOW " : "DENY ");
        buffer.append('{');
        buffer.append(' ');
        Object object = this.m_lock;
        synchronized (object) {
            this.writeTo(this.m_conditions, buffer);
            this.writeTo(this.m_permissions, buffer);
        }
        buffer.append('}');
        buffer.append(' ');
        buffer.append('\"');
        ConditionalPermissionInfoImpl.escapeString(this.m_name, buffer);
        buffer.append('\"');
        return buffer.toString();
    }

    private static void escapeString(String str, StringBuffer output) {
        int len = str.length();
        block5: for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    output.append('\\');
                    output.append(c);
                    continue block5;
                }
                case '\r': {
                    output.append("\\r");
                    continue block5;
                }
                case '\n': {
                    output.append("\\n");
                    continue block5;
                }
                default: {
                    output.append(c);
                }
            }
        }
    }

    private void writeTo(Object[] elements, StringBuffer buffer) {
        for (int i = 0; i < elements.length; ++i) {
            buffer.append(elements[i]);
            buffer.append(' ');
        }
    }

    @Override
    public String toString() {
        return this.getEncoded();
    }

    @Override
    public String getAccessDecision() {
        return this.m_allow ? "allow" : "deny";
    }

    public boolean isAllow() {
        return this.m_allow;
    }
}

