/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.repo.api;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;

@Beta
public final class FeatureSet
extends AbstractSet<QName>
implements Immutable {
    private final ImmutableMap<QNameModule, ImmutableSet<String>> featuresByModule;

    public FeatureSet(ImmutableMap<QNameModule, ImmutableSet<String>> featuresByModule) {
        this.featuresByModule = Objects.requireNonNull(featuresByModule);
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof QName) {
            QName qname = (QName)o;
            ImmutableSet features = (ImmutableSet)this.featuresByModule.get((Object)qname.getModule());
            return features == null || features.contains((Object)qname.getLocalName());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.featuresByModule.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof FeatureSet)) return false;
        FeatureSet other = (FeatureSet)obj;
        if (!this.featuresByModule.equals(other.featuresByModule)) return false;
        return true;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("features", this.featuresByModule).toString();
    }

    @Override
    @Deprecated
    public Iterator<QName> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean isEmpty() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean add(QName e) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean addAll(Collection<? extends QName> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void clear() {
        throw new UnsupportedOperationException();
    }
}

