/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.profile.assembly;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.felix.resolver.ResolverImpl;
import org.apache.felix.utils.manifest.Clause;
import org.apache.felix.utils.manifest.Parser;
import org.apache.felix.utils.properties.Properties;
import org.apache.felix.utils.repository.BaseRepository;
import org.apache.felix.utils.resource.ResourceBuilder;
import org.apache.felix.utils.resource.ResourceImpl;
import org.apache.karaf.features.BundleInfo;
import org.apache.karaf.features.FeaturePattern;
import org.apache.karaf.features.Library;
import org.apache.karaf.features.LocationPattern;
import org.apache.karaf.features.internal.download.DownloadCallback;
import org.apache.karaf.features.internal.download.DownloadManager;
import org.apache.karaf.features.internal.download.Downloader;
import org.apache.karaf.features.internal.download.StreamProvider;
import org.apache.karaf.features.internal.download.impl.DownloadManagerHelper;
import org.apache.karaf.features.internal.model.Bundle;
import org.apache.karaf.features.internal.model.Conditional;
import org.apache.karaf.features.internal.model.ConfigFile;
import org.apache.karaf.features.internal.model.Dependency;
import org.apache.karaf.features.internal.model.Feature;
import org.apache.karaf.features.internal.model.Features;
import org.apache.karaf.features.internal.model.JacksonUtil;
import org.apache.karaf.features.internal.model.JaxbUtil;
import org.apache.karaf.features.internal.model.processing.FeaturesProcessing;
import org.apache.karaf.features.internal.service.Blacklist;
import org.apache.karaf.features.internal.service.Deployer;
import org.apache.karaf.features.internal.service.FeaturesProcessor;
import org.apache.karaf.features.internal.service.FeaturesProcessorImpl;
import org.apache.karaf.features.internal.service.Overrides;
import org.apache.karaf.features.internal.util.MapUtils;
import org.apache.karaf.features.internal.util.MultiException;
import org.apache.karaf.kar.internal.Kar;
import org.apache.karaf.profile.Profile;
import org.apache.karaf.profile.ProfileBuilder;
import org.apache.karaf.profile.assembly.ArtifactInstaller;
import org.apache.karaf.profile.assembly.AssemblyDeployCallback;
import org.apache.karaf.profile.assembly.ConfigInstaller;
import org.apache.karaf.profile.assembly.CustomDownloadManager;
import org.apache.karaf.profile.assembly.FakeBundleRevision;
import org.apache.karaf.profile.assembly.FeatureSelector;
import org.apache.karaf.profile.assembly.Slf4jResolverLog;
import org.apache.karaf.profile.assembly.URIAwareComparator;
import org.apache.karaf.profile.impl.Profiles;
import org.apache.karaf.tools.utils.KarafPropertiesEditor;
import org.apache.karaf.tools.utils.model.KarafPropertyEdits;
import org.apache.karaf.util.ThreadUtils;
import org.apache.karaf.util.Version;
import org.apache.karaf.util.config.PropertiesLoader;
import org.ops4j.pax.url.mvn.MavenResolver;
import org.ops4j.pax.url.mvn.MavenResolvers;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.resource.Resource;
import org.osgi.service.repository.Repository;
import org.osgi.service.resolver.Resolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Builder {
    private static final String STATIC_FEATURES_KAR = "mvn:org.apache.karaf.features/static/%s/kar";
    private static final Logger LOGGER = LoggerFactory.getLogger(Builder.class);
    private static final String FEATURES_REPOSITORIES = "featuresRepositories";
    private static final String FEATURES_BOOT = "featuresBoot";
    private static final String LIBRARY_CLAUSE_TYPE = "type";
    private static final String LIBRARY_CLAUSE_EXPORT = "export";
    private static final String LIBRARY_CLAUSE_DELEGATE = "delegate";
    private static final String START_LEVEL = "start-level";
    public static final String ORG_OPS4J_PAX_URL_MVN_PID = "org.ops4j.pax.url.mvn";
    List<String> profilesUris = new ArrayList<String>();
    boolean defaultAddAll = true;
    Stage defaultStage = Stage.Startup;
    Map<String, RepositoryInfo> kars = new LinkedHashMap<String, RepositoryInfo>();
    Map<String, Stage> profiles = new LinkedHashMap<String, Stage>();
    Map<String, RepositoryInfo> repositories = new LinkedHashMap<String, RepositoryInfo>();
    Map<String, Stage> features = new LinkedHashMap<String, Stage>();
    Set<String> firstStageBootFeatures = new HashSet<String>();
    Map<String, Stage> bundles = new LinkedHashMap<String, Stage>();
    List<String> blacklistedProfileNames = new ArrayList<String>();
    List<String> blacklistedFeatureIdentifiers = new ArrayList<String>();
    List<String> blacklistedBundleURIs = new ArrayList<String>();
    List<String> blacklistedRepositoryURIs = new ArrayList<String>();
    BlacklistPolicy blacklistPolicy = BlacklistPolicy.Discard;
    List<String> libraries = new ArrayList<String>();
    JavaVersion javase = JavaVersion.Java8;
    KarafVersion karafVersion = KarafVersion.v4x;
    String environment = null;
    boolean useReferenceUrls;
    boolean ignoreDependencyFlag;
    int defaultStartLevel = 50;
    Path homeDirectory;
    Path featuresProcessingLocation;
    boolean offline;
    String localRepository;
    String mavenRepositories;
    Map<String, String> config = new LinkedHashMap<String, String>();
    Map<String, String> system = new LinkedHashMap<String, String>();
    List<String> pidsToExtract = new LinkedList<String>();
    boolean writeProfiles;
    String generateConsistencyReport;
    String consistencyReportProjectName;
    String consistencyReportProjectVersion;
    int resolverParallelism = Math.max(2, Runtime.getRuntime().availableProcessors());
    private ScheduledExecutorService executor;
    private DownloadManager manager;
    private Resolver resolver;
    private Path etcDirectory;
    private Path systemDirectory;
    private Map<String, Profile> allProfiles;
    private KarafPropertyEdits propertyEdits;
    private FeaturesProcessing featuresProcessing = new FeaturesProcessing();
    private Map<String, String> translatedUrls;
    private Blacklist blacklist;
    private String generatedBootFeatureName;
    private Function<MavenResolver, MavenResolver> resolverWrapper = Function.identity();
    private ReportFlavor all = new ReportFlavor(){

        @Override
        public String name() {
            return "all";
        }

        @Override
        public boolean include(Features repository) {
            return true;
        }

        @Override
        public boolean include(Feature feature) {
            return true;
        }

        @Override
        public boolean include(BundleInfo bundle) {
            return true;
        }
    };
    private ReportFlavor notBlacklisted = new ReportFlavor(){

        @Override
        public String name() {
            return "available";
        }

        @Override
        public boolean include(Features repository) {
            return !repository.isBlacklisted();
        }

        @Override
        public boolean include(Feature feature) {
            return !feature.isBlacklisted();
        }

        @Override
        public boolean include(BundleInfo bundle) {
            return !bundle.isBlacklisted();
        }
    };

    public static Builder newInstance() {
        return new Builder();
    }

    public Builder defaultStage(Stage stage) {
        this.defaultStage = stage;
        return this;
    }

    public Builder defaultAddAll(boolean addAll) {
        this.defaultAddAll = addAll;
        return this;
    }

    public Builder profilesUris(String ... profilesUri) {
        Collections.addAll(this.profilesUris, profilesUri);
        return this;
    }

    public Builder libraries(String ... libraries) {
        Collections.addAll(this.libraries, libraries);
        return this;
    }

    public Builder kars(String ... kars) {
        return this.kars(this.defaultStage, this.defaultAddAll, kars);
    }

    public Builder kars(boolean addAll, String ... kars) {
        return this.kars(this.defaultStage, addAll, kars);
    }

    public Builder kars(Stage stage, boolean addAll, String ... kars) {
        for (String kar : kars) {
            this.kars.put(kar, new RepositoryInfo(stage, addAll));
        }
        return this;
    }

    public Builder repositories(String ... repositories) {
        return this.repositories(this.defaultStage, this.defaultAddAll, repositories);
    }

    public Builder repositories(boolean addAll, String ... repositories) {
        return this.repositories(this.defaultStage, addAll, repositories);
    }

    public Builder repositories(Stage stage, boolean addAll, String ... repositories) {
        for (String repository : repositories) {
            this.repositories.put(repository, new RepositoryInfo(stage, addAll));
        }
        return this;
    }

    public Builder firstStageBootFeatures(String ... features) {
        this.firstStageBootFeatures.addAll(Arrays.asList(features));
        return this.features(Stage.Boot, features);
    }

    public Builder features(String ... features) {
        return this.features(this.defaultStage, features);
    }

    public Builder features(Stage stage, String ... features) {
        for (String feature : features) {
            this.features.put(feature, stage);
        }
        return this;
    }

    public Builder bundles(String ... bundles) {
        return this.bundles(this.defaultStage, bundles);
    }

    public Builder bundles(Stage stage, String ... bundles) {
        for (String bundle : bundles) {
            this.bundles.put(bundle, stage);
        }
        return this;
    }

    public Builder profiles(String ... profiles) {
        return this.profiles(this.defaultStage, profiles);
    }

    public Builder profiles(Stage stage, String ... profiles) {
        for (String profile : profiles) {
            this.profiles.put(profile, stage);
        }
        return this;
    }

    public Builder homeDirectory(Path homeDirectory) {
        if (homeDirectory == null) {
            throw new IllegalArgumentException("homeDirectory is null");
        }
        this.homeDirectory = homeDirectory;
        return this;
    }

    public Builder javase(String javase) {
        if (javase == null) {
            throw new IllegalArgumentException("javase is null");
        }
        this.javase = JavaVersion.from(javase);
        return this;
    }

    public Builder environment(String environment) {
        this.environment = environment;
        return this;
    }

    public Builder useReferenceUrls() {
        return this.useReferenceUrls(true);
    }

    public Builder useReferenceUrls(boolean useReferenceUrls) {
        this.useReferenceUrls = useReferenceUrls;
        return this;
    }

    public Builder resolverParallelism(int resolverParallelism) {
        this.resolverParallelism = resolverParallelism;
        return this;
    }

    public void writeProfiles(boolean writeProfiles) {
        this.writeProfiles = writeProfiles;
    }

    public void generateConsistencyReport(String generateConsistencyReport) {
        this.generateConsistencyReport = generateConsistencyReport;
    }

    public void setConsistencyReportProjectName(String consistencyReportProjectName) {
        this.consistencyReportProjectName = consistencyReportProjectName;
    }

    public void setConsistencyReportProjectVersion(String consistencyReportProjectVersion) {
        this.consistencyReportProjectVersion = consistencyReportProjectVersion;
    }

    public Builder karafVersion(KarafVersion karafVersion) {
        this.karafVersion = karafVersion;
        return this;
    }

    public Builder defaultStartLevel(int defaultStartLevel) {
        this.defaultStartLevel = defaultStartLevel;
        return this;
    }

    public Builder setFeaturesProcessing(Path featuresProcessing) {
        this.featuresProcessingLocation = featuresProcessing;
        return this;
    }

    public Builder ignoreDependencyFlag() {
        return this.ignoreDependencyFlag(true);
    }

    public Builder ignoreDependencyFlag(boolean ignoreDependencyFlag) {
        this.ignoreDependencyFlag = ignoreDependencyFlag;
        return this;
    }

    public Builder offline() {
        return this.offline(true);
    }

    public Builder offline(boolean offline) {
        this.offline = offline;
        return this;
    }

    public Builder localRepository(String localRepository) {
        this.localRepository = localRepository;
        return this;
    }

    public Builder mavenRepositories(String mavenRepositories) {
        this.mavenRepositories = mavenRepositories;
        return this;
    }

    public Builder resolverWrapper(Function<MavenResolver, MavenResolver> wrapper) {
        this.resolverWrapper = wrapper;
        return this;
    }

    public Builder staticFramework() {
        return this.staticFramework(Version.karafVersion());
    }

    public Builder staticFramework(String version) {
        String staticFeaturesKar = String.format(STATIC_FEATURES_KAR, version);
        return this.defaultStage(Stage.Startup).useReferenceUrls().kars(Stage.Startup, true, staticFeaturesKar);
    }

    public Builder blacklistProfiles(Collection<String> profiles) {
        this.blacklistedProfileNames.addAll(profiles);
        return this;
    }

    public Builder blacklistFeatures(Collection<String> features) {
        this.blacklistedFeatureIdentifiers.addAll(features);
        return this;
    }

    public Builder blacklistBundles(Collection<String> bundles) {
        this.blacklistedBundleURIs.addAll(bundles);
        return this;
    }

    public Builder extraProtocols(Collection<String> protocols) {
        DownloadManagerHelper.setExtraProtocols(protocols);
        return this;
    }

    public Builder blacklistRepositories(Collection<String> repositories) {
        this.blacklistedRepositoryURIs.addAll(repositories);
        return this;
    }

    public Builder blacklistPolicy(BlacklistPolicy policy) {
        this.blacklistPolicy = policy;
        return this;
    }

    public Builder propertyEdits(KarafPropertyEdits propertyEdits) {
        this.propertyEdits = propertyEdits;
        return this;
    }

    public Builder pidsToExtract(List<String> pidsToExtract) {
        if (pidsToExtract != null) {
            for (String pid : pidsToExtract) {
                this.pidsToExtract.add(pid.trim());
            }
        }
        return this;
    }

    public Builder translatedUrls(Map<String, String> translatedUrls) {
        this.translatedUrls = translatedUrls;
        return this;
    }

    public Builder config(String key, String value) {
        this.config.put(key, value);
        return this;
    }

    public Builder system(String key, String value) {
        this.system.put(key, value);
        return this;
    }

    public List<String> getBlacklistedProfileNames() {
        return this.blacklistedProfileNames;
    }

    public List<String> getBlacklistedFeatureIdentifiers() {
        return this.blacklistedFeatureIdentifiers;
    }

    public List<String> getBlacklistedBundleURIs() {
        return this.blacklistedBundleURIs;
    }

    public List<String> getBlacklistedRepositoryURIs() {
        return this.blacklistedRepositoryURIs;
    }

    public BlacklistPolicy getBlacklistPolicy() {
        return this.blacklistPolicy;
    }

    public List<String> getPidsToExtract() {
        return this.pidsToExtract;
    }

    public void generateAssembly() throws Exception {
        if (this.javase == null) {
            throw new IllegalArgumentException("javase is not set");
        }
        if (this.homeDirectory == null) {
            throw new IllegalArgumentException("homeDirectory is not set");
        }
        try {
            this.executor = Executors.newScheduledThreadPool(8, ThreadUtils.namedThreadFactory("builder"));
            this.systemDirectory = this.homeDirectory.resolve("system");
            this.etcDirectory = this.homeDirectory.resolve("etc");
            this.doGenerateAssembly();
        }
        finally {
            if (this.executor != null) {
                this.executor.shutdownNow();
            }
        }
    }

    private void doGenerateAssembly() throws Exception {
        LOGGER.info("Generating Karaf assembly: " + this.homeDirectory);
        MavenResolver resolver = this.createMavenResolver();
        this.manager = new CustomDownloadManager(resolver, this.executor, null, this.translatedUrls);
        this.resolver = new ResolverImpl((org.apache.felix.resolver.Logger)new Slf4jResolverLog(LOGGER), this.resolverParallelism);
        LOGGER.info("Unzipping kars");
        Downloader downloader = this.manager.createDownloader();
        for (String kar : this.kars.keySet()) {
            downloader.download(kar, null);
        }
        downloader.await();
        for (String karUri : this.kars.keySet()) {
            LOGGER.info("   processing KAR: " + karUri);
            Kar kar = new Kar(((StreamProvider)this.manager.getProviders().get(karUri)).getFile().toURI());
            kar.extract(this.systemDirectory.toFile(), this.homeDirectory.toFile());
            RepositoryInfo info = this.kars.get(karUri);
            for (URI repositoryUri : kar.getFeatureRepos()) {
                LOGGER.info("      found repository: " + repositoryUri);
                this.repositories.put(repositoryUri.toString(), info);
            }
        }
        LOGGER.info("Loading profiles from:");
        this.profilesUris.forEach(p -> LOGGER.info("   " + p));
        this.allProfiles = this.loadExternalProfiles(this.profilesUris);
        if (this.allProfiles.size() > 0) {
            StringBuilder sb = new StringBuilder();
            LOGGER.info("   Found profiles: " + String.join((CharSequence)", ", this.allProfiles.keySet()));
        }
        Profile initialProfile = ProfileBuilder.Factory.create("initial").setParents(new ArrayList<String>(this.profiles.keySet())).getProfile();
        Profile initialOverlay = Profiles.getOverlay(initialProfile, this.allProfiles, this.environment);
        Profile initialEffective = Profiles.getEffective(initialOverlay, false);
        this.blacklist = this.processBlacklist(initialEffective);
        boolean needFeaturesProcessorFileCopy = false;
        String existingProcessorDefinitionURI = null;
        Path existingProcessorDefinition = this.etcDirectory.resolve("org.apache.karaf.features.xml");
        if (existingProcessorDefinition.toFile().isFile()) {
            existingProcessorDefinitionURI = existingProcessorDefinition.toFile().toURI().toString();
            LOGGER.info("Found existing features processor configuration: {}", (Object)this.homeDirectory.relativize(existingProcessorDefinition));
        }
        if (this.featuresProcessingLocation != null && this.featuresProcessingLocation.toFile().isFile() && !this.featuresProcessingLocation.equals(existingProcessorDefinition)) {
            if (existingProcessorDefinitionURI != null) {
                LOGGER.warn("Explicitly configured {} will be used for features processor configuration.", (Object)this.homeDirectory.relativize(this.featuresProcessingLocation));
            } else {
                LOGGER.info("Found features processor configuration: {}", (Object)this.homeDirectory.relativize(this.featuresProcessingLocation));
            }
            existingProcessorDefinitionURI = this.featuresProcessingLocation.toFile().toURI().toString();
            needFeaturesProcessorFileCopy = true;
        }
        FeaturesProcessorImpl processor = new FeaturesProcessorImpl(existingProcessorDefinitionURI, null, this.blacklist, new HashSet());
        Set<String> overrides = this.processOverrides(initialEffective.getOverrides());
        processor.addOverrides(overrides);
        LOGGER.info("Loading repositories");
        Map<String, Features> karRepositories = this.loadRepositories(this.manager, this.repositories.keySet(), false, (FeaturesProcessor)processor);
        for (String repo : this.repositories.keySet()) {
            RepositoryInfo info = this.repositories.get(repo);
            if (!info.addAll) continue;
            LOGGER.info("   adding all non-blacklisted features from repository: " + repo + " (stage: " + (Object)((Object)info.stage) + ")");
            for (Feature feature : karRepositories.get(repo).getFeature()) {
                if (feature.isBlacklisted()) {
                    LOGGER.info("      feature {}/{} is blacklisted - skipping.", (Object)feature.getId(), (Object)feature.getVersion());
                    continue;
                }
                this.features.put(feature.getId(), info.stage);
            }
        }
        Profile startupProfile = this.generateProfile(Stage.Startup, this.profiles, this.repositories, this.features, this.bundles);
        this.allProfiles.put(startupProfile.getId(), startupProfile);
        this.profiles.put(startupProfile.getId(), Stage.Boot);
        Profile bootProfile = this.generateProfile(Stage.Boot, this.profiles, this.repositories, this.features, this.bundles);
        this.allProfiles.put(bootProfile.getId(), bootProfile);
        Profile installedProfile = this.generateProfile(Stage.Installed, this.profiles, this.repositories, this.features, this.bundles);
        this.allProfiles.put(installedProfile.getId(), installedProfile);
        ProfileBuilder builder = ProfileBuilder.Factory.create(UUID.randomUUID().toString()).setParents(Arrays.asList(startupProfile.getId(), bootProfile.getId(), installedProfile.getId()));
        this.config.forEach((k, v) -> builder.addConfiguration("profile", "config." + k, v));
        this.system.forEach((k, v) -> builder.addConfiguration("profile", "system." + k, v));
        this.blacklistedRepositoryURIs.forEach(builder::addBlacklistedRepository);
        this.blacklistedFeatureIdentifiers.forEach(builder::addBlacklistedFeature);
        this.blacklistedBundleURIs.forEach(builder::addBlacklistedBundle);
        Profile overallProfile = builder.getProfile();
        Profile overallOverlay = Profiles.getOverlay(overallProfile, this.allProfiles, this.environment);
        Profile overallEffective = Profiles.getEffective(overallOverlay, false);
        if (this.writeProfiles) {
            Path profiles = this.etcDirectory.resolve("profiles");
            LOGGER.info("Adding profiles to {}", (Object)this.homeDirectory.relativize(profiles));
            this.allProfiles.forEach((id, profile) -> {
                try {
                    Profiles.writeProfile(profiles, profile);
                }
                catch (IOException e) {
                    LOGGER.warn("Problem writing profile {}: {}", id, (Object)e.getMessage());
                }
            });
        }
        this.manager = new CustomDownloadManager(resolver, this.executor, overallEffective, this.translatedUrls);
        LOGGER.info("Configuring etc/config.properties and etc/system.properties");
        Path configPropertiesPath = this.etcDirectory.resolve("config.properties");
        Properties configProperties = new Properties(configPropertiesPath.toFile());
        configProperties.putAll(overallEffective.getConfig());
        configProperties.save();
        Path systemPropertiesPath = this.etcDirectory.resolve("system.properties");
        Properties systemProperties = new Properties(systemPropertiesPath.toFile());
        systemProperties.putAll(overallEffective.getSystem());
        systemProperties.save();
        downloader = this.manager.createDownloader();
        LOGGER.info("Downloading libraries for generated profiles");
        this.downloadLibraries(downloader, configProperties, overallEffective.getLibraries(), "");
        LOGGER.info("Downloading additional libraries");
        this.downloadLibraries(downloader, configProperties, this.libraries, "");
        downloader.await();
        this.reformatClauses(configProperties, "org.osgi.framework.system.packages.extra");
        this.reformatClauses(configProperties, "org.osgi.framework.bootdelegation");
        configProperties.save();
        LOGGER.info("Writing configurations");
        for (Map.Entry<String, byte[]> config : overallEffective.getFileConfigurations().entrySet()) {
            Path configFile = this.etcDirectory.resolve(config.getKey());
            if (Files.exists(configFile, new LinkOption[0])) {
                LOGGER.info("   not changing existing config file: {}", (Object)this.homeDirectory.relativize(configFile));
                continue;
            }
            LOGGER.info("   adding config file: {}", (Object)this.homeDirectory.relativize(configFile));
            Files.createDirectories(configFile.getParent(), new FileAttribute[0]);
            Files.write(configFile, config.getValue(), new OpenOption[0]);
        }
        if (processor.hasInstructions()) {
            Path featuresProcessingXml = this.etcDirectory.resolve("org.apache.karaf.features.xml");
            if (this.hasOwnInstructions() || overrides.size() > 0) {
                try (FileOutputStream fos = new FileOutputStream(featuresProcessingXml.toFile());){
                    LOGGER.info("Generating features processor configuration: {}", (Object)this.homeDirectory.relativize(featuresProcessingXml));
                    processor.writeInstructions((OutputStream)fos);
                }
            } else if (needFeaturesProcessorFileCopy) {
                LOGGER.info("Copying features processor configuration: {} -> {}", (Object)this.homeDirectory.relativize(this.featuresProcessingLocation), (Object)this.homeDirectory.relativize(featuresProcessingXml));
                Files.copy(this.featuresProcessingLocation, featuresProcessingXml, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        Profile startupEffective = this.startupStage(startupProfile, (FeaturesProcessor)processor);
        Set<Feature> allBootFeatures = this.bootStage(bootProfile, startupEffective, (FeaturesProcessor)processor);
        Set<Feature> allInstalledFeatures = this.installStage(installedProfile, allBootFeatures, (FeaturesProcessor)processor);
        if (this.propertyEdits != null) {
            KarafPropertiesEditor editor = new KarafPropertiesEditor();
            editor.setInputEtc(this.etcDirectory.toFile()).setOutputEtc(this.etcDirectory.toFile()).setEdits(this.propertyEdits);
            editor.run();
        }
        if (this.generateConsistencyReport != null) {
            File directory = new File(this.generateConsistencyReport);
            if (directory.isFile()) {
                LOGGER.warn("Can't generate consistency report into {} - it's not a directory", (Object)this.generateConsistencyReport);
            } else {
                if (!directory.exists()) {
                    directory.mkdirs();
                }
                if (directory.isDirectory()) {
                    LOGGER.info("Writing bundle report");
                    this.generateConsistencyReport(karRepositories, allInstalledFeatures, installedProfile, new File(directory, "bundle-report.xml"));
                    Files.copy(this.getClass().getResourceAsStream("/bundle-report.xslt"), directory.toPath().resolve("bundle-report.xslt"), StandardCopyOption.REPLACE_EXISTING);
                }
            }
        }
    }

    public void generateConsistencyReport(Map<String, Features> repositories, Set<Feature> allInstalledFeatures, Profile installedProfile, File result) {
        Profile installedOverlay = Profiles.getOverlay(installedProfile, this.allProfiles, this.environment);
        Profile installedEffective = Profiles.getEffective(installedOverlay, false);
        ArrayList<String> installFeatures = new ArrayList<String>();
        installFeatures.add(this.generatedBootFeatureName);
        installFeatures.addAll(installedEffective.getFeatures());
        FeatureSelector selector = new FeatureSelector(allInstalledFeatures);
        final Set<Feature> effectiveInstalledFeatures = selector.getMatching(installFeatures);
        if (result == null) {
            return;
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(result));){
            ReportFlavor[] flavors;
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            writer.write("<?xml-stylesheet type=\"text/xsl\" href=\"bundle-report.xslt\"?>\n");
            writer.write("<consistency-report xmlns=\"urn:apache:karaf:consistency:1.0\" project=\"" + this.consistencyReportProjectName + "\" version=\"" + this.consistencyReportProjectVersion + "\">\n");
            for (ReportFlavor flavor : flavors = new ReportFlavor[]{this.all, this.notBlacklisted, new ReportFlavor(){

                @Override
                public String name() {
                    return "installed";
                }

                @Override
                public boolean include(Features repository) {
                    return !repository.isBlacklisted();
                }

                @Override
                public boolean include(Feature feature) {
                    return !feature.isBlacklisted() && effectiveInstalledFeatures.contains(feature);
                }

                @Override
                public boolean include(BundleInfo bundle) {
                    return !bundle.isBlacklisted();
                }
            }}) {
                writer.write("<report flavor=\"" + flavor.name() + "\">\n");
                HashMap featureId2repository = new HashMap();
                TreeMap bundle2featureId = new TreeMap(new URIAwareComparator());
                TreeMap<String, List> ga2uri = new TreeMap<String, List>();
                HashSet haveDuplicates = new HashSet();
                repositories.forEach((name, features) -> {
                    if (flavor.include((Features)features)) {
                        features.getFeature().forEach(feature -> {
                            if (flavor.include((Feature)feature)) {
                                featureId2repository.put(feature.getId(), name);
                                feature.getBundle().forEach(bundle -> {
                                    if (flavor.include((BundleInfo)bundle)) {
                                        bundle2featureId.computeIfAbsent(bundle.getLocation().trim(), k -> new TreeSet()).add(feature.getId());
                                    }
                                });
                                feature.getConditional().forEach(cond -> cond.asFeature().getBundles().forEach(bundle -> {
                                    if (flavor.include((BundleInfo)bundle)) {
                                        bundle2featureId.computeIfAbsent(bundle.getLocation().trim(), k -> new TreeSet()).add(feature.getId());
                                    }
                                }));
                            }
                        });
                    }
                });
                bundle2featureId.keySet().forEach(uri -> {
                    String originalUri = uri;
                    if (uri.startsWith("wrap:mvn:")) {
                        if ((uri = uri.substring(5)).indexOf(";") > 0) {
                            uri = uri.substring(0, uri.indexOf(";"));
                        }
                        if (uri.indexOf("$") > 0) {
                            uri = uri.substring(0, uri.indexOf("$"));
                        }
                    }
                    if (uri.startsWith("mvn:")) {
                        try {
                            LocationPattern pattern = new LocationPattern(uri);
                            String ga = String.format("%s/%s", pattern.getGroupId(), pattern.getArtifactId());
                            ga2uri.computeIfAbsent(ga, k -> new LinkedList()).add(originalUri);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                });
                ga2uri.values().forEach(l -> {
                    if (l.size() > 1) {
                        haveDuplicates.addAll(l);
                    }
                });
                writer.write("    <duplicates>\n");
                ga2uri.forEach((key, uris) -> {
                    if (uris.size() > 1) {
                        try {
                            writer.write(String.format("        <duplicate ga=\"%s\">\n", key));
                            for (String uri : uris) {
                                writer.write(String.format("            <bundle uri=\"%s\">\n", this.sanitize(uri)));
                                for (String fid : (Set)bundle2featureId.get(uri)) {
                                    writer.write(String.format("                <feature repository=\"%s\">%s</feature>\n", featureId2repository.get(fid), fid));
                                }
                                writer.write("            </bundle>\n");
                            }
                            writer.write("        </duplicate>\n");
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                });
                writer.write("    </duplicates>\n");
                writer.write("    <bundles>\n");
                for (String uri2 : bundle2featureId.keySet()) {
                    writer.write(String.format("        <bundle uri=\"%s\" duplicate=\"%b\">\n", this.sanitize(uri2), haveDuplicates.contains(uri2)));
                    for (String fid : (Set)bundle2featureId.get(uri2)) {
                        writer.write(String.format("            <feature>%s</feature>\n", fid));
                    }
                    writer.write("        </bundle>\n");
                }
                writer.write("    </bundles>\n");
                writer.write("</report>\n");
            }
            writer.write("</consistency-report>\n");
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public String sanitize(String uri) {
        return uri.replaceAll("&", "&amp;").replaceAll(">", "&lt;").replaceAll("<", "&gt;").replaceAll("\"", "&quot;");
    }

    private boolean hasOwnInstructions() {
        int count = 0;
        count += this.blacklistedRepositoryURIs.size();
        count += this.blacklistedFeatureIdentifiers.size();
        return (count += this.blacklistedBundleURIs.size()) > 0;
    }

    private Set<String> processOverrides(List<String> profileOverrides) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        Path existingOverridesLocation = this.etcDirectory.resolve("overrides.properties");
        if (existingOverridesLocation.toFile().isFile()) {
            LOGGER.warn("Found {} which is deprecated, please use new feature processor configuration.", (Object)this.homeDirectory.relativize(existingOverridesLocation));
            result.addAll(Overrides.loadOverrides((String)existingOverridesLocation.toFile().toURI().toString()));
        }
        result.addAll(profileOverrides);
        return result;
    }

    private Blacklist processBlacklist(Profile initialProfile) throws IOException {
        Blacklist existingBlacklist = null;
        Blacklist blacklist = new Blacklist();
        Path existingBLacklistedLocation = this.etcDirectory.resolve("blacklisted.properties");
        if (existingBLacklistedLocation.toFile().isFile()) {
            LOGGER.warn("Found {} which is deprecated, please use new feature processor configuration.", (Object)this.homeDirectory.relativize(existingBLacklistedLocation));
            existingBlacklist = new Blacklist(Files.readAllLines(existingBLacklistedLocation));
        }
        for (String string : this.blacklistedRepositoryURIs) {
            try {
                blacklist.blacklistRepository(new LocationPattern(string));
            }
            catch (IllegalArgumentException e) {
                LOGGER.warn("Blacklisted features XML repository URI is invalid: {}, ignoring", (Object)string);
            }
        }
        for (LocationPattern locationPattern : initialProfile.getBlacklistedRepositories()) {
            blacklist.blacklistRepository(locationPattern);
        }
        for (String string : this.blacklistedFeatureIdentifiers) {
            blacklist.blacklistFeature(new FeaturePattern(string));
        }
        for (FeaturePattern featurePattern : initialProfile.getBlacklistedFeatures()) {
            blacklist.blacklistFeature(featurePattern);
        }
        for (String string : this.blacklistedBundleURIs) {
            try {
                blacklist.blacklistBundle(new LocationPattern(string));
            }
            catch (IllegalArgumentException e) {
                LOGGER.warn("Blacklisted bundle URI is invalid: {}, ignoring", (Object)string);
            }
        }
        for (LocationPattern locationPattern : initialProfile.getBlacklistedBundles()) {
            blacklist.blacklistBundle(locationPattern);
        }
        if (existingBlacklist != null) {
            blacklist.merge(existingBlacklist);
        }
        return blacklist;
    }

    private MavenResolver createMavenResolver() {
        Hashtable<String, String> props = new Hashtable<String, String>();
        if (this.offline) {
            ((Dictionary)props).put("org.ops4j.pax.url.mvnoffline", "true");
        }
        if (this.localRepository != null) {
            ((Dictionary)props).put("org.ops4j.pax.url.mvn.localRepository", this.localRepository);
        }
        if (this.mavenRepositories != null) {
            ((Dictionary)props).put("org.ops4j.pax.url.mvn.repositories", this.mavenRepositories);
        }
        MavenResolver resolver = MavenResolvers.createMavenResolver(props, (String)ORG_OPS4J_PAX_URL_MVN_PID);
        return this.resolverWrapper.apply(resolver);
    }

    private Map<String, Profile> loadExternalProfiles(List<String> profilesUris) throws IOException, MultiException, InterruptedException {
        LinkedHashMap<String, Profile> profiles = new LinkedHashMap<String, Profile>();
        LinkedHashMap<String, Profile> filteredProfiles = new LinkedHashMap<String, Profile>();
        for (String profilesUri : profilesUris) {
            Path profilePath;
            String uri = profilesUri;
            if (uri.startsWith("jar:") && uri.contains("!/")) {
                uri = uri.substring("jar:".length(), uri.indexOf("!/"));
            }
            if (!uri.startsWith("file:")) {
                Downloader downloader = this.manager.createDownloader();
                downloader.download(uri, null);
                downloader.await();
                StreamProvider provider = (StreamProvider)this.manager.getProviders().get(uri);
                profilesUri = profilesUri.replace(uri, provider.getFile().toURI().toString());
            }
            URI profileURI = URI.create(profilesUri);
            try {
                profilePath = Paths.get(profileURI);
            }
            catch (FileSystemNotFoundException e) {
                FileSystem fs = FileSystems.newFileSystem(profileURI, new HashMap(), Builder.class.getClassLoader());
                profilePath = fs.provider().getPath(profileURI);
            }
            profiles.putAll(Profiles.loadProfiles(profilePath));
            List blacklistedProfilePatterns = this.blacklistedProfileNames.stream().map(ProfileNamePattern::new).collect(Collectors.toList());
            for (String profileName : profiles.keySet()) {
                boolean blacklisted = false;
                for (ProfileNamePattern pattern : blacklistedProfilePatterns) {
                    if (!pattern.matches(profileName)) continue;
                    LOGGER.info("   blacklisting profile {} from {}", (Object)profileName, (Object)profilePath);
                    if (this.blacklistPolicy == BlacklistPolicy.Discard) {
                        filteredProfiles.put(profileName, ProfileBuilder.Factory.create(profileName).getProfile());
                    }
                    blacklisted = true;
                    break;
                }
                if (blacklisted) continue;
                filteredProfiles.put(profileName, (Profile)profiles.get(profileName));
            }
        }
        return filteredProfiles;
    }

    private void reformatClauses(Properties config, String key) {
        String val = config.getProperty(key);
        if (val != null && !val.isEmpty()) {
            List<String> comments = config.getComments(key);
            Clause[] clauses = Parser.parseHeader(val);
            LinkedHashSet<String> strings = new LinkedHashSet<String>();
            for (Clause clause : clauses) {
                strings.add(clause.toString());
            }
            ArrayList<String> lines = new ArrayList<String>();
            lines.add("");
            int index = 0;
            for (String string : strings) {
                String s = "    " + string;
                if (index++ < strings.size() - 1) {
                    s = s + ", ";
                }
                lines.add(s);
            }
            config.put(key, comments, lines);
        }
    }

    void downloadLibraries(Downloader downloader, Properties config, Collection<String> libraries, String indent) throws MalformedURLException {
        Clause[] clauses;
        for (Clause clause : clauses = Parser.parseClauses(libraries.toArray(new String[libraries.size()]))) {
            String path;
            String type;
            String library;
            String filename;
            if (clause.getDirective("url") != null) {
                filename = clause.getName();
                library = clause.getDirective("url");
            } else {
                filename = null;
                library = clause.getName();
            }
            String string = type = clause.getDirective(LIBRARY_CLAUSE_TYPE) != null ? clause.getDirective(LIBRARY_CLAUSE_TYPE) : "default";
            if (!this.javase.supportsEndorsedAndExtLibraries() && ("endorsed".equals(type) || "extension".equals(type))) {
                LOGGER.warn("Ignoring library " + library + " of type " + type + " which is only supported for Java 1.8.");
                continue;
            }
            switch (type) {
                case "endorsed": {
                    path = "lib/endorsed";
                    break;
                }
                case "extension": {
                    path = "lib/ext";
                    break;
                }
                case "boot": {
                    path = "lib/boot";
                    break;
                }
                default: {
                    path = "lib";
                }
            }
            downloader.download(library, provider -> {
                Downloader downloader2 = downloader;
                synchronized (downloader2) {
                    Path input = provider.getFile().toPath();
                    String name = filename != null ? filename : input.getFileName().toString();
                    Path libOutput = this.homeDirectory.resolve(path).resolve(name);
                    if (!libOutput.toFile().getParentFile().isDirectory()) {
                        libOutput.toFile().getParentFile().mkdirs();
                    }
                    LOGGER.info("{}   adding library: {}", (Object)indent, (Object)this.homeDirectory.relativize(libOutput));
                    Files.copy(input, libOutput, StandardCopyOption.REPLACE_EXISTING);
                    if (provider.getUrl().startsWith("mvn:") && type.equals("boot")) {
                        String mvnPath = org.apache.karaf.util.maven.Parser.pathFromMaven(provider.getUrl());
                        Path sysOutput = this.systemDirectory.resolve(mvnPath);
                        Files.createDirectories(sysOutput.getParent(), new FileAttribute[0]);
                        Files.copy(input, sysOutput, StandardCopyOption.REPLACE_EXISTING);
                        libOutput = this.homeDirectory.resolve(path).resolve(name);
                        LOGGER.info("{}   adding maven library: {}", (Object)indent, (Object)provider.getUrl());
                        Files.copy(input, libOutput, StandardCopyOption.REPLACE_EXISTING);
                    }
                }
                boolean export = Boolean.parseBoolean(clause.getDirective(LIBRARY_CLAUSE_EXPORT));
                boolean delegate = Boolean.parseBoolean(clause.getDirective(LIBRARY_CLAUSE_DELEGATE));
                if (export || delegate) {
                    Properties properties = config;
                    synchronized (properties) {
                        Map<String, String> headers = this.getHeaders(provider);
                        String packages = headers.get("Export-Package");
                        if (packages != null) {
                            StringBuilder val;
                            Clause[] clauses1 = Parser.parseHeader(packages);
                            if (export) {
                                val = new StringBuilder(config.getProperty("org.osgi.framework.system.packages.extra"));
                                for (Clause clause1 : clauses1) {
                                    val.append(",").append(clause1.toString());
                                }
                                config.setProperty("org.osgi.framework.system.packages.extra", val.toString());
                            }
                            if (delegate) {
                                val = new StringBuilder(config.getProperty("org.osgi.framework.bootdelegation"));
                                for (Clause clause1 : clauses1) {
                                    val.append(",").append(clause1.getName());
                                }
                                config.setProperty("org.osgi.framework.bootdelegation", val.toString());
                            }
                        }
                    }
                }
            });
        }
    }

    private Set<Feature> installStage(Profile installedProfile, Set<Feature> allBootFeatures, FeaturesProcessor processor) throws Exception {
        LOGGER.info("Install stage");
        Profile installedOverlay = Profiles.getOverlay(installedProfile, this.allProfiles, this.environment);
        Profile installedEffective = Profiles.getEffective(installedOverlay, false);
        Downloader downloader = this.manager.createDownloader();
        LOGGER.info("   Loading installed repositories");
        Map<String, Features> installedRepositories = this.loadRepositories(this.manager, installedEffective.getRepositories(), true, processor);
        HashSet<Feature> allInstalledFeatures = new HashSet<Feature>();
        for (Features repo : installedRepositories.values()) {
            allInstalledFeatures.addAll(repo.getFeature());
        }
        allInstalledFeatures.addAll(allBootFeatures);
        FeatureSelector selector = new FeatureSelector(allInstalledFeatures);
        Set<Feature> installedFeatures = selector.getMatching(installedEffective.getFeatures());
        ArtifactInstaller installer = new ArtifactInstaller(this.systemDirectory, downloader, this.blacklist);
        for (Feature feature : installedFeatures) {
            if (feature.isBlacklisted()) {
                LOGGER.info("   Feature " + feature.getId() + " is blacklisted, ignoring");
                continue;
            }
            LOGGER.info("   Feature {} is defined as an installed feature", (Object)feature.getId());
            for (Bundle bundle : feature.getBundle()) {
                if (this.ignoreDependencyFlag && bundle.isDependency()) continue;
                installer.installArtifact((BundleInfo)bundle);
            }
            for (ConfigFile configFile : feature.getConfigfile()) {
                installer.installArtifact(configFile.getLocation().trim());
            }
            for (Conditional cond : feature.getConditional()) {
                if (cond.isBlacklisted()) {
                    LOGGER.info("   Conditionial " + cond.getConditionId() + " is blacklisted, ignoring");
                }
                for (Bundle bundle : cond.getBundle()) {
                    if (this.ignoreDependencyFlag && bundle.isDependency()) continue;
                    installer.installArtifact((BundleInfo)bundle);
                }
            }
        }
        for (String location : installedEffective.getBundles()) {
            installer.installArtifact(location);
        }
        downloader.await();
        return allInstalledFeatures;
    }

    private Set<Feature> bootStage(Profile bootProfile, Profile startupEffective, FeaturesProcessor processor) throws Exception {
        LOGGER.info("Boot stage");
        Profile bootOverlay = Profiles.getOverlay(bootProfile, this.allProfiles, this.environment);
        Profile bootEffective = Profiles.getEffective(bootOverlay, false);
        LOGGER.info("   Loading boot repositories");
        Map<String, Features> bootRepositories = this.loadRepositories(this.manager, bootEffective.getRepositories(), true, processor);
        HashSet<Feature> allBootFeatures = new HashSet<Feature>();
        for (Features repo : bootRepositories.values()) {
            allBootFeatures.addAll(repo.getFeature());
        }
        HashMap<String, Dependency> generatedDep = new HashMap<String, Dependency>();
        this.generatedBootFeatureName = UUID.randomUUID().toString();
        Feature generated = new Feature();
        generated.setName(this.generatedBootFeatureName);
        for (String nameOrPattern : bootEffective.getFeatures()) {
            for (String dependency : FeatureSelector.getMatchingFeatures(nameOrPattern, bootRepositories.values())) {
                Object dep = (Dependency)generatedDep.get(dependency);
                if (dep == null) {
                    dep = this.createDependency(dependency);
                    generated.getFeature().add(dep);
                    generatedDep.put(dep.getName(), (Dependency)dep);
                }
                dep.setDependency(Boolean.valueOf(false));
                dep.setPrerequisite(Boolean.valueOf(this.firstStageBootFeatures.contains(dep.getName()) || this.firstStageBootFeatures.contains(nameOrPattern)));
            }
        }
        for (String location : bootEffective.getBundles()) {
            location = location.replace("profile:", "file:etc/");
            int intLevel = -100;
            if (location.contains(START_LEVEL)) {
                String level = location.substring(location.indexOf(START_LEVEL));
                if ((level = level.substring(START_LEVEL.length() + 1)).startsWith("\"")) {
                    level = level.substring(1, level.length() - 1);
                }
                intLevel = Integer.parseInt(level);
                LOGGER.debug("bundle start-level: " + level);
                location = location.substring(0, location.indexOf(START_LEVEL) - 1);
                LOGGER.debug("new bundle location after strip start-level: " + location);
            }
            Bundle bun = new Bundle();
            if (intLevel > 0) {
                bun.setStartLevel(Integer.valueOf(intLevel));
            }
            bun.setLocation(location);
            generated.getBundle().add(bun);
        }
        Features rep = new Features();
        rep.setName(UUID.randomUUID().toString());
        rep.getRepository().addAll(bootEffective.getRepositories());
        rep.getFeature().add(generated);
        allBootFeatures.add(generated);
        Downloader downloader = this.manager.createDownloader();
        FeatureSelector selector = new FeatureSelector(allBootFeatures);
        Set<Feature> bootFeatures = selector.getMatching(Collections.singletonList(generated.getName()));
        for (Feature feature : bootFeatures) {
            if (feature.isBlacklisted()) {
                LOGGER.info("   Feature " + feature.getId() + " is blacklisted, ignoring");
                continue;
            }
            LOGGER.info("   Feature " + feature.getId() + " is defined as a boot feature");
            HashSet<Bundle> bundleInfos = new HashSet<Bundle>();
            for (Bundle bundle : feature.getBundle()) {
                if (this.ignoreDependencyFlag && bundle.isDependency()) continue;
                bundleInfos.add(bundle);
            }
            for (Conditional cond : feature.getConditional()) {
                if (cond.isBlacklisted()) {
                    LOGGER.info("   Conditionial " + cond.getConditionId() + " is blacklisted, ignoring");
                }
                for (Bundle bundle : cond.getBundle()) {
                    if (this.ignoreDependencyFlag && bundle.isDependency()) continue;
                    bundleInfos.add(bundle);
                }
            }
            HashMap<String, List<String>> prereqs = new HashMap<String, List<String>>();
            prereqs.put("blueprint:", Arrays.asList("deployer", "aries-blueprint"));
            prereqs.put("spring:", Arrays.asList("deployer", "spring"));
            prereqs.put("wrap:", Collections.singletonList("wrap"));
            prereqs.put("war:", Collections.singletonList("war"));
            ArtifactInstaller installer = new ArtifactInstaller(this.systemDirectory, downloader, this.blacklist);
            for (BundleInfo bundleInfo : bundleInfos) {
                installer.installArtifact(bundleInfo);
                for (Map.Entry entry : prereqs.entrySet()) {
                    if (!bundleInfo.getLocation().trim().startsWith((String)entry.getKey())) continue;
                    for (String prereq : (List)entry.getValue()) {
                        Dependency dep = (Dependency)generatedDep.get(prereq);
                        if (dep == null) {
                            dep = new Dependency();
                            dep.setName(prereq);
                            generated.getFeature().add(dep);
                            generatedDep.put(dep.getName(), dep);
                        }
                        dep.setPrerequisite(Boolean.valueOf(true));
                    }
                }
            }
            new ConfigInstaller(this.etcDirectory, this.pidsToExtract).installConfigs(feature, downloader, installer);
            ArrayList<String> libraries = new ArrayList<String>();
            for (Library library : feature.getLibraries()) {
                String lib = library.getLocation() + ";type:=" + library.getType() + ";export:=" + library.isExport() + ";delegate:=" + library.isDelegate();
                libraries.add(lib);
            }
            Path path = this.etcDirectory.resolve("config.properties");
            Properties configProperties = new Properties(path.toFile());
            this.downloadLibraries(downloader, configProperties, libraries, "   ");
            downloader.await();
            this.reformatClauses(configProperties, "org.osgi.framework.system.packages.extra");
            this.reformatClauses(configProperties, "org.osgi.framework.bootdelegation");
            configProperties.save();
        }
        Path featuresCfgFile = this.etcDirectory.resolve("org.apache.karaf.features.cfg");
        if (!generated.getBundle().isEmpty()) {
            String repoUrl;
            ByteArrayInputStream bais;
            File output = this.etcDirectory.resolve(rep.getName() + ".xml").toFile();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            JaxbUtil.marshal((Features)rep, (OutputStream)baos);
            if (this.karafVersion == KarafVersion.v24) {
                String str = baos.toString();
                str = str.replace("http://karaf.apache.org/xmlns/features/v1.3.0", "http://karaf.apache.org/xmlns/features/v1.2.0");
                str = str.replaceAll(" dependency=\".*?\"", "");
                str = str.replaceAll(" prerequisite=\".*?\"", "");
                for (Feature f : rep.getFeature()) {
                    for (Dependency d : f.getFeature()) {
                        if (!d.isPrerequisite() || startupEffective.getFeatures().contains(d.getName())) continue;
                        LOGGER.warn("Feature " + d.getName() + " is a prerequisite and should be installed as a startup feature.");
                    }
                }
                bais = new ByteArrayInputStream(str.getBytes());
                repoUrl = "file:etc/" + output.getName();
            } else {
                bais = new ByteArrayInputStream(baos.toByteArray());
                repoUrl = "file:${karaf.etc}/" + output.getName();
            }
            Files.copy(bais, output.toPath(), new CopyOption[0]);
            Properties featuresProperties = new Properties(featuresCfgFile.toFile());
            featuresProperties.put(FEATURES_REPOSITORIES, repoUrl);
            featuresProperties.put(FEATURES_BOOT, generated.getName());
            featuresProperties.save();
        } else {
            String repos = this.getRepos(rep);
            String boot = this.getBootFeatures(generatedDep);
            Properties featuresProperties = new Properties(featuresCfgFile.toFile());
            featuresProperties.put(FEATURES_REPOSITORIES, repos);
            featuresProperties.put(FEATURES_BOOT, boot);
            this.reformatClauses(featuresProperties, FEATURES_REPOSITORIES);
            this.reformatClauses(featuresProperties, FEATURES_BOOT);
            featuresProperties.save();
        }
        downloader.await();
        return allBootFeatures;
    }

    private String getRepos(Features rep) {
        StringBuilder repos = new StringBuilder();
        for (String repo : new HashSet(rep.getRepository())) {
            if (repos.length() > 0) {
                repos.append(",");
            }
            repos.append(repo);
        }
        return repos.toString();
    }

    private String getBootFeatures(Map<String, Dependency> generatedDep) {
        StringBuilder boot = new StringBuilder();
        for (Dependency dep : generatedDep.values()) {
            if (!dep.isPrerequisite()) continue;
            if (boot.length() == 0) {
                boot.append("(");
            } else {
                boot.append(",");
            }
            boot.append(dep.getName());
        }
        if (boot.length() > 0) {
            boot.append(")");
        }
        for (Dependency dep : generatedDep.values()) {
            if (dep.isPrerequisite() || dep.isDependency()) continue;
            if (boot.length() > 0) {
                boot.append(",");
            }
            boot.append(dep.getName());
            if ("0.0.0".equals(dep.getVersion())) continue;
            if (this.karafVersion == KarafVersion.v4x) {
                boot.append("/");
            } else {
                boot.append(";version=");
            }
            boot.append(dep.getVersion());
        }
        return boot.toString();
    }

    private Dependency createDependency(String dependency) {
        Dependency dep = new Dependency();
        String[] split = dependency.split("/");
        dep.setName(split[0]);
        if (split.length > 1) {
            dep.setVersion(split[1]);
        }
        return dep;
    }

    private Profile startupStage(Profile startupProfile, FeaturesProcessor processor) throws Exception {
        LOGGER.info("Startup stage");
        Profile startupOverlay = Profiles.getOverlay(startupProfile, this.allProfiles, this.environment);
        Profile startupEffective = Profiles.getEffective(startupOverlay, false);
        LOGGER.info("   Loading startup repositories");
        Map<String, Features> startupRepositories = this.loadRepositories(this.manager, startupEffective.getRepositories(), false, processor);
        LOGGER.info("   Resolving startup features and bundles");
        LOGGER.info("      Features: " + String.join((CharSequence)", ", startupEffective.getFeatures()));
        LOGGER.info("      Bundles: " + String.join((CharSequence)", ", startupEffective.getBundles()));
        Map<String, Integer> bundles = this.resolve(this.manager, this.resolver, startupRepositories.values(), startupEffective.getFeatures(), startupEffective.getBundles(), startupEffective.getOptionals(), processor);
        Properties startup = new Properties();
        startup.setHeader(Collections.singletonList("# Bundles to be started on startup, with startlevel"));
        Map invertedStartupBundles = MapUtils.invert(bundles);
        for (Map.Entry entry : new TreeMap(invertedStartupBundles).entrySet()) {
            String startLevel = Integer.toString((Integer)entry.getKey());
            ArrayList<String> value = new ArrayList<String>((Collection)entry.getValue());
            value.sort(Comparator.comparing(bnd -> startupEffective.getBundles().indexOf(bnd)));
            for (String location : value) {
                if (this.useReferenceUrls) {
                    if (location.startsWith("mvn:")) {
                        location = "file:" + org.apache.karaf.util.maven.Parser.pathFromMaven(location);
                    }
                    if (location.startsWith("file:")) {
                        location = "reference:" + location;
                    }
                }
                if (location.startsWith("file:") && this.karafVersion == KarafVersion.v24) {
                    location = location.substring("file:".length());
                }
                startup.put(location, startLevel);
            }
        }
        Path startupProperties = this.etcDirectory.resolve("startup.properties");
        startup.save(startupProperties.toFile());
        return startupEffective;
    }

    private List<String> getStaged(Stage stage, Map<String, Stage> data) {
        ArrayList<String> staged = new ArrayList<String>();
        for (String s : data.keySet()) {
            if (data.get(s) != stage) continue;
            staged.add(s);
        }
        return staged;
    }

    private List<String> getStagedRepositories(Stage stage, Map<String, RepositoryInfo> data) {
        ArrayList<String> staged = new ArrayList<String>();
        for (String s : data.keySet()) {
            if (data.get((Object)s).stage != stage && (data.get((Object)s).stage != Stage.Startup || stage != Stage.Boot)) continue;
            staged.add(s);
        }
        return staged;
    }

    private Map<String, Features> loadRepositories(DownloadManager manager, Collection<String> repositories, final boolean install, final FeaturesProcessor processor) throws Exception {
        final HashMap<String, Features> loaded = new HashMap<String, Features>();
        final Downloader downloader = manager.createDownloader();
        for (String repository : repositories) {
            downloader.download(repository, new DownloadCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void downloaded(StreamProvider provider) throws Exception {
                    String url = provider.getUrl();
                    if (processor.isRepositoryBlacklisted(url)) {
                        LOGGER.info("   feature repository " + url + " is blacklisted");
                        return;
                    }
                    Map map = loaded;
                    synchronized (map) {
                        if (!loaded.containsKey(provider.getUrl())) {
                            if (install) {
                                StreamProvider streamProvider = provider;
                                synchronized (streamProvider) {
                                    Path path = ArtifactInstaller.pathFromProviderUrl(Builder.this.systemDirectory, url);
                                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                                    LOGGER.info("      adding feature repository: " + url);
                                    Files.copy(provider.getFile().toPath(), path, StandardCopyOption.REPLACE_EXISTING);
                                }
                            }
                            try (InputStream is = provider.open();){
                                Features featuresModel = JacksonUtil.isJson((String)url) ? JacksonUtil.unmarshal((String)url) : JaxbUtil.unmarshal((String)url, (InputStream)is, (boolean)false);
                                featuresModel.setBlacklisted(processor.isRepositoryBlacklisted(url));
                                processor.process(featuresModel);
                                loaded.put(provider.getUrl(), featuresModel);
                                for (String innerRepository : featuresModel.getRepository()) {
                                    if (processor.isRepositoryBlacklisted(innerRepository)) {
                                        LOGGER.info("   referenced feature repository " + innerRepository + " is blacklisted");
                                        continue;
                                    }
                                    downloader.download(innerRepository, (DownloadCallback)this);
                                }
                            }
                        }
                    }
                }
            });
        }
        downloader.await();
        return loaded;
    }

    private Profile generateProfile(Stage stage, Map<String, Stage> parentProfiles, Map<String, RepositoryInfo> repositories, Map<String, Stage> features, Map<String, Stage> bundles) {
        String name = "generated-" + stage.name().toLowerCase();
        List<String> stagedParentProfiles = this.getStaged(stage, parentProfiles);
        if (stagedParentProfiles.isEmpty()) {
            LOGGER.info("Generating {} profile", (Object)name);
        } else {
            LOGGER.info("Generating {} profile with parents: {}", (Object)name, (Object)String.join((CharSequence)", ", stagedParentProfiles));
        }
        return ProfileBuilder.Factory.create(name).setParents(stagedParentProfiles).setRepositories(this.getStagedRepositories(stage, repositories)).setFeatures(this.getStaged(stage, features)).setBundles(this.getStaged(stage, bundles)).getProfile();
    }

    private Map<String, Integer> resolve(DownloadManager manager, Resolver resolver, Collection<Features> repositories, Collection<String> features, Collection<String> bundles, Collection<String> optionals, FeaturesProcessor processor) throws Exception {
        BundleRevision systemBundle = this.getSystemBundle();
        if (this.resolverParallelism > 1) {
            return this.doResolve(manager, resolver, repositories, features, bundles, optionals, processor, systemBundle);
        }
        return features.stream().flatMap(it -> {
            try {
                return this.doResolve(manager, resolver, repositories, Collections.singletonList(it), bundles, optionals, processor, systemBundle).entrySet().stream();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> a));
    }

    private Map<String, Integer> doResolve(DownloadManager manager, Resolver resolver, Collection<Features> repositories, Collection<String> features, Collection<String> bundles, Collection<String> optionals, FeaturesProcessor processor, BundleRevision systemBundle) throws Exception {
        AssemblyDeployCallback callback = new AssemblyDeployCallback(manager, this, systemBundle, repositories, processor);
        Deployer deployer = new Deployer(manager, resolver, (Deployer.DeployCallback)callback);
        Deployer.DeploymentRequest request = Deployer.DeploymentRequest.defaultDeploymentRequest();
        request.globalRepository = this.repositoryOfOptionalResources(manager, optionals);
        for (String feature : features) {
            for (String featureName : FeatureSelector.getMatchingFeatures(feature, repositories)) {
                MapUtils.addToMapSet((Map)request.requirements, (Object)"root", (Object)featureName);
            }
        }
        for (String bundle : bundles) {
            MapUtils.addToMapSet((Map)request.requirements, (Object)"root", (Object)("bundle:" + bundle));
        }
        deployer.deployFully(callback.getDeploymentState(), request);
        return callback.getStartupBundles();
    }

    private Repository repositoryOfOptionalResources(DownloadManager manager, Collection<String> optionals) throws Exception {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        Downloader downloader = manager.createDownloader();
        for (String optional : optionals) {
            downloader.download(optional, provider -> {
                ResourceImpl resource = ResourceBuilder.build(provider.getUrl(), this.getHeaders(provider));
                List list = resources;
                synchronized (list) {
                    resources.add(resource);
                }
            });
        }
        downloader.await();
        return new BaseRepository(resources);
    }

    private BundleRevision getSystemBundle() throws Exception {
        Path configPropPath = this.etcDirectory.resolve("config.properties");
        Properties configProps = PropertiesLoader.loadPropertiesOrFail(configPropPath.toFile());
        configProps.put("java.specification.version", this.javase.version);
        configProps.substitute();
        Attributes attributes = new Attributes();
        attributes.putValue("Bundle-ManifestVersion", "2");
        attributes.putValue("Bundle-SymbolicName", "system.bundle");
        attributes.putValue("Bundle-Version", "0.0.0");
        String exportPackages = configProps.getProperty("org.osgi.framework.system.packages", "");
        if ("".equals(exportPackages.trim())) {
            throw new IllegalArgumentException("\"org.osgi.framework.system.packages\" property should specify system bundle packages. It can't be empty, please check etc/config.properties of the assembly.");
        }
        if (configProps.containsKey("org.osgi.framework.system.packages.extra")) {
            exportPackages = exportPackages + "," + configProps.getProperty("org.osgi.framework.system.packages.extra");
        }
        exportPackages = exportPackages.replaceAll(",\\s*,", ",");
        attributes.putValue("Export-Package", exportPackages);
        String systemCaps = configProps.getProperty("org.osgi.framework.system.capabilities", "");
        attributes.putValue("Provide-Capability", systemCaps);
        Hashtable<String, String> headers = new Hashtable<String, String>();
        for (Map.Entry<Object, Object> attr : attributes.entrySet()) {
            headers.put(attr.getKey().toString(), attr.getValue().toString());
        }
        return new FakeBundleRevision(headers, "system-bundle", 0L);
    }

    private Map<String, String> getHeaders(StreamProvider provider) throws IOException {
        try (ZipInputStream zis = new ZipInputStream(provider.open());){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                if (!"META-INF/MANIFEST.MF".equals(entry.getName())) continue;
                Attributes attributes = new Manifest(zis).getMainAttributes();
                HashMap<String, String> headers = new HashMap<String, String>();
                for (Map.Entry<Object, Object> attr : attributes.entrySet()) {
                    headers.put(attr.getKey().toString(), attr.getValue().toString());
                }
                HashMap<String, String> hashMap = headers;
                return hashMap;
            }
        }
        throw new IllegalArgumentException("Resource " + provider.getUrl() + " does not contain a manifest");
    }

    private static interface ReportFlavor {
        public String name();

        public boolean include(Features var1);

        public boolean include(Feature var1);

        public boolean include(BundleInfo var1);
    }

    private static class ProfileNamePattern {
        private String name;
        private Pattern namePattern;

        public ProfileNamePattern(String profileName) {
            if (profileName == null) {
                throw new IllegalArgumentException("Profile name to match should not be null");
            }
            this.name = profileName;
            if (this.name.contains("*")) {
                this.namePattern = LocationPattern.toRegExp((String)this.name);
            }
        }

        public boolean matches(String profileName) {
            if (profileName == null) {
                return false;
            }
            if (this.namePattern != null) {
                return this.namePattern.matcher(profileName).matches();
            }
            return this.name.equals(profileName);
        }
    }

    static class RepositoryInfo {
        Stage stage;
        boolean addAll;

        public RepositoryInfo(Stage stage, boolean addAll) {
            this.stage = stage;
            this.addAll = addAll;
        }
    }

    public static enum BlacklistPolicy {
        Discard,
        Fail;

    }

    public static enum JavaVersion {
        Java6("1.6", 1),
        Java7("1.7", 2),
        Java8("1.8", 3),
        Java9("9", 4),
        Java10("10", 5),
        Java11("11", 6),
        Java12("12", 7),
        Java13("13", 8),
        Java14("14", 9),
        Java15("15", 10),
        Java16("16", 11),
        Java17("17", 12),
        Java18("18", 13);

        private String version;
        private int ordinal;

        private JavaVersion(String version, int ordinal) {
            this.version = version;
            this.ordinal = ordinal;
        }

        public static JavaVersion from(String version) {
            for (JavaVersion value : JavaVersion.values()) {
                if (!value.version.equals(version)) continue;
                return value;
            }
            throw new IllegalArgumentException("Java version \"" + version + "\" is not supported");
        }

        public boolean supportsEndorsedAndExtLibraries() {
            return this.ordinal < JavaVersion.Java9.ordinal;
        }
    }

    public static enum KarafVersion {
        v24,
        v3x,
        v4x;

    }

    public static enum Stage {
        Startup,
        Boot,
        Installed;


        public static Stage fromMavenScope(String scope) {
            switch (scope) {
                case "compile": {
                    return Startup;
                }
                case "runtime": {
                    return Boot;
                }
                case "provided": {
                    return Installed;
                }
            }
            return null;
        }
    }
}

