/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.profile.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.CRC32;
import org.apache.karaf.features.FeaturePattern;
import org.apache.karaf.features.LocationPattern;
import org.apache.karaf.profile.Profile;
import org.apache.karaf.profile.impl.Utils;

final class ProfileImpl
implements Profile {
    private static final Pattern ALLOWED_PROFILE_NAMES_PATTERN = Pattern.compile("^[A-Za-z0-9]+[.A-Za-z0-9_-]*$");
    private final String profileId;
    private final Map<String, String> attributes;
    private final List<String> parents = new ArrayList<String>();
    private final Map<String, byte[]> fileConfigurations = new HashMap<String, byte[]>();
    private final Map<String, Map<String, Object>> configurations = new HashMap<String, Map<String, Object>>();
    private final boolean isOverlay;
    private int hash;

    ProfileImpl(String profileId, List<String> parents, Map<String, byte[]> fileConfigs, boolean isOverlay) {
        Utils.assertNotNull(profileId, "profileId is null");
        Utils.assertNotNull(parents, "parents is null");
        Utils.assertNotNull(fileConfigs, "fileConfigs is null");
        Utils.assertTrue(ALLOWED_PROFILE_NAMES_PATTERN.matcher(profileId).matches(), "Profile id '" + profileId + "' is invalid. Profile id must be: upper-case or lower-case letters, numbers, and . _ or - characters");
        this.profileId = profileId;
        this.isOverlay = isOverlay;
        this.parents.addAll(parents);
        for (Map.Entry<String, byte[]> entry : fileConfigs.entrySet()) {
            String fileKey = entry.getKey();
            byte[] bytes = entry.getValue();
            this.fileConfigurations.put(fileKey, bytes);
            if (!fileKey.endsWith(".cfg")) continue;
            String pid = fileKey.substring(0, fileKey.indexOf(".cfg"));
            this.configurations.put(pid, Collections.unmodifiableMap(Utils.toProperties(bytes)));
        }
        this.attributes = this.getPrefixedMap("attribute.");
    }

    @Override
    public Map<String, String> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    @Override
    public Map<String, String> getConfig() {
        return this.getPrefixedMap("config.");
    }

    @Override
    public Map<String, String> getSystem() {
        return this.getPrefixedMap("system.");
    }

    @Override
    public String getId() {
        return this.profileId;
    }

    private Map<String, String> getPrefixedMap(String prefix) {
        HashMap<String, String> map = new HashMap<String, String>();
        Map<String, Object> profileConfig = this.configurations.get("profile");
        if (profileConfig != null) {
            int prefixLength = prefix.length();
            for (Map.Entry<String, Object> entry : profileConfig.entrySet()) {
                String key = entry.getKey();
                if (!key.startsWith(prefix)) continue;
                map.put(key.substring(prefixLength), entry.getValue().toString());
            }
        }
        return map;
    }

    @Override
    public List<String> getParentIds() {
        return Collections.unmodifiableList(this.parents);
    }

    @Override
    public List<String> getBundles() {
        return this.getContainerConfigList(ConfigListType.BUNDLES);
    }

    @Override
    public List<String> getFeatures() {
        return this.getContainerConfigList(ConfigListType.FEATURES);
    }

    @Override
    public List<String> getRepositories() {
        return this.getContainerConfigList(ConfigListType.REPOSITORIES);
    }

    @Override
    public List<LocationPattern> getBlacklistedBundles() {
        return this.getContainerConfigList(ConfigListType.BLACKLISTED_BUNDLES).stream().map(LocationPattern::new).collect(Collectors.toList());
    }

    @Override
    public List<FeaturePattern> getBlacklistedFeatures() {
        return this.getContainerConfigList(ConfigListType.BLACKLISTED_FEATURES).stream().map(FeaturePattern::new).collect(Collectors.toList());
    }

    @Override
    public List<LocationPattern> getBlacklistedRepositories() {
        return this.getContainerConfigList(ConfigListType.BLACKLISTED_REPOSITORIES).stream().map(LocationPattern::new).collect(Collectors.toList());
    }

    @Override
    public List<String> getLibraries() {
        return this.getContainerConfigList(ConfigListType.LIBRARIES);
    }

    @Override
    public List<String> getBootLibraries() {
        return this.getContainerConfigList(ConfigListType.BOOT_LIBRARIES);
    }

    @Override
    public List<String> getEndorsedLibraries() {
        return this.getContainerConfigList(ConfigListType.ENDORSED_LIBRARIES);
    }

    @Override
    public List<String> getExtLibraries() {
        return this.getContainerConfigList(ConfigListType.EXT_LIBRARIES);
    }

    @Override
    public List<String> getOverrides() {
        return this.getContainerConfigList(ConfigListType.OVERRIDES);
    }

    @Override
    public List<String> getOptionals() {
        return this.getContainerConfigList(ConfigListType.OPTIONALS);
    }

    @Override
    public boolean isOverlay() {
        return this.isOverlay;
    }

    @Override
    public boolean isAbstract() {
        return this.parseBoolean(this.attributes.get("abstract"));
    }

    @Override
    public boolean isHidden() {
        return this.parseBoolean(this.attributes.get("hidden"));
    }

    private Boolean parseBoolean(Object obj) {
        return obj instanceof Boolean ? (Boolean)obj : obj != null && Boolean.parseBoolean(obj.toString());
    }

    @Override
    public Set<String> getConfigurationFileNames() {
        return Collections.unmodifiableSet(this.fileConfigurations.keySet());
    }

    @Override
    public Map<String, byte[]> getFileConfigurations() {
        return Collections.unmodifiableMap(this.fileConfigurations);
    }

    @Override
    public byte[] getFileConfiguration(String fileName) {
        return this.fileConfigurations.get(fileName);
    }

    @Override
    public Map<String, Map<String, Object>> getConfigurations() {
        return Collections.unmodifiableMap(this.configurations);
    }

    @Override
    public Map<String, Object> getConfiguration(String pid) {
        Map<String, Object> config = this.configurations.get(pid);
        config = config != null ? config : Collections.emptyMap();
        return Collections.unmodifiableMap(config);
    }

    private List<String> getContainerConfigList(ConfigListType type) {
        Map<String, Object> containerProps = this.getConfiguration("profile");
        ArrayList<String> rc = new ArrayList<String>();
        String prefix = type.value + ".";
        for (Map.Entry<String, Object> e : containerProps.entrySet()) {
            if (!e.getKey().startsWith(prefix)) continue;
            rc.add(e.getValue().toString());
        }
        return rc;
    }

    public int hashCode() {
        if (this.hash == 0) {
            CRC32 crc = new CRC32();
            crc.update(this.profileId.getBytes());
            ArrayList<String> keys = new ArrayList<String>(this.fileConfigurations.keySet());
            Collections.sort(keys);
            for (String key : keys) {
                crc.update(key.getBytes());
                crc.update(this.fileConfigurations.get(key));
            }
            this.hash = (int)crc.getValue();
        }
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ProfileImpl)) {
            return false;
        }
        ProfileImpl other = (ProfileImpl)obj;
        return this.profileId.equals(other.profileId) && this.fileConfigurations.equals(other.fileConfigurations);
    }

    public String toString() {
        return "Profile[id=" + this.profileId + ", attrs=" + this.getAttributes() + "]";
    }

    static enum ConfigListType {
        BUNDLES("bundle"),
        BLACKLISTED_BUNDLES("blacklisted.bundle"),
        FEATURES("feature"),
        BLACKLISTED_FEATURES("blacklisted.feature"),
        LIBRARIES("library"),
        BOOT_LIBRARIES("boot"),
        ENDORSED_LIBRARIES("endorsed"),
        EXT_LIBRARIES("ext"),
        OPTIONALS("optional"),
        OVERRIDES("override"),
        REPOSITORIES("repository"),
        BLACKLISTED_REPOSITORIES("blacklisted.repository");

        private String value;

        private ConfigListType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

