/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.api.schema;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DuplicateEntry;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodeContainer;

final class DuplicateFinder {
    private final Map<NormalizedNode, DuplicateEntry> identities = new IdentityHashMap<NormalizedNode, DuplicateEntry>();
    private final Map<NormalizedNode, DuplicateEntry> duplicates = new HashMap<NormalizedNode, DuplicateEntry>();

    private DuplicateFinder() {
    }

    private void findDuplicates(YangInstanceIdentifier path, NormalizedNode node) {
        DuplicateEntry i = this.identities.get(node);
        if (i == null) {
            DuplicateEntry d = this.duplicates.get(node);
            if (d == null) {
                DuplicateEntry n = new DuplicateEntry(path);
                this.identities.put(node, n);
                this.duplicates.put(node, n);
            } else {
                d.addDuplicate(path);
            }
            if (node instanceof NormalizedNodeContainer) {
                Iterator iterator = ((NormalizedNodeContainer)node).body().iterator();
                while (iterator.hasNext()) {
                    NormalizedNode c = (NormalizedNode)iterator.next();
                    this.findDuplicates(path.node(c.getIdentifier()), c);
                }
            }
        } else {
            i.addHardLink(path);
        }
    }

    static Map<NormalizedNode, DuplicateEntry> findDuplicates(NormalizedNode node) {
        DuplicateFinder finder = new DuplicateFinder();
        finder.findDuplicates(YangInstanceIdentifier.empty(), node);
        return finder.identities;
    }
}

