/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.api.schema.stream;

import com.google.common.annotations.Beta;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.stream.AbstractIndentingNormalizedNodeStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public final class LoggingNormalizedNodeStreamWriter
extends AbstractIndentingNormalizedNodeStreamWriter {
    private static final Logger LOG = LoggerFactory.getLogger(LoggingNormalizedNodeStreamWriter.class);

    public LoggingNormalizedNodeStreamWriter() {
    }

    public LoggingNormalizedNodeStreamWriter(int indentSize) {
        super(indentSize);
    }

    @Override
    public void flush() {
        LOG.trace("<<FLUSH>>");
    }

    @Override
    public void close() {
        LOG.debug("<<END-OF-STREAM>>");
    }

    @Override
    void enterUnkeyedListItem(YangInstanceIdentifier.NodeIdentifier name, String indent) {
        LOG.debug("{}{}[](no key)", (Object)indent, (Object)name);
    }

    @Override
    void enterUnkeyedList(YangInstanceIdentifier.NodeIdentifier name, String indent) {
        LOG.debug("{}{}(no key)", (Object)indent, (Object)name);
    }

    @Override
    void enterMapNode(YangInstanceIdentifier.NodeIdentifier name, String indent) {
        LOG.debug("{}{}(key)", (Object)indent, (Object)name);
    }

    @Override
    void enterMapEntryNode(YangInstanceIdentifier.NodeIdentifierWithPredicates identifier, String indent) {
        LOG.debug("{}{}[](key)", (Object)indent, (Object)identifier);
    }

    @Override
    void enterLeafSet(YangInstanceIdentifier.NodeIdentifier name, String indent) {
        LOG.debug("{}{}(leaf-list)", (Object)indent, (Object)name);
    }

    @Override
    void enterContainerNode(YangInstanceIdentifier.NodeIdentifier name, String indent) {
        LOG.debug("{}{}(container)", (Object)indent, (Object)name);
    }

    @Override
    void enterChoiceNode(YangInstanceIdentifier.NodeIdentifier name, String indent) {
        LOG.debug("{}{}(choice)", (Object)indent, (Object)name);
    }

    @Override
    void enterAugmentationNode(YangInstanceIdentifier.AugmentationIdentifier identifier, String indent) {
        LOG.debug("{}{}(augmentation)", (Object)indent, (Object)identifier);
    }

    @Override
    void enterLeafSetEntryNode(YangInstanceIdentifier.NodeWithValue<?> name, String indent) {
        LOG.debug("{}{}(entry}", (Object)indent, (Object)name.getNodeType());
    }

    @Override
    void enterLeafNode(YangInstanceIdentifier.NodeIdentifier name, String indent) {
        LOG.debug("{}{}(leaf)", (Object)indent, (Object)name);
    }

    @Override
    void enterAnyxmlNode(YangInstanceIdentifier.NodeIdentifier name, String indent) {
        LOG.debug("{}{}(anyxml)", (Object)indent, (Object)name);
    }

    @Override
    void enterAnydataNode(YangInstanceIdentifier.NodeIdentifier name, String indent) {
        LOG.debug("{}{}(anydata)", (Object)indent, (Object)name);
    }

    @Override
    void exitNode(String indent) {
        LOG.debug("{}(end)", (Object)indent);
    }

    @Override
    @SuppressFBWarnings(value={"SLF4J_SIGN_ONLY_FORMAT"})
    void scalarValue(Object value, String indent) {
        LOG.debug("{}({})={}", new Object[]{indent, value.getClass().getSimpleName(), value});
    }
}

