/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.ClientConductor;
import io.aeron.DirectBufferVector;
import io.aeron.ExclusivePublicationValues;
import io.aeron.LogBuffers;
import io.aeron.ReservedValueSupplier;
import io.aeron.logbuffer.BufferClaim;
import io.aeron.logbuffer.ExclusiveTermAppender;
import io.aeron.logbuffer.LogBufferDescriptor;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.ReadablePosition;

public final class ExclusivePublication
extends ExclusivePublicationValues {
    byte p064;
    byte p065;
    byte p066;
    byte p067;
    byte p068;
    byte p069;
    byte p070;
    byte p071;
    byte p072;
    byte p073;
    byte p074;
    byte p075;
    byte p076;
    byte p077;
    byte p078;
    byte p079;
    byte p080;
    byte p081;
    byte p082;
    byte p083;
    byte p084;
    byte p085;
    byte p086;
    byte p087;
    byte p088;
    byte p089;
    byte p090;
    byte p091;
    byte p092;
    byte p093;
    byte p094;
    byte p095;
    byte p096;
    byte p097;
    byte p098;
    byte p099;
    byte p100;
    byte p101;
    byte p102;
    byte p103;
    byte p104;
    byte p105;
    byte p106;
    byte p107;
    byte p108;
    byte p109;
    byte p110;
    byte p111;
    byte p112;
    byte p113;
    byte p114;
    byte p115;
    byte p116;
    byte p117;
    byte p118;
    byte p119;
    byte p120;
    byte p121;
    byte p122;
    byte p123;
    byte p124;
    byte p125;
    byte p126;
    byte p127;
    private final ExclusiveTermAppender[] termAppenders = new ExclusiveTermAppender[3];

    ExclusivePublication(ClientConductor clientConductor, String channel, int streamId, int sessionId, ReadablePosition positionLimit, int channelStatusId, LogBuffers logBuffers, long originalRegistrationId, long registrationId) {
        super(clientConductor, channel, streamId, sessionId, positionLimit, channelStatusId, logBuffers, originalRegistrationId, registrationId);
        int index;
        UnsafeBuffer logMetaDataBuffer = logBuffers.metaDataBuffer();
        for (int i = 0; i < 3; ++i) {
            this.termAppenders[i] = new ExclusiveTermAppender(this.termBuffers[i], logMetaDataBuffer, i);
        }
        int termCount = LogBufferDescriptor.activeTermCount(logMetaDataBuffer);
        this.activePartitionIndex = index = LogBufferDescriptor.indexByTermCount(termCount);
        long rawTail = LogBufferDescriptor.rawTail(logMetaDataBuffer, index);
        this.termId = LogBufferDescriptor.termId(rawTail);
        this.termOffset = LogBufferDescriptor.termOffset(rawTail);
        this.termBeginPosition = LogBufferDescriptor.computeTermBeginPosition(this.termId, this.positionBitsToShift, this.initialTermId);
    }

    @Override
    public long position() {
        if (this.isClosed) {
            return -4L;
        }
        return this.termBeginPosition + (long)this.termOffset;
    }

    @Override
    public long availableWindow() {
        if (this.isClosed) {
            return -4L;
        }
        return this.positionLimit.getVolatile() - (this.termBeginPosition + (long)this.termOffset);
    }

    public int termId() {
        return this.termId;
    }

    public int termOffset() {
        return this.termOffset;
    }

    @Override
    public long offer(DirectBuffer buffer, int offset, int length, ReservedValueSupplier reservedValueSupplier) {
        long newPosition = -4L;
        if (!this.isClosed) {
            long limit = this.positionLimit.getVolatile();
            ExclusiveTermAppender termAppender = this.termAppenders[this.activePartitionIndex];
            long position = this.termBeginPosition + (long)this.termOffset;
            if (position < limit) {
                int result;
                if (length <= this.maxPayloadLength) {
                    this.checkPositiveLength(length);
                    result = termAppender.appendUnfragmentedMessage(this.termId, this.termOffset, this.headerWriter, buffer, offset, length, reservedValueSupplier);
                } else {
                    this.checkMaxMessageLength(length);
                    result = termAppender.appendFragmentedMessage(this.termId, this.termOffset, this.headerWriter, buffer, offset, length, this.maxPayloadLength, reservedValueSupplier);
                }
                newPosition = this.newPosition(result);
            } else {
                newPosition = this.backPressureStatus(position, length);
            }
        }
        return newPosition;
    }

    @Override
    public long offer(DirectBuffer bufferOne, int offsetOne, int lengthOne, DirectBuffer bufferTwo, int offsetTwo, int lengthTwo, ReservedValueSupplier reservedValueSupplier) {
        long newPosition = -4L;
        if (!this.isClosed) {
            long limit = this.positionLimit.getVolatile();
            ExclusiveTermAppender termAppender = this.termAppenders[this.activePartitionIndex];
            long position = this.termBeginPosition + (long)this.termOffset;
            int length = ExclusivePublication.validateAndComputeLength(lengthOne, lengthTwo);
            if (position < limit) {
                int result;
                if (length <= this.maxPayloadLength) {
                    this.checkPositiveLength(length);
                    result = termAppender.appendUnfragmentedMessage(this.termId, this.termOffset, this.headerWriter, bufferOne, offsetOne, lengthOne, bufferTwo, offsetTwo, lengthTwo, reservedValueSupplier);
                } else {
                    this.checkMaxMessageLength(length);
                    result = termAppender.appendFragmentedMessage(this.termId, this.termOffset, this.headerWriter, bufferOne, offsetOne, lengthOne, bufferTwo, offsetTwo, lengthTwo, this.maxPayloadLength, reservedValueSupplier);
                }
                newPosition = this.newPosition(result);
            } else {
                newPosition = this.backPressureStatus(position, length);
            }
        }
        return newPosition;
    }

    @Override
    public long offer(DirectBufferVector[] vectors, ReservedValueSupplier reservedValueSupplier) {
        int length = DirectBufferVector.validateAndComputeLength(vectors);
        long newPosition = -4L;
        if (!this.isClosed) {
            long limit = this.positionLimit.getVolatile();
            ExclusiveTermAppender termAppender = this.termAppenders[this.activePartitionIndex];
            long position = this.termBeginPosition + (long)this.termOffset;
            if (position < limit) {
                int result;
                if (length <= this.maxPayloadLength) {
                    result = termAppender.appendUnfragmentedMessage(this.termId, this.termOffset, this.headerWriter, vectors, length, reservedValueSupplier);
                } else {
                    this.checkMaxMessageLength(length);
                    result = termAppender.appendFragmentedMessage(this.termId, this.termOffset, this.headerWriter, vectors, length, this.maxPayloadLength, reservedValueSupplier);
                }
                newPosition = this.newPosition(result);
            } else {
                newPosition = this.backPressureStatus(position, length);
            }
        }
        return newPosition;
    }

    @Override
    public long tryClaim(int length, BufferClaim bufferClaim) {
        this.checkPayloadLength(length);
        long newPosition = -4L;
        if (!this.isClosed) {
            long limit = this.positionLimit.getVolatile();
            ExclusiveTermAppender termAppender = this.termAppenders[this.activePartitionIndex];
            long position = this.termBeginPosition + (long)this.termOffset;
            if (position < limit) {
                int result = termAppender.claim(this.termId, this.termOffset, this.headerWriter, length, bufferClaim);
                newPosition = this.newPosition(result);
            } else {
                newPosition = this.backPressureStatus(position, length);
            }
        }
        return newPosition;
    }

    public long appendPadding(int length) {
        this.checkMaxMessageLength(length);
        long newPosition = -4L;
        if (!this.isClosed) {
            long limit = this.positionLimit.getVolatile();
            ExclusiveTermAppender termAppender = this.termAppenders[this.activePartitionIndex];
            long position = this.termBeginPosition + (long)this.termOffset;
            if (position < limit) {
                this.checkPositiveLength(length);
                int result = termAppender.appendPadding(this.termId, this.termOffset, this.headerWriter, length);
                newPosition = this.newPosition(result);
            } else {
                newPosition = this.backPressureStatus(position, length);
            }
        }
        return newPosition;
    }

    public long offerBlock(MutableDirectBuffer buffer, int offset, int length) {
        long limit;
        long position;
        if (this.isClosed) {
            return -4L;
        }
        if (this.termOffset >= this.termBufferLength) {
            this.rotateTerm();
        }
        if ((position = this.termBeginPosition + (long)this.termOffset) < (limit = this.positionLimit.getVolatile())) {
            this.checkBlockLength(length);
            this.checkFirstFrame(buffer, offset);
            ExclusiveTermAppender termAppender = this.termAppenders[this.activePartitionIndex];
            int result = termAppender.appendBlock(this.termId, this.termOffset, buffer, offset, length);
            return this.newPosition(result);
        }
        return this.backPressureStatus(position, length);
    }

    private void checkBlockLength(int length) {
        int remaining = this.termBufferLength - this.termOffset;
        if (length > remaining) {
            throw new IllegalArgumentException("invalid block length " + length + ", remaining space in term is " + remaining);
        }
    }

    private void checkFirstFrame(MutableDirectBuffer buffer, int offset) {
        boolean frameType = true;
        int blockTermOffset = buffer.getInt(offset + 8, ByteOrder.LITTLE_ENDIAN);
        int blockSessionId = buffer.getInt(offset + 12, ByteOrder.LITTLE_ENDIAN);
        int blockStreamId = buffer.getInt(offset + 16, ByteOrder.LITTLE_ENDIAN);
        int blockTermId = buffer.getInt(offset + 20, ByteOrder.LITTLE_ENDIAN);
        int blockFrameType = buffer.getShort(offset + 6, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        if (blockTermOffset != this.termOffset || blockSessionId != this.sessionId || blockStreamId != this.streamId || blockTermId != this.termId || 1 != blockFrameType) {
            throw new IllegalArgumentException("improperly formatted block: termOffset=" + blockTermOffset + " (expected=" + this.termOffset + "), sessionId=" + blockSessionId + " (expected=" + this.sessionId + "), streamId=" + blockStreamId + " (expected=" + this.streamId + "), termId=" + blockTermId + " (expected=" + this.termId + "), frameType=" + blockFrameType + " (expected=" + 1 + ")");
        }
    }

    private long newPosition(int resultingOffset) {
        if (resultingOffset > 0) {
            this.termOffset = resultingOffset;
            return this.termBeginPosition + (long)resultingOffset;
        }
        if (this.termBeginPosition + (long)this.termBufferLength >= this.maxPossiblePosition) {
            return -5L;
        }
        this.rotateTerm();
        return -3L;
    }

    private void rotateTerm() {
        int nextIndex = LogBufferDescriptor.nextPartitionIndex(this.activePartitionIndex);
        int nextTermId = this.termId + 1;
        this.activePartitionIndex = nextIndex;
        this.termOffset = 0;
        this.termId = nextTermId;
        this.termBeginPosition += (long)this.termBufferLength;
        int termCount = nextTermId - this.initialTermId;
        LogBufferDescriptor.initialiseTailWithTermId(this.logMetaDataBuffer, nextIndex, nextTermId);
        LogBufferDescriptor.activeTermCountOrdered(this.logMetaDataBuffer, termCount);
    }
}

