/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.exceptions;

import io.aeron.ErrorCode;
import io.aeron.exceptions.AeronException;

public class RegistrationException
extends AeronException {
    private static final long serialVersionUID = 9076689715024983035L;
    private final long correlationId;
    private final int errorCodeValue;
    private final ErrorCode errorCode;

    public RegistrationException(long correlationId, int errorCodeValue, ErrorCode errorCode, String msg) {
        super(RegistrationException.stripCategoryName(msg) + ", errorCodeValue=" + errorCodeValue, ErrorCode.RESOURCE_TEMPORARILY_UNAVAILABLE == errorCode ? AeronException.Category.WARN : AeronException.Category.ERROR);
        this.correlationId = correlationId;
        this.errorCode = errorCode;
        this.errorCodeValue = errorCodeValue;
    }

    public long correlationId() {
        return this.correlationId;
    }

    public ErrorCode errorCode() {
        return this.errorCode;
    }

    public int errorCodeValue() {
        return this.errorCodeValue;
    }

    private static String stripCategoryName(String msg) {
        if (null != msg && msg.length() > 7) {
            if (msg.startsWith("ERROR - ") || msg.startsWith("FATAL - ")) {
                return msg.substring(8);
            }
            if (msg.startsWith("WARN - ")) {
                return msg.substring(7);
            }
        }
        return msg;
    }
}

