/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.status;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.AtomicCounter;
import org.agrona.concurrent.status.CountersManager;
import org.agrona.concurrent.status.CountersReader;

public class LocalSocketAddressStatus {
    private static final int CHANNEL_STATUS_ID_OFFSET = 0;
    private static final int LOCAL_SOCKET_ADDRESS_LENGTH_OFFSET = 4;
    private static final int LOCAL_SOCKET_ADDRESS_STRING_OFFSET = 8;
    private static final int MAX_IPV6_LENGTH = "[ffff:ffff:ffff:ffff:ffff:ffff:255.255.255.255]:65536".length();
    public static final int INITIAL_LENGTH = 8;
    public static final int LOCAL_SOCKET_ADDRESS_STATUS_TYPE_ID = 14;

    public static AtomicCounter allocate(MutableDirectBuffer tempBuffer, CountersManager countersManager, long registrationId, int channelStatusId, String name, int typeId) {
        tempBuffer.putInt(0, channelStatusId);
        tempBuffer.putInt(4, 0);
        int keyLength = 8;
        int labelLength = 0;
        labelLength += tempBuffer.putStringWithoutLengthAscii(8 + labelLength, name);
        labelLength += tempBuffer.putStringWithoutLengthAscii(8 + labelLength, ": ");
        labelLength += tempBuffer.putIntAscii(8 + labelLength, channelStatusId);
        labelLength += tempBuffer.putStringWithoutLengthAscii(8 + labelLength, " ");
        AtomicCounter counter = countersManager.newCounter(typeId, (DirectBuffer)tempBuffer, 0, 8, (DirectBuffer)tempBuffer, 8, labelLength);
        countersManager.setCounterRegistrationId(counter.id(), registrationId);
        return counter;
    }

    public static void updateBindAddress(AtomicCounter counter, String bindAddressAndPort, UnsafeBuffer countersMetadataBuffer) {
        if (bindAddressAndPort.length() > MAX_IPV6_LENGTH) {
            throw new IllegalArgumentException("bindAddressAndPort value too long: " + bindAddressAndPort.length() + " max: " + MAX_IPV6_LENGTH);
        }
        int keyIndex = CountersReader.metaDataOffset((int)counter.id()) + 16;
        int addressStringIndex = keyIndex + 8;
        int length = countersMetadataBuffer.putStringWithoutLengthAscii(addressStringIndex, bindAddressAndPort);
        int addressLengthIndex = keyIndex + 4;
        countersMetadataBuffer.putInt(addressLengthIndex, length);
        counter.appendToLabel(bindAddressAndPort);
    }

    public static List<String> findAddresses(CountersReader countersReader, long channelStatus, int channelStatusId) {
        if (channelStatus != 1L) {
            return Collections.emptyList();
        }
        ArrayList<String> bindings = new ArrayList<String>(2);
        AtomicBuffer buffer = countersReader.metaDataBuffer();
        int size = countersReader.maxCounterId();
        for (int i = 0; i < size; ++i) {
            int counterState = countersReader.getCounterState(i);
            if (1 == counterState) {
                int length;
                int recordOffset;
                int keyIndex;
                if (countersReader.getCounterTypeId(i) != 14 || channelStatusId != buffer.getInt((keyIndex = (recordOffset = CountersReader.metaDataOffset((int)i)) + 16) + 0) || 1L != countersReader.getCounterValue(i) || (length = buffer.getInt(keyIndex + 4)) <= 0) continue;
                bindings.add(buffer.getStringWithoutLengthAscii(keyIndex + 8, length));
                continue;
            }
            if (0 == counterState) break;
        }
        return bindings;
    }

    public static String findAddress(CountersReader countersReader, long channelStatus, int channelStatusId) {
        String endpoint = null;
        if (channelStatus == 1L) {
            AtomicBuffer buffer = countersReader.metaDataBuffer();
            int size = countersReader.maxCounterId();
            for (int i = 0; i < size; ++i) {
                int counterState = countersReader.getCounterState(i);
                if (1 == counterState) {
                    int recordOffset;
                    int keyIndex;
                    if (countersReader.getCounterTypeId(i) != 14 || channelStatusId != buffer.getInt((keyIndex = (recordOffset = CountersReader.metaDataOffset((int)i)) + 16) + 0) || 1L != countersReader.getCounterValue(i)) continue;
                    int length = buffer.getInt(keyIndex + 4);
                    if (length <= 0) break;
                    endpoint = buffer.getStringWithoutLengthAscii(keyIndex + 8, length);
                    break;
                }
                if (0 == counterState) break;
            }
        }
        return endpoint;
    }
}

