/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.rotation;

import java.security.PublicKey;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.jboss.logging.Logger;
import org.keycloak.adapters.HttpAdapterUtils;
import org.keycloak.adapters.HttpClientAdapterException;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.rotation.PublicKeyLocator;
import org.keycloak.common.util.Time;
import org.keycloak.jose.jwk.JSONWebKeySet;
import org.keycloak.jose.jwk.JWK;
import org.keycloak.util.JWKSUtils;

public class JWKPublicKeyLocator
implements PublicKeyLocator {
    private static final Logger log = Logger.getLogger(JWKPublicKeyLocator.class);
    private Map<String, PublicKey> currentKeys = new ConcurrentHashMap<String, PublicKey>();
    private volatile int lastRequestTime = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PublicKey getPublicKey(String kid, KeycloakDeployment deployment) {
        int currentTime;
        int minTimeBetweenRequests = deployment.getMinTimeBetweenJwksRequests();
        int publicKeyCacheTtl = deployment.getPublicKeyCacheTtl();
        PublicKey publicKey = this.lookupCachedKey(publicKeyCacheTtl, currentTime = Time.currentTime(), kid);
        if (publicKey != null) {
            return publicKey;
        }
        JWKPublicKeyLocator jWKPublicKeyLocator = this;
        synchronized (jWKPublicKeyLocator) {
            currentTime = Time.currentTime();
            if (currentTime > this.lastRequestTime + minTimeBetweenRequests) {
                this.sendRequest(deployment);
                this.lastRequestTime = currentTime;
            } else {
                log.debugf("Won't send request to realm jwks url. Last request time was %d. Current time is %d.", this.lastRequestTime, currentTime);
            }
            return this.lookupCachedKey(publicKeyCacheTtl, currentTime, kid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset(KeycloakDeployment deployment) {
        JWKPublicKeyLocator jWKPublicKeyLocator = this;
        synchronized (jWKPublicKeyLocator) {
            this.sendRequest(deployment);
            this.lastRequestTime = Time.currentTime();
            log.debugf("Reset time offset to %d.", this.lastRequestTime);
        }
    }

    private PublicKey lookupCachedKey(int publicKeyCacheTtl, int currentTime, String kid) {
        if (this.lastRequestTime + publicKeyCacheTtl > currentTime && kid != null) {
            return this.currentKeys.get(kid);
        }
        return null;
    }

    private void sendRequest(KeycloakDeployment deployment) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Going to send request to retrieve new set of realm public keys for client " + deployment.getResourceName()));
        }
        HttpGet getMethod = new HttpGet(deployment.getJwksUrl());
        try {
            JSONWebKeySet jwks = HttpAdapterUtils.sendJsonHttpRequest(deployment, (HttpRequestBase)getMethod, JSONWebKeySet.class);
            Map<String, PublicKey> publicKeys = JWKSUtils.getKeysForUse(jwks, JWK.Use.SIG);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Realm public keys successfully retrieved for client " + deployment.getResourceName() + ". New kids: " + publicKeys.keySet().toString()));
            }
            this.currentKeys.clear();
            this.currentKeys.putAll(publicKeys);
        }
        catch (HttpClientAdapterException e) {
            log.error((Object)"Error when sending request to retrieve realm keys", (Throwable)e);
        }
    }
}

