/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.xml;

import java.util.Objects;
import javax.xml.namespace.NamespaceContext;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.data.codec.xml.XmlCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.DataStringCodec;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
abstract class AbstractXmlCodec<T>
implements XmlCodec<T> {
    private final DataStringCodec<T> codec;

    AbstractXmlCodec(DataStringCodec<T> codec) {
        this.codec = Objects.requireNonNull(codec);
    }

    public final Class<T> getDataType() {
        return this.codec.getInputClass();
    }

    public final T parseValue(NamespaceContext namespaceContext, String str) {
        return (T)this.codec.deserialize((Object)this.trimValue(str));
    }

    @Deprecated
    @NonNull String trimValue(@NonNull String str) {
        return str.trim();
    }

    final String serialize(T input) {
        return (String)this.codec.serialize(input);
    }
}

