/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.xml;

import java.util.Iterator;
import java.util.Objects;
import javax.xml.namespace.NamespaceContext;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.XMLNamespace;
import org.opendaylight.yangtools.yang.data.codec.xml.AbstractInstanceIdentifierCodec;
import org.opendaylight.yangtools.yang.data.codec.xml.XmlCodec;
import org.opendaylight.yangtools.yang.data.codec.xml.XmlCodecFactory;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextTree;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.TypeAware;
import org.opendaylight.yangtools.yang.model.util.LeafrefResolver;

final class InstanceIdentifierDeserializer
extends AbstractInstanceIdentifierCodec {
    private final @NonNull XmlCodecFactory codecFactory;
    private final @NonNull NamespaceContext namespaceContext;

    InstanceIdentifierDeserializer(DataSchemaContextTree dataContextTree, XmlCodecFactory codecFactory, NamespaceContext namespaceContext) {
        super(dataContextTree);
        this.codecFactory = Objects.requireNonNull(codecFactory);
        this.namespaceContext = Objects.requireNonNull(namespaceContext);
    }

    protected Module moduleForPrefix(String prefix) {
        String prefixedNS = this.namespaceContext.getNamespaceURI(prefix);
        Iterator modules = this.codecFactory.getEffectiveModelContext().findModules(XMLNamespace.of((String)prefixedNS)).iterator();
        return modules.hasNext() ? (Module)modules.next() : null;
    }

    protected String prefixForNamespace(XMLNamespace namespace) {
        throw new UnsupportedOperationException("Not implemented");
    }

    protected Object deserializeKeyValue(DataSchemaNode schemaNode, LeafrefResolver resolver, String value) {
        XmlCodec objectXmlCodec;
        Objects.requireNonNull(schemaNode, "schemaNode cannot be null");
        if (schemaNode instanceof LeafSchemaNode) {
            LeafSchemaNode leafSchemaNode = (LeafSchemaNode)schemaNode;
            objectXmlCodec = (XmlCodec)this.codecFactory.codecFor((TypeAware)leafSchemaNode, resolver);
        } else if (schemaNode instanceof LeafListSchemaNode) {
            LeafListSchemaNode leafListSchemaNode = (LeafListSchemaNode)schemaNode;
            objectXmlCodec = (XmlCodec)this.codecFactory.codecFor((TypeAware)leafListSchemaNode, resolver);
        } else {
            throw new IllegalArgumentException("schemaNode " + schemaNode + " must be of type LeafSchemaNode or LeafListSchemaNode");
        }
        return objectXmlCodec.parseValue(this.namespaceContext, value);
    }
}

