/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.xml;

import java.util.Map;
import java.util.Objects;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.XMLNamespace;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.codec.xml.InstanceIdentifierDeserializer;
import org.opendaylight.yangtools.yang.data.codec.xml.InstanceIdentifierSerializer;
import org.opendaylight.yangtools.yang.data.codec.xml.PreferredPrefixes;
import org.opendaylight.yangtools.yang.data.codec.xml.XmlCodec;
import org.opendaylight.yangtools.yang.data.codec.xml.XmlCodecFactory;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextTree;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;

final class InstanceIdentifierXmlCodec
implements XmlCodec<YangInstanceIdentifier> {
    private final @NonNull XmlCodecFactory codecFactory;
    private final @NonNull DataSchemaContextTree dataContextTree;
    private final @Nullable PreferredPrefixes pref;

    InstanceIdentifierXmlCodec(XmlCodecFactory codecFactory, @Nullable PreferredPrefixes pref) {
        this.codecFactory = Objects.requireNonNull(codecFactory);
        this.pref = pref;
        this.dataContextTree = DataSchemaContextTree.from((EffectiveModelContext)codecFactory.getEffectiveModelContext());
    }

    public Class<YangInstanceIdentifier> getDataType() {
        return YangInstanceIdentifier.class;
    }

    public YangInstanceIdentifier parseValue(NamespaceContext ctx, String str) {
        return (YangInstanceIdentifier)new InstanceIdentifierDeserializer(this.dataContextTree, this.codecFactory, ctx).deserialize(str.trim());
    }

    @Override
    public void writeValue(XMLStreamWriter ctx, YangInstanceIdentifier value) throws XMLStreamException {
        String str;
        InstanceIdentifierSerializer serializer = new InstanceIdentifierSerializer(this.dataContextTree, ctx.getNamespaceContext(), this.pref);
        try {
            str = (String)serializer.serialize(value);
        }
        catch (IllegalArgumentException e) {
            throw new XMLStreamException("Failed to encode instance-identifier", e);
        }
        for (Map.Entry<XMLNamespace, String> entry : serializer.emittedPrefixes()) {
            ctx.writeNamespace(entry.getValue(), entry.getKey().toString());
        }
        ctx.writeCharacters(str);
    }
}

