/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.xml;

import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.rfc8528.data.api.MountPointContext;
import org.opendaylight.yangtools.rfc8528.data.util.EmptyMountPointContext;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.codec.xml.BooleanXmlCodec;
import org.opendaylight.yangtools.yang.data.codec.xml.EmptyXmlCodec;
import org.opendaylight.yangtools.yang.data.codec.xml.IdentityrefXmlCodec;
import org.opendaylight.yangtools.yang.data.codec.xml.InstanceIdentifierXmlCodec;
import org.opendaylight.yangtools.yang.data.codec.xml.NullXmlCodec;
import org.opendaylight.yangtools.yang.data.codec.xml.NumberXmlCodec;
import org.opendaylight.yangtools.yang.data.codec.xml.PreferredPrefixes;
import org.opendaylight.yangtools.yang.data.codec.xml.QuotedXmlCodec;
import org.opendaylight.yangtools.yang.data.codec.xml.StringXmlCodec;
import org.opendaylight.yangtools.yang.data.codec.xml.UnionXmlCodec;
import org.opendaylight.yangtools.yang.data.codec.xml.XmlCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.AbstractIntegerStringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.BinaryStringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.BitsStringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.BooleanStringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.DataStringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.DecimalStringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.EnumStringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.StringStringCodec;
import org.opendaylight.yangtools.yang.data.util.codec.AbstractCodecFactory;
import org.opendaylight.yangtools.yang.data.util.codec.CodecCache;
import org.opendaylight.yangtools.yang.data.util.codec.SharedCodecCache;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.type.BinaryTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BitsTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BooleanTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.DecimalTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EmptyTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EnumTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.IdentityrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.InstanceIdentifierTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int16TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int32TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int64TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int8TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.StringTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint16TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint32TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint64TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint8TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.UnionTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.UnknownTypeDefinition;

public final class XmlCodecFactory
extends AbstractCodecFactory<XmlCodec<?>> {
    private final @NonNull InstanceIdentifierXmlCodec instanceIdentifierCodec;
    private final @NonNull MountPointContext mountCtx;
    private final @Nullable PreferredPrefixes pref;

    private XmlCodecFactory(MountPointContext mountCtx, boolean modelPrefixes) {
        super(mountCtx.getEffectiveModelContext(), (CodecCache)new SharedCodecCache());
        this.mountCtx = Objects.requireNonNull(mountCtx);
        this.pref = modelPrefixes ? new PreferredPrefixes.Shared(this.getEffectiveModelContext()) : null;
        this.instanceIdentifierCodec = new InstanceIdentifierXmlCodec(this, this.pref);
    }

    MountPointContext mountPointContext() {
        return this.mountCtx;
    }

    public static XmlCodecFactory create(MountPointContext context) {
        return XmlCodecFactory.create(context, false);
    }

    public static XmlCodecFactory create(MountPointContext context, boolean preferPrefixes) {
        return new XmlCodecFactory(context, preferPrefixes);
    }

    public static XmlCodecFactory create(EffectiveModelContext context) {
        return XmlCodecFactory.create(context, false);
    }

    public static XmlCodecFactory create(EffectiveModelContext context, boolean preferPrefixes) {
        return XmlCodecFactory.create((MountPointContext)new EmptyMountPointContext(context), preferPrefixes);
    }

    protected XmlCodec<?> binaryCodec(BinaryTypeDefinition type) {
        return new QuotedXmlCodec(BinaryStringCodec.from((BinaryTypeDefinition)type));
    }

    protected XmlCodec<?> booleanCodec(BooleanTypeDefinition type) {
        return new BooleanXmlCodec((DataStringCodec<Boolean>)BooleanStringCodec.from((BooleanTypeDefinition)type));
    }

    protected XmlCodec<?> bitsCodec(BitsTypeDefinition type) {
        return new QuotedXmlCodec(BitsStringCodec.from((BitsTypeDefinition)type));
    }

    protected XmlCodec<?> emptyCodec(EmptyTypeDefinition type) {
        return EmptyXmlCodec.INSTANCE;
    }

    protected XmlCodec<?> enumCodec(EnumTypeDefinition type) {
        return new QuotedXmlCodec(EnumStringCodec.from((EnumTypeDefinition)type));
    }

    protected XmlCodec<?> identityRefCodec(IdentityrefTypeDefinition type, QNameModule module) {
        return new IdentityrefXmlCodec(this.getEffectiveModelContext(), module, this.pref);
    }

    protected XmlCodec<YangInstanceIdentifier> instanceIdentifierCodec(InstanceIdentifierTypeDefinition type) {
        return this.instanceIdentifierCodec;
    }

    public XmlCodec<YangInstanceIdentifier> instanceIdentifierCodec() {
        return this.instanceIdentifierCodec;
    }

    protected XmlCodec<?> int8Codec(Int8TypeDefinition type) {
        return new NumberXmlCodec(AbstractIntegerStringCodec.from((Int8TypeDefinition)type));
    }

    protected XmlCodec<?> int16Codec(Int16TypeDefinition type) {
        return new NumberXmlCodec(AbstractIntegerStringCodec.from((Int16TypeDefinition)type));
    }

    protected XmlCodec<?> int32Codec(Int32TypeDefinition type) {
        return new NumberXmlCodec(AbstractIntegerStringCodec.from((Int32TypeDefinition)type));
    }

    protected XmlCodec<?> int64Codec(Int64TypeDefinition type) {
        return new NumberXmlCodec(AbstractIntegerStringCodec.from((Int64TypeDefinition)type));
    }

    protected XmlCodec<?> decimalCodec(DecimalTypeDefinition type) {
        return new NumberXmlCodec(DecimalStringCodec.from((DecimalTypeDefinition)type));
    }

    protected XmlCodec<?> stringCodec(StringTypeDefinition type) {
        return new StringXmlCodec(StringStringCodec.from((StringTypeDefinition)type));
    }

    protected XmlCodec<?> uint8Codec(Uint8TypeDefinition type) {
        return new NumberXmlCodec(AbstractIntegerStringCodec.from((Uint8TypeDefinition)type));
    }

    protected XmlCodec<?> uint16Codec(Uint16TypeDefinition type) {
        return new NumberXmlCodec(AbstractIntegerStringCodec.from((Uint16TypeDefinition)type));
    }

    protected XmlCodec<?> uint32Codec(Uint32TypeDefinition type) {
        return new NumberXmlCodec(AbstractIntegerStringCodec.from((Uint32TypeDefinition)type));
    }

    protected XmlCodec<?> uint64Codec(Uint64TypeDefinition type) {
        return new NumberXmlCodec(AbstractIntegerStringCodec.from((Uint64TypeDefinition)type));
    }

    protected XmlCodec<?> unionCodec(UnionTypeDefinition type, List<XmlCodec<?>> codecs) {
        return UnionXmlCodec.create(type, codecs);
    }

    protected XmlCodec<?> unknownCodec(UnknownTypeDefinition type) {
        return NullXmlCodec.INSTANCE;
    }
}

