/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.commands;

import java.io.DataInput;
import java.io.IOException;
import org.opendaylight.controller.cluster.access.ABIVersion;
import org.opendaylight.controller.cluster.access.commands.HF;
import org.opendaylight.controller.cluster.access.commands.LocalHistoryFailureProxyV1;
import org.opendaylight.controller.cluster.access.concepts.LocalHistoryIdentifier;
import org.opendaylight.controller.cluster.access.concepts.RequestException;
import org.opendaylight.controller.cluster.access.concepts.RequestFailure;

public final class LocalHistoryFailure
extends RequestFailure<LocalHistoryIdentifier, LocalHistoryFailure> {
    private static final long serialVersionUID = 1L;

    private LocalHistoryFailure(LocalHistoryFailure failure, ABIVersion version) {
        super(failure, version);
    }

    LocalHistoryFailure(LocalHistoryIdentifier target, long sequence, RequestException cause) {
        super(target, sequence, cause);
    }

    @Override
    protected LocalHistoryFailure cloneAsVersion(ABIVersion targetVersion) {
        return new LocalHistoryFailure(this, targetVersion);
    }

    @Override
    protected SerialForm externalizableProxy(ABIVersion version) {
        return ABIVersion.MAGNESIUM.lt(version) ? new HF(this) : new LocalHistoryFailureProxyV1(this);
    }

    static interface SerialForm
    extends RequestFailure.SerialForm<LocalHistoryIdentifier, LocalHistoryFailure> {
        @Override
        default public LocalHistoryIdentifier readTarget(DataInput in) throws IOException {
            return LocalHistoryIdentifier.readFrom(in);
        }

        @Override
        default public LocalHistoryFailure createFailure(LocalHistoryIdentifier target, long sequence, RequestException cause) {
            return new LocalHistoryFailure(target, sequence, cause);
        }
    }
}

