/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.commands;

import akka.actor.ActorRef;
import java.io.ObjectInput;
import org.opendaylight.controller.cluster.access.ABIVersion;
import org.opendaylight.controller.cluster.access.commands.TPR;
import org.opendaylight.controller.cluster.access.commands.TransactionPurgeRequestProxyV1;
import org.opendaylight.controller.cluster.access.commands.TransactionRequest;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;

public final class TransactionPurgeRequest
extends TransactionRequest<TransactionPurgeRequest> {
    private static final long serialVersionUID = 1L;

    private TransactionPurgeRequest(TransactionPurgeRequest request, ABIVersion version) {
        super(request, version);
    }

    public TransactionPurgeRequest(TransactionIdentifier target, long sequence, ActorRef replyTo) {
        super(target, sequence, replyTo);
    }

    @Override
    protected SerialForm externalizableProxy(ABIVersion version) {
        return ABIVersion.MAGNESIUM.lt(version) ? new TPR(this) : new TransactionPurgeRequestProxyV1(this);
    }

    @Override
    protected TransactionPurgeRequest cloneAsVersion(ABIVersion version) {
        return new TransactionPurgeRequest(this, version);
    }

    static interface SerialForm
    extends TransactionRequest.SerialForm<TransactionPurgeRequest> {
        @Override
        default public TransactionPurgeRequest readExternal(ObjectInput in, TransactionIdentifier target, long sequence, ActorRef replyTo) {
            return new TransactionPurgeRequest(target, sequence, replyTo);
        }
    }
}

