/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.concepts;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Verify;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.cluster.access.concepts.FT;
import org.opendaylight.yangtools.concepts.WritableIdentifier;

public final class FrontendType
implements Comparable<FrontendType>,
WritableIdentifier {
    private static final long serialVersionUID = 1L;
    private static final String SIMPLE_STRING_REGEX = "^[a-zA-Z0-9-_.*+:=,!~';]+$";
    private static final Pattern SIMPLE_STRING_PATTERN = Pattern.compile("^[a-zA-Z0-9-_.*+:=,!~';]+$");
    private final @NonNull String name;
    @SuppressFBWarnings(value={"VO_VOLATILE_REFERENCE_TO_ARRAY"}, justification="The array elements are non-volatile but we don't access them.")
    private volatile byte[] serialized;

    private FrontendType(String name) {
        this.name = Objects.requireNonNull(name);
    }

    FrontendType(String name, byte[] serialized) {
        this(name);
        this.serialized = (byte[])Verify.verifyNotNull((Object)serialized);
    }

    public static @NonNull FrontendType forName(String name) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)SIMPLE_STRING_PATTERN.matcher(name).matches(), (String)"Supplied name %s does not patch pattern %s", (Object)name, (Object)SIMPLE_STRING_REGEX);
        return new FrontendType(name);
    }

    public static @NonNull FrontendType readFrom(DataInput in) throws IOException {
        byte[] serialized = new byte[in.readInt()];
        in.readFully(serialized);
        return new FrontendType(new String(serialized, StandardCharsets.UTF_8));
    }

    public void writeTo(DataOutput out) throws IOException {
        byte[] local = this.getSerialized();
        out.writeInt(local.length);
        out.write(local);
    }

    public @NonNull String getName() {
        return this.name;
    }

    public @NonNull org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.cds.types.rev191024.FrontendType toYang() {
        return new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.cds.types.rev191024.FrontendType(this.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof FrontendType && this.name.equals(((FrontendType)obj).name);
    }

    @Override
    public int compareTo(FrontendType obj) {
        return this == obj ? 0 : this.name.compareTo(obj.name);
    }

    public String toString() {
        return MoreObjects.toStringHelper(FrontendType.class).add("name", (Object)this.name).toString();
    }

    private byte[] getSerialized() {
        byte[] local = this.serialized;
        if (local == null) {
            this.serialized = local = this.name.getBytes(StandardCharsets.UTF_8);
        }
        return local;
    }

    private Object writeReplace() {
        return new FT(this);
    }

    @Deprecated(since="7.0.0", forRemoval=true)
    private static final class Proxy
    implements SerialForm {
        private static final long serialVersionUID = 1L;
        private FrontendType type;

        public Proxy() {
        }

        Proxy(FrontendType type) {
            this.type = Objects.requireNonNull(type);
        }

        @Override
        public FrontendType type() {
            return (FrontendType)Verify.verifyNotNull((Object)this.type);
        }

        @Override
        public void setType(FrontendType type) {
            this.type = Objects.requireNonNull(type);
        }

        @Override
        public Object readResolve() {
            return this.type();
        }
    }

    static interface SerialForm
    extends Externalizable {
        public @NonNull FrontendType type();

        public void setType(@NonNull FrontendType var1);

        public Object readResolve();

        @Override
        default public void writeExternal(ObjectOutput out) throws IOException {
            byte[] serialized = this.type().getSerialized();
            out.writeInt(serialized.length);
            out.write(serialized);
        }

        @Override
        default public void readExternal(ObjectInput in) throws IOException {
            byte[] serialized = new byte[in.readInt()];
            in.readFully(serialized);
            this.setType(new FrontendType(new String(serialized, StandardCharsets.UTF_8), serialized));
        }
    }
}

