/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.concepts;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.cluster.access.concepts.Envelope;
import org.opendaylight.controller.cluster.access.concepts.Response;
import org.opendaylight.yangtools.concepts.WritableObjects;

public abstract class ResponseEnvelope<T extends Response<?, ?>>
extends Envelope<T> {
    private static final long serialVersionUID = 1L;
    private final long executionTimeNanos;

    ResponseEnvelope(T message, long sessionId, long txSequence, long executionTimeNanos) {
        super(message, sessionId, txSequence);
        Preconditions.checkArgument((executionTimeNanos >= 0L ? 1 : 0) != 0, (Object)"Negative executionTime");
        this.executionTimeNanos = executionTimeNanos;
    }

    public final long getExecutionTimeNanos() {
        return this.executionTimeNanos;
    }

    static interface SerialForm<T extends Response<?, ?>, E extends ResponseEnvelope<T>>
    extends Envelope.SerialForm<T, E> {
        @Override
        default public void writeExternal(ObjectOutput out, @NonNull E envelope) throws IOException {
            Envelope.SerialForm.super.writeExternal(out, envelope);
            WritableObjects.writeLong((DataOutput)out, (long)((ResponseEnvelope)envelope).getExecutionTimeNanos());
        }

        @Override
        default public E readExternal(ObjectInput in, long sessionId, long txSequence, T message) throws IOException {
            return this.readExternal(in, sessionId, txSequence, message, WritableObjects.readLong((DataInput)in));
        }

        public E readExternal(ObjectInput var1, long var2, long var4, T var6, long var7);
    }
}

