/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.spi;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.MoreExecutors;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.function.Function;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.checkerframework.checker.lock.qual.Holding;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMTransactionChain;
import org.opendaylight.mdsal.dom.api.DOMTransactionChainListener;
import org.opendaylight.mdsal.dom.spi.ForwardingDOMDataReadWriteTransaction;
import org.opendaylight.mdsal.dom.spi.PingPongTransaction;
import org.opendaylight.mdsal.dom.spi.PingPongTransactionChain;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;

abstract class AbstractPingPongTransactionChain
implements DOMTransactionChain {
    private final DOMTransactionChainListener listener;
    private final DOMTransactionChain delegate;
    private @GuardedBy(value={"this"}) boolean closed;
    private @GuardedBy(value={"this"}) boolean failed;
    private @GuardedBy(value={"this"}) PingPongTransaction shutdownTx;
    private @GuardedBy(value={"this"}) Map.Entry<PingPongTransaction, Throwable> deadTx;
    private static final VarHandle READY_TX;
    private volatile PingPongTransaction readyTx;
    private static final VarHandle LOCKED_TX;
    private volatile PingPongTransaction lockedTx;
    private static final VarHandle INFLIGHT_TX;
    private volatile PingPongTransaction inflightTx;

    AbstractPingPongTransactionChain(Function<DOMTransactionChainListener, DOMTransactionChain> delegateFactory, DOMTransactionChainListener listener) {
        this.listener = Objects.requireNonNull(listener);
        this.delegate = delegateFactory.apply(new DOMTransactionChainListener(){

            public void onTransactionChainFailed(DOMTransactionChain chain, DOMDataTreeTransaction transaction, Throwable cause) {
                PingPongTransactionChain.LOG.debug("Transaction chain {} reported failure in {}", new Object[]{chain, transaction, cause});
                AbstractPingPongTransactionChain.this.delegateFailed(chain, cause);
            }

            public void onTransactionChainSuccessful(DOMTransactionChain chain) {
                AbstractPingPongTransactionChain.this.delegateSuccessful(chain);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delegateSuccessful(DOMTransactionChain chain) {
        Map.Entry<PingPongTransaction, Throwable> canceled;
        AbstractPingPongTransactionChain abstractPingPongTransactionChain = this;
        synchronized (abstractPingPongTransactionChain) {
            canceled = this.deadTx;
        }
        if (canceled == null) {
            this.listener.onTransactionChainSuccessful((DOMTransactionChain)this);
            return;
        }
        PingPongTransaction tx = canceled.getKey();
        Throwable cause = canceled.getValue();
        PingPongTransactionChain.LOG.debug("Transaction chain {} successful, failing cancelled transaction {}", new Object[]{chain, tx, cause});
        this.listener.onTransactionChainFailed((DOMTransactionChain)this, (DOMDataTreeTransaction)tx.getFrontendTransaction(), cause);
        tx.onFailure(cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delegateFailed(DOMTransactionChain chain, Throwable cause) {
        DOMDataTreeReadWriteTransaction frontend;
        PingPongTransaction tx = this.inflightTx;
        if (tx == null) {
            PingPongTransactionChain.LOG.warn("Transaction chain {} failed with no pending transactions", (Object)chain);
            frontend = null;
        } else {
            frontend = tx.getFrontendTransaction();
        }
        this.listener.onTransactionChainFailed((DOMTransactionChain)this, (DOMDataTreeTransaction)frontend, cause);
        AbstractPingPongTransactionChain abstractPingPongTransactionChain = this;
        synchronized (abstractPingPongTransactionChain) {
            this.failed = true;
            if (this.lockedTx == null) {
                this.processIfReady();
            }
        }
    }

    private synchronized @NonNull PingPongTransaction slowAllocateTransaction() {
        Preconditions.checkState((this.shutdownTx == null ? 1 : 0) != 0, (String)"Transaction chain %s has been shut down", (Object)this);
        if (this.deadTx != null) {
            throw new IllegalStateException(String.format("Transaction chain %s has failed due to transaction %s being canceled", this, this.deadTx.getKey()), this.deadTx.getValue());
        }
        DOMDataTreeReadWriteTransaction delegateTx = this.delegate.newReadWriteTransaction();
        PingPongTransaction newTx = new PingPongTransaction(delegateTx);
        Object witness = LOCKED_TX.compareAndExchange(this, null, newTx);
        if (witness != null) {
            delegateTx.cancel();
            throw new IllegalStateException(String.format("New transaction %s raced with transaction %s", newTx, witness));
        }
        return newTx;
    }

    private @Nullable PingPongTransaction acquireReadyTx() {
        return READY_TX.getAndSet(this, null);
    }

    private @NonNull PingPongTransaction allocateTransaction() {
        PingPongTransaction oldTx = this.acquireReadyTx();
        if (oldTx == null) {
            return this.slowAllocateTransaction();
        }
        Object witness = LOCKED_TX.compareAndExchange(this, null, oldTx);
        if (witness != null) {
            oldTx.getTransaction().cancel();
            throw new IllegalStateException(String.format("Reusable transaction %s raced with transaction %s", oldTx, witness));
        }
        return oldTx;
    }

    @Holding(value={"this"})
    private void processIfReady() {
        PingPongTransaction tx;
        if (this.inflightTx == null && (tx = this.acquireReadyTx()) != null) {
            this.processTransaction(tx);
        }
    }

    @Holding(value={"this"})
    private void processTransaction(final @NonNull PingPongTransaction tx) {
        if (this.failed) {
            PingPongTransactionChain.LOG.debug("Cancelling transaction {}", (Object)tx);
            tx.getTransaction().cancel();
            return;
        }
        PingPongTransactionChain.LOG.debug("Submitting transaction {}", (Object)tx);
        Object witness = INFLIGHT_TX.compareAndExchange(this, null, tx);
        if (witness != null) {
            PingPongTransactionChain.LOG.warn("Submitting transaction {} while {} is still running", (Object)tx, witness);
        }
        tx.getTransaction().commit().addCallback((FutureCallback)new FutureCallback<CommitInfo>(){

            public void onSuccess(CommitInfo result) {
                AbstractPingPongTransactionChain.this.transactionSuccessful(tx, result);
            }

            public void onFailure(Throwable throwable) {
                AbstractPingPongTransactionChain.this.transactionFailed(tx, throwable);
            }
        }, MoreExecutors.directExecutor());
    }

    private synchronized void processNextTransaction(PingPongTransaction tx) {
        Object witness = INFLIGHT_TX.compareAndExchange(this, tx, null);
        Preconditions.checkState((witness == tx ? 1 : 0) != 0, (String)"Completed transaction %s while %s was submitted", (Object)tx, (Object)witness);
        PingPongTransaction nextTx = this.acquireReadyTx();
        if (nextTx == null) {
            PingPongTransaction local = this.shutdownTx;
            if (local != null) {
                this.processTransaction(local);
                this.delegate.close();
                this.shutdownTx = null;
            }
        } else {
            this.processTransaction(nextTx);
        }
    }

    private void transactionSuccessful(PingPongTransaction tx, CommitInfo result) {
        PingPongTransactionChain.LOG.debug("Transaction {} completed successfully", (Object)tx);
        tx.onSuccess(result);
        this.processNextTransaction(tx);
    }

    private void transactionFailed(PingPongTransaction tx, Throwable throwable) {
        PingPongTransactionChain.LOG.debug("Transaction {} failed", (Object)tx, (Object)throwable);
        tx.onFailure(throwable);
        this.processNextTransaction(tx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readyTransaction(@NonNull PingPongTransaction tx) {
        Object lockedWitness = LOCKED_TX.compareAndExchange(this, tx, null);
        Preconditions.checkState((lockedWitness == tx ? 1 : 0) != 0, (String)"Attempted to submit transaction %s while we have %s", (Object)tx, (Object)lockedWitness);
        PingPongTransactionChain.LOG.debug("Transaction {} unlocked", (Object)tx);
        Object readyWitness = READY_TX.compareAndExchange(this, null, tx);
        Preconditions.checkState((readyWitness == null ? 1 : 0) != 0, (String)"Transaction %s collided on ready state with %s", (Object)tx, (Object)readyWitness);
        PingPongTransactionChain.LOG.debug("Transaction {} readied", (Object)tx);
        if (this.inflightTx == null) {
            AbstractPingPongTransactionChain abstractPingPongTransactionChain = this;
            synchronized (abstractPingPongTransactionChain) {
                this.processIfReady();
            }
        }
    }

    private synchronized boolean cancelTransaction(PingPongTransaction tx, DOMDataTreeReadWriteTransaction frontendTx) {
        Object witness = LOCKED_TX.compareAndExchange(this, tx, null);
        Verify.verify((witness == tx ? 1 : 0) != 0, (String)"Cancelling transaction %s collided with locked transaction %s", (Object)tx, (Object)witness);
        boolean backendCancelled = tx.getTransaction().cancel();
        if (this.failed) {
            return true;
        }
        if (frontendTx.equals(tx.getFrontendTransaction())) {
            if (backendCancelled) {
                PingPongTransactionChain.LOG.debug("Cancelled transaction {} was head of the batch, resuming processing", (Object)tx);
                return true;
            }
            Object reinstateWitness = LOCKED_TX.compareAndExchange(this, null, tx);
            Verify.verify((reinstateWitness == null ? 1 : 0) != 0, (String)"Reinstating transaction %s collided with locked transaction %s", (Object)tx, (Object)reinstateWitness);
            return false;
        }
        if (!backendCancelled) {
            PingPongTransactionChain.LOG.warn("Backend transaction cannot be cancelled during cancellation of {}, attempting to continue", (Object)tx);
        }
        this.deadTx = Map.entry(tx, new CancellationException("Transaction " + frontendTx + " canceled").fillInStackTrace());
        this.delegate.close();
        return true;
    }

    public final synchronized void close() {
        if (this.closed) {
            PingPongTransactionChain.LOG.debug("Attempted to close an already-closed chain");
            return;
        }
        PingPongTransaction notLocked = this.lockedTx;
        if (notLocked != null) {
            throw new IllegalStateException("Attempted to close chain with outstanding transaction " + notLocked);
        }
        this.closed = true;
        if (this.deadTx != null) {
            PingPongTransactionChain.LOG.debug("Delegate {} is already closed due to failure {}", (Object)this.delegate, this.deadTx);
            return;
        }
        PingPongTransaction tx = this.acquireReadyTx();
        if (tx != null) {
            if (this.inflightTx == null) {
                this.processTransaction(tx);
                this.delegate.close();
            } else {
                this.shutdownTx = tx;
            }
        } else {
            this.delegate.close();
        }
    }

    public final DOMDataTreeReadTransaction newReadOnlyTransaction() {
        return new PingPongReadTransaction(this.allocateTransaction());
    }

    public final DOMDataTreeReadWriteTransaction newReadWriteTransaction() {
        PingPongTransaction tx = this.allocateTransaction();
        PingPongReadWriteTransaction ret = new PingPongReadWriteTransaction(tx);
        tx.recordFrontendTransaction(ret);
        return ret;
    }

    public final DOMDataTreeWriteTransaction newWriteOnlyTransaction() {
        return this.newReadWriteTransaction();
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            INFLIGHT_TX = lookup.findVarHandle(AbstractPingPongTransactionChain.class, "inflightTx", PingPongTransaction.class);
            LOCKED_TX = lookup.findVarHandle(AbstractPingPongTransactionChain.class, "lockedTx", PingPongTransaction.class);
            READY_TX = lookup.findVarHandle(AbstractPingPongTransactionChain.class, "readyTx", PingPongTransaction.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private final class PingPongReadTransaction
    implements DOMDataTreeReadTransaction {
        private final @NonNull PingPongTransaction tx;

        PingPongReadTransaction(PingPongTransaction tx) {
            this.tx = Objects.requireNonNull(tx);
        }

        public FluentFuture<Optional<NormalizedNode>> read(LogicalDatastoreType store, YangInstanceIdentifier path) {
            return this.tx.getTransaction().read(store, path);
        }

        public FluentFuture<Boolean> exists(LogicalDatastoreType store, YangInstanceIdentifier path) {
            return this.tx.getTransaction().exists(store, path);
        }

        public Object getIdentifier() {
            return this.tx.getTransaction().getIdentifier();
        }

        public void close() {
            AbstractPingPongTransactionChain.this.readyTransaction(this.tx);
        }
    }

    private final class PingPongReadWriteTransaction
    extends ForwardingDOMDataReadWriteTransaction {
        private final @NonNull PingPongTransaction tx;
        private boolean isOpen = true;

        PingPongReadWriteTransaction(PingPongTransaction tx) {
            this.tx = Objects.requireNonNull(tx);
        }

        @Override
        public FluentFuture<? extends CommitInfo> commit() {
            AbstractPingPongTransactionChain.this.readyTransaction(this.tx);
            this.isOpen = false;
            return this.tx.getCommitFuture().transform(ignored -> CommitInfo.empty(), MoreExecutors.directExecutor());
        }

        @Override
        public boolean cancel() {
            if (this.isOpen && AbstractPingPongTransactionChain.this.cancelTransaction(this.tx, this)) {
                this.isOpen = false;
                return true;
            }
            return false;
        }

        @Override
        protected DOMDataTreeReadWriteTransaction delegate() {
            return this.tx.getTransaction();
        }
    }
}

