/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.spi;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.dom.api.DOMActionResult;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.common.ErrorTag;
import org.opendaylight.yangtools.yang.common.ErrorType;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;

@Beta
@NonNullByDefault
public final class SimpleDOMActionResult
implements DOMActionResult,
Immutable {
    private final Collection<RpcError> errors;
    private final @Nullable ContainerNode output;

    private SimpleDOMActionResult(Collection<RpcError> errors, @Nullable ContainerNode output) {
        this.errors = ImmutableList.copyOf(errors);
        this.output = output;
    }

    public SimpleDOMActionResult(ContainerNode output) {
        this.errors = ImmutableList.of();
        this.output = Objects.requireNonNull(output);
    }

    @SuppressFBWarnings(value={"NP_NULL_PARAM_DEREF_NONVIRTUAL"})
    public SimpleDOMActionResult(Collection<RpcError> errors) {
        this(errors, null);
    }

    public SimpleDOMActionResult(ContainerNode output, Collection<RpcError> errors) {
        this(errors, Objects.requireNonNull(output));
    }

    public static SimpleDOMActionResult ofMalformedMessage(Exception cause) {
        return new SimpleDOMActionResult((Collection<RpcError>)ImmutableList.of((Object)RpcResultBuilder.newError((ErrorType)ErrorType.RPC, (ErrorTag)ErrorTag.MALFORMED_MESSAGE, (String)cause.getMessage(), null, null, (Throwable)Objects.requireNonNull(cause))), null);
    }

    public Collection<RpcError> getErrors() {
        return this.errors;
    }

    public Optional<ContainerNode> getOutput() {
        return Optional.ofNullable(this.output);
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this).omitNullValues().add("output", (Object)this.output);
        if (!this.errors.isEmpty()) {
            helper.add("errors", this.errors);
        }
        return helper.toString();
    }
}

