/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.spi.query;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Optional;
import org.opendaylight.mdsal.dom.api.query.DOMQueryPredicate;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodes;

final class DOMQueryMatcher {
    private DOMQueryMatcher() {
    }

    static boolean matchesAll(NormalizedNode data, List<? extends DOMQueryPredicate> predicates) {
        ArrayDeque<YangInstanceIdentifier.PathArgument> pathArgs = null;
        for (DOMQueryPredicate dOMQueryPredicate : predicates) {
            YangInstanceIdentifier path = dOMQueryPredicate.relativePath();
            if (path.coerceParent().isEmpty()) {
                if (DOMQueryMatcher.matchesChild(dOMQueryPredicate.match(), data, path.getLastPathArgument())) continue;
                return false;
            }
            if (pathArgs == null) {
                pathArgs = new ArrayDeque<YangInstanceIdentifier.PathArgument>();
            }
            pathArgs.addAll(path.getPathArguments());
            if (!DOMQueryMatcher.matchesAny(dOMQueryPredicate.match(), data, pathArgs)) {
                return false;
            }
            pathArgs.clear();
        }
        return true;
    }

    private static boolean matchesAny(DOMQueryPredicate.Match match, NormalizedNode data, Deque<YangInstanceIdentifier.PathArgument> pathArgs) {
        YangInstanceIdentifier.PathArgument pathArg = pathArgs.pop();
        if (pathArgs.isEmpty()) {
            pathArgs.push(pathArg);
            return DOMQueryMatcher.matchesChild(match, data, pathArg);
        }
        Optional direct = NormalizedNodes.getDirectChild((NormalizedNode)data, (YangInstanceIdentifier.PathArgument)pathArg);
        if (direct.isPresent()) {
            boolean ret = DOMQueryMatcher.matchesAny(match, (NormalizedNode)direct.orElseThrow(), pathArgs);
            pathArgs.push(pathArg);
            return ret;
        }
        if (pathArg instanceof YangInstanceIdentifier.NodeIdentifier && data instanceof MapNode) {
            MapNode map = (MapNode)data;
            for (MapEntryNode child : map.body()) {
                if (!DOMQueryMatcher.matchesAny(match, (NormalizedNode)child, pathArgs)) continue;
                pathArgs.push(pathArg);
                return true;
            }
        }
        pathArgs.push(pathArg);
        return false;
    }

    private static boolean matchesChild(DOMQueryPredicate.Match match, NormalizedNode data, YangInstanceIdentifier.PathArgument pathArg) {
        Optional direct = NormalizedNodes.getDirectChild((NormalizedNode)data, (YangInstanceIdentifier.PathArgument)pathArg);
        if (direct.isPresent()) {
            return match.test((NormalizedNode)direct.orElseThrow());
        }
        if (pathArg instanceof YangInstanceIdentifier.NodeIdentifier && data instanceof MapNode) {
            MapNode map = (MapNode)data;
            for (MapEntryNode child : map.body()) {
                if (!match.test((NormalizedNode)child)) continue;
                return true;
            }
        }
        return match.test(null);
    }
}

