/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.spi.store;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener;
import org.opendaylight.mdsal.dom.spi.AbstractDOMDataTreeChangeListenerRegistration;
import org.opendaylight.mdsal.dom.spi.AbstractRegistrationTree;
import org.opendaylight.mdsal.dom.spi.RegistrationTreeNode;
import org.opendaylight.mdsal.dom.spi.RegistrationTreeSnapshot;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreTreeChangePublisher;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidate;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.tree.api.ModificationType;
import org.opendaylight.yangtools.yang.data.tree.spi.DataTreeCandidates;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDOMStoreTreeChangePublisher
extends AbstractRegistrationTree<AbstractDOMDataTreeChangeListenerRegistration<?>>
implements DOMStoreTreeChangePublisher {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDOMStoreTreeChangePublisher.class);

    protected abstract void notifyListener(@NonNull AbstractDOMDataTreeChangeListenerRegistration<?> var1, @NonNull List<DataTreeCandidate> var2);

    protected abstract void registrationRemoved(@NonNull AbstractDOMDataTreeChangeListenerRegistration<?> var1);

    protected final boolean processCandidateTree(@NonNull DataTreeCandidate candidate) {
        DataTreeCandidateNode node = candidate.getRootNode();
        if (node.getModificationType() == ModificationType.UNMODIFIED) {
            LOG.debug("Skipping unmodified candidate {}", (Object)candidate);
            return false;
        }
        try (RegistrationTreeSnapshot snapshot = this.takeSnapshot();){
            ImmutableList toLookup = ImmutableList.copyOf((Collection)candidate.getRootPath().getPathArguments());
            ListMultimap listenerChanges = Multimaps.newListMultimap(new IdentityHashMap(), ArrayList::new);
            this.lookupAndNotify((List<YangInstanceIdentifier.PathArgument>)toLookup, 0, snapshot.getRootNode(), candidate, (Multimap<AbstractDOMDataTreeChangeListenerRegistration<?>, DataTreeCandidate>)listenerChanges);
            for (Map.Entry entry : Multimaps.asMap((ListMultimap)listenerChanges).entrySet()) {
                this.notifyListener((AbstractDOMDataTreeChangeListenerRegistration)((Object)entry.getKey()), (List)entry.getValue());
            }
            boolean bl = !listenerChanges.isEmpty();
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <L extends DOMDataTreeChangeListener> AbstractDOMDataTreeChangeListenerRegistration<L> registerTreeChangeListener(YangInstanceIdentifier treeId, L listener) {
        this.takeLock();
        try {
            final RegistrationTreeNode node = this.findNodeFor(treeId.getPathArguments());
            AbstractDOMDataTreeChangeListenerRegistration reg = new AbstractDOMDataTreeChangeListenerRegistration<L>(listener){

                protected void removeRegistration() {
                    AbstractDOMStoreTreeChangePublisher.this.removeRegistration(node, (Object)this);
                    AbstractDOMStoreTreeChangePublisher.this.registrationRemoved(this);
                }
            };
            this.addRegistration(node, reg);
            AbstractDOMDataTreeChangeListenerRegistration abstractDOMDataTreeChangeListenerRegistration = reg;
            return abstractDOMDataTreeChangeListenerRegistration;
        }
        finally {
            this.releaseLock();
        }
    }

    private void lookupAndNotify(List<YangInstanceIdentifier.PathArgument> args, int offset, RegistrationTreeNode<AbstractDOMDataTreeChangeListenerRegistration<?>> node, DataTreeCandidate candidate, Multimap<AbstractDOMDataTreeChangeListenerRegistration<?>, DataTreeCandidate> listenerChanges) {
        if (args.size() != offset) {
            YangInstanceIdentifier.PathArgument arg = args.get(offset);
            RegistrationTreeNode<AbstractDOMDataTreeChangeListenerRegistration<?>> exactChild = node.getExactChild(arg);
            if (exactChild != null) {
                this.lookupAndNotify(args, offset + 1, exactChild, candidate, listenerChanges);
            }
            for (RegistrationTreeNode<AbstractDOMDataTreeChangeListenerRegistration<?>> c : node.getInexactChildren(arg)) {
                this.lookupAndNotify(args, offset + 1, c, candidate, listenerChanges);
            }
        } else {
            this.notifyNode(candidate.getRootPath(), node, candidate.getRootNode(), listenerChanges);
        }
    }

    private void notifyNode(YangInstanceIdentifier path, RegistrationTreeNode<AbstractDOMDataTreeChangeListenerRegistration<?>> regNode, DataTreeCandidateNode candNode, Multimap<AbstractDOMDataTreeChangeListenerRegistration<?>, DataTreeCandidate> listenerChanges) {
        if (candNode.getModificationType() == ModificationType.UNMODIFIED) {
            LOG.debug("Skipping unmodified candidate {}", (Object)path);
            return;
        }
        Collection<AbstractDOMDataTreeChangeListenerRegistration<?>> regs = regNode.getRegistrations();
        if (!regs.isEmpty()) {
            AbstractDOMStoreTreeChangePublisher.addToListenerChanges(regs, path, candNode, listenerChanges);
        }
        for (DataTreeCandidateNode candChild : candNode.getChildNodes()) {
            if (candChild.getModificationType() == ModificationType.UNMODIFIED) continue;
            RegistrationTreeNode<AbstractDOMDataTreeChangeListenerRegistration<?>> regChild = regNode.getExactChild(candChild.getIdentifier());
            if (regChild != null) {
                this.notifyNode(path.node(candChild.getIdentifier()), regChild, candChild, listenerChanges);
            }
            for (RegistrationTreeNode<AbstractDOMDataTreeChangeListenerRegistration<?>> rc : regNode.getInexactChildren(candChild.getIdentifier())) {
                this.notifyNode(path.node(candChild.getIdentifier()), rc, candChild, listenerChanges);
            }
        }
    }

    private static void addToListenerChanges(Collection<AbstractDOMDataTreeChangeListenerRegistration<?>> registrations, YangInstanceIdentifier path, DataTreeCandidateNode node, Multimap<AbstractDOMDataTreeChangeListenerRegistration<?>, DataTreeCandidate> listenerChanges) {
        DataTreeCandidate dataTreeCandidate = DataTreeCandidates.newDataTreeCandidate((YangInstanceIdentifier)path, (DataTreeCandidateNode)node);
        for (AbstractDOMDataTreeChangeListenerRegistration<?> reg : registrations) {
            listenerChanges.put(reg, (Object)dataTreeCandidate);
        }
    }
}

