/*
 * Decompiled with CFR 0.152.
 */
package akka.actor.typed.delivery.internal;

import akka.Done;
import akka.actor.typed.ActorRef;
import akka.actor.typed.ActorRef$;
import akka.actor.typed.ActorRef$ActorRefOps$;
import akka.actor.typed.Behavior;
import akka.actor.typed.DispatcherSelector$;
import akka.actor.typed.delivery.ConsumerController;
import akka.actor.typed.delivery.DurableProducerQueue;
import akka.actor.typed.delivery.DurableProducerQueue$MessageSent$;
import akka.actor.typed.delivery.DurableProducerQueue$State$;
import akka.actor.typed.delivery.WorkPullingProducerController;
import akka.actor.typed.delivery.internal.ProducerControllerImpl$;
import akka.actor.typed.delivery.internal.WorkPullingProducerControllerImpl;
import akka.actor.typed.delivery.internal.WorkPullingProducerControllerImpl$DurableQueueTerminated$;
import akka.actor.typed.receptionist.Receptionist;
import akka.actor.typed.receptionist.Receptionist$Subscribe$;
import akka.actor.typed.receptionist.ServiceKey;
import akka.actor.typed.scaladsl.ActorContext;
import akka.actor.typed.scaladsl.Behaviors$;
import akka.actor.typed.scaladsl.StashBuffer;
import akka.annotation.InternalApi;
import akka.util.Timeout;
import akka.util.Timeout$;
import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@InternalApi
public final class WorkPullingProducerControllerImpl$ {
    public static final WorkPullingProducerControllerImpl$ MODULE$ = new WorkPullingProducerControllerImpl$();

    public <A> Behavior<WorkPullingProducerController.Command<A>> apply(String producerId, ServiceKey<ConsumerController.Command<A>> workerServiceKey, Option<Behavior<DurableProducerQueue.Command<A>>> durableQueueBehavior, WorkPullingProducerController.Settings settings, ClassTag<A> evidence$1) {
        return Behaviors$.MODULE$.withStash(settings.bufferSize(), (Function1 & Serializable)stashBuffer -> Behaviors$.MODULE$.setup((Function1 & Serializable)context -> {
            Map map = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producerId"), (Object)producerId)}));
            context.setLoggerName("akka.actor.typed.delivery.WorkPullingProducerController");
            ActorRef<Receptionist.Listing> listingAdapter = context.messageAdapter((Function1 & Serializable)listing -> new WorkPullingProducerControllerImpl.CurrentWorkers(listing.allServiceInstances(workerServiceKey)), ClassTag$.MODULE$.apply(Receptionist.Listing.class));
            ActorRef$ActorRefOps$.MODULE$.$bang$extension(ActorRef$.MODULE$.ActorRefOps(context.system().receptionist()), Receptionist$Subscribe$.MODULE$.apply(workerServiceKey, listingAdapter));
            Option durableQueue = MODULE$.askLoadState((ActorContext<WorkPullingProducerControllerImpl.InternalCommand>)context, durableQueueBehavior, settings);
            return Behaviors$.MODULE$.withMdc((Map<String, String>)map, MODULE$.waitingForStart(producerId, (ActorContext<WorkPullingProducerControllerImpl.InternalCommand>)context, (StashBuffer<WorkPullingProducerControllerImpl.InternalCommand>)stashBuffer, durableQueue, settings, (Option)None$.MODULE$, MODULE$.createInitialState(durableQueue.nonEmpty()), evidence$1), ClassTag$.MODULE$.apply(WorkPullingProducerControllerImpl.InternalCommand.class));
        })).narrow();
    }

    private <A> Option<DurableProducerQueue.State<A>> createInitialState(boolean hasDurableQueue) {
        return hasDurableQueue ? None$.MODULE$ : new Some(DurableProducerQueue$State$.MODULE$.empty());
    }

    private <A> Behavior<WorkPullingProducerControllerImpl.InternalCommand> waitingForStart(String producerId, ActorContext<WorkPullingProducerControllerImpl.InternalCommand> context, StashBuffer<WorkPullingProducerControllerImpl.InternalCommand> stashBuffer, Option<ActorRef<DurableProducerQueue.Command<A>>> durableQueue, WorkPullingProducerController.Settings settings, Option<ActorRef<WorkPullingProducerController.RequestNext<A>>> producer, Option<DurableProducerQueue.State<A>> initialState, ClassTag<A> evidence$2) {
        return (Behavior)((Object)Behaviors$.MODULE$.receiveMessage((Function1 & Serializable)x0$1 -> {
            Behavior<Object> behavior;
            WorkPullingProducerControllerImpl.InternalCommand internalCommand = x0$1;
            if (internalCommand instanceof WorkPullingProducerController.Start) {
                Behavior<WorkPullingProducerControllerImpl.InternalCommand> behavior2;
                WorkPullingProducerController.Start start = (WorkPullingProducerController.Start)internalCommand;
                ProducerControllerImpl$.MODULE$.enforceLocalProducer(start.producer());
                Option option = initialState;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    DurableProducerQueue.State s = (DurableProducerQueue.State)some.value();
                    behavior2 = this.becomeActive$1(start.producer(), s, context, evidence$2, stashBuffer, producerId, durableQueue, settings);
                } else if (None$.MODULE$.equals(option)) {
                    behavior2 = MODULE$.waitingForStart(producerId, context, stashBuffer, durableQueue, settings, (Option)new Some(start.producer()), initialState, evidence$2);
                } else {
                    throw new MatchError((Object)option);
                }
                behavior = behavior2;
            } else if (internalCommand instanceof WorkPullingProducerControllerImpl.LoadStateReply) {
                Behavior<WorkPullingProducerControllerImpl.InternalCommand> behavior3;
                WorkPullingProducerControllerImpl.LoadStateReply loadStateReply = (WorkPullingProducerControllerImpl.LoadStateReply)internalCommand;
                Option option = producer;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    ActorRef p = (ActorRef)some.value();
                    behavior3 = this.becomeActive$1(p, loadStateReply.state(), context, evidence$2, stashBuffer, producerId, durableQueue, settings);
                } else if (None$.MODULE$.equals(option)) {
                    behavior3 = MODULE$.waitingForStart(producerId, context, stashBuffer, durableQueue, settings, producer, (Option)new Some(loadStateReply.state()), evidence$2);
                } else {
                    throw new MatchError((Object)option);
                }
                behavior = behavior3;
            } else if (internalCommand instanceof WorkPullingProducerControllerImpl.LoadStateFailed) {
                WorkPullingProducerControllerImpl.LoadStateFailed loadStateFailed = (WorkPullingProducerControllerImpl.LoadStateFailed)internalCommand;
                int attempt = loadStateFailed.attempt();
                if (attempt >= settings.producerControllerSettings().durableQueueRetryAttempts()) {
                    String errorMessage = new StringBuilder(46).append("LoadState failed after [").append(attempt).append("] attempts, giving up.").toString();
                    context.log().error(errorMessage);
                    throw new TimeoutException(errorMessage);
                }
                context.log().warn("LoadState failed, attempt [{}] of [{}], retrying.", (Object)BoxesRunTime.boxToInteger((int)attempt), (Object)BoxesRunTime.boxToInteger((int)settings.producerControllerSettings().durableQueueRetryAttempts()));
                MODULE$.askLoadState(context, durableQueue, settings, attempt + 1);
                behavior = Behaviors$.MODULE$.same();
            } else {
                if (WorkPullingProducerControllerImpl$DurableQueueTerminated$.MODULE$.equals(internalCommand)) {
                    throw new IllegalStateException("DurableQueue was unexpectedly terminated.");
                }
                MODULE$.akka$actor$typed$delivery$internal$WorkPullingProducerControllerImpl$$checkStashFull(stashBuffer);
                stashBuffer.stash(internalCommand);
                behavior = Behaviors$.MODULE$.same();
            }
            return behavior;
        }));
    }

    public <A> void akka$actor$typed$delivery$internal$WorkPullingProducerControllerImpl$$checkStashFull(StashBuffer<WorkPullingProducerControllerImpl.InternalCommand> stashBuffer) {
        if (stashBuffer.isFull()) {
            throw new IllegalArgumentException(new StringBuilder(24).append("Buffer is full, size [").append(stashBuffer.size()).append("].").toString());
        }
    }

    private <A> Option<ActorRef<DurableProducerQueue.Command<A>>> askLoadState(ActorContext<WorkPullingProducerControllerImpl.InternalCommand> context, Option<Behavior<DurableProducerQueue.Command<A>>> durableQueueBehavior, WorkPullingProducerController.Settings settings) {
        return durableQueueBehavior.map((Function1 & Serializable)b -> {
            void var3_3;
            ActorRef ref = context.spawn(b, "durable", DispatcherSelector$.MODULE$.sameAsParent());
            context.watchWith(ref, WorkPullingProducerControllerImpl$DurableQueueTerminated$.MODULE$);
            MODULE$.askLoadState(context, (Option)new Some(ref), settings, 1);
            return var3_3;
        });
    }

    private <A> void askLoadState(ActorContext<WorkPullingProducerControllerImpl.InternalCommand> context, Option<ActorRef<DurableProducerQueue.Command<A>>> durableQueue, WorkPullingProducerController.Settings settings, int attempt) {
        Timeout loadTimeout = Timeout$.MODULE$.durationToTimeout(settings.producerControllerSettings().durableQueueRequestTimeout());
        durableQueue.foreach((Function1 & Serializable)ref -> {
            context.ask(ref, (Function1 & Serializable)askReplyTo -> new DurableProducerQueue.LoadState(askReplyTo), (Function1 & Serializable)x0$1 -> {
                WorkPullingProducerControllerImpl.InternalCommand internalCommand;
                Try try_ = x0$1;
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    DurableProducerQueue.State s = (DurableProducerQueue.State)success.value();
                    internalCommand = new WorkPullingProducerControllerImpl.LoadStateReply(s);
                } else if (try_ instanceof Failure) {
                    internalCommand = new WorkPullingProducerControllerImpl.LoadStateFailed(attempt$1);
                } else {
                    throw new MatchError((Object)try_);
                }
                return internalCommand;
            }, loadTimeout, ClassTag$.MODULE$.apply(DurableProducerQueue.State.class));
            return BoxedUnit.UNIT;
        });
    }

    private <A> WorkPullingProducerControllerImpl.State<A> createInitialState(long currentSeqNr, ActorRef<WorkPullingProducerController.RequestNext<A>> producer) {
        return new WorkPullingProducerControllerImpl.State<A>(currentSeqNr, Predef$.MODULE$.Set().empty(), Predef$.MODULE$.Map().empty(), (Map<Object, WorkPullingProducerControllerImpl.PreselectedWorker>)Predef$.MODULE$.Map().empty(), (Map<Object, ActorRef<Done>>)Predef$.MODULE$.Map().empty(), (Map<Object, WorkPullingProducerControllerImpl.HandOver>)Predef$.MODULE$.Map().empty(), producer, false);
    }

    public static final /* synthetic */ void $anonfun$waitingForStart$1(ActorContext context$1, DurableProducerQueue.MessageSent x0$1) {
        Option<Tuple5<Object, Object, Object, String, Object>> option;
        DurableProducerQueue.MessageSent messageSent = x0$1;
        if (messageSent != null && !(option = DurableProducerQueue$MessageSent$.MODULE$.unapply(messageSent)).isEmpty()) {
            long oldSeqNr = BoxesRunTime.unboxToLong((Object)((Tuple5)option.get())._1());
            Object msg = ((Tuple5)option.get())._2();
            String oldConfirmationQualifier = (String)((Tuple5)option.get())._4();
            ActorRef$ActorRefOps$.MODULE$.$bang$extension(ActorRef$.MODULE$.ActorRefOps(context$1.self()), new WorkPullingProducerControllerImpl.ResendDurableMsg<Object>(msg, oldConfirmationQualifier, oldSeqNr));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private final Behavior becomeActive$1(ActorRef p, DurableProducerQueue.State s, ActorContext context$1, ClassTag evidence$2$1, StashBuffer stashBuffer$2, String producerId$2, Option durableQueue$1, WorkPullingProducerController.Settings settings$2) {
        s.unconfirmed().foreach((Function1 & Serializable)x0$1 -> {
            WorkPullingProducerControllerImpl$.$anonfun$waitingForStart$1(context$1, x0$1);
            return BoxedUnit.UNIT;
        });
        ActorRef msgAdapter = context$1.messageAdapter((Function1 & Serializable)msg -> new WorkPullingProducerControllerImpl.Msg<Object>(msg, false, (Option<ActorRef<Done>>)None$.MODULE$), evidence$2$1);
        WorkPullingProducerController.RequestNext requestNext = new WorkPullingProducerController.RequestNext(msgAdapter, context$1.self());
        Behavior<WorkPullingProducerControllerImpl.InternalCommand> b = new WorkPullingProducerControllerImpl(context$1, stashBuffer$2, producerId$2, requestNext, durableQueue$1, settings$2, evidence$2$1).akka$actor$typed$delivery$internal$WorkPullingProducerControllerImpl$$active(this.createInitialState(s.currentSeqNr(), p));
        return stashBuffer$2.unstashAll(b);
    }

    private WorkPullingProducerControllerImpl$() {
    }
}

