/*
 * Decompiled with CFR 0.152.
 */
package akka.remote;

import akka.event.EventStream;
import akka.event.Logging$;
import akka.event.Logging$Warning$;
import akka.event.SubchannelClassification;
import akka.remote.FailureDetector;
import akka.remote.FailureDetector$;
import akka.remote.HeartbeatHistory;
import akka.remote.HeartbeatHistory$;
import akka.remote.PhiAccrualFailureDetector$State$;
import akka.remote.RemoteLogMarker$;
import akka.util.Helpers$;
import akka.util.Helpers$ConfigOps$;
import com.typesafe.config.Config;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\t-f\u0001B\u001e=\u0001\u0005C\u0001\u0002\u0014\u0001\u0003\u0006\u0004%\t!\u0014\u0005\t#\u0002\u0011\t\u0011)A\u0005\u001d\"A!\u000b\u0001BC\u0002\u0013\u00051\u000b\u0003\u0005X\u0001\t\u0005\t\u0015!\u0003U\u0011!A\u0006A!b\u0001\n\u0003I\u0006\u0002\u00032\u0001\u0005\u0003\u0005\u000b\u0011\u0002.\t\u0011\r\u0004!Q1A\u0005\u0002eC\u0001\u0002\u001a\u0001\u0003\u0002\u0003\u0006IA\u0017\u0005\tK\u0002\u0011)\u0019!C\u00013\"Aa\r\u0001B\u0001B\u0003%!\f\u0003\u0005h\u0001\t\u0005\t\u0015!\u0003i\u0011!\t\bA!A!\u0002\u0017\u0011\bbBA\u0001\u0001\u0011\u0005\u00111\u0001\u0005\b\u0003\u0003\u0001A\u0011AA\f\u0011\u001d\t\t\u0001\u0001C\u0001\u0003OA\u0011\"a\u0011\u0001\u0005\u0004%I!!\u0012\t\u0011\u00055\u0003\u0001)A\u0005\u0003\u000fB\u0011\"a\u0014\u0001\u0005\u0004%I!!\u0015\t\u0011\u0005e\u0003\u0001)A\u0005\u0003'B!\"a\u0017\u0001\u0001\u0004%\tAPA/\u0011)\ty\u0007\u0001a\u0001\n\u0003q\u0014\u0011\u000f\u0005\t\u0003{\u0002\u0001\u0015)\u0003\u0002`\u00191\u0011q\u0010\u0001E\u0003\u0003C!\"a'\u0018\u0005+\u0007I\u0011AA#\u0011)\tij\u0006B\tB\u0003%\u0011q\t\u0005\u000b\u0003?;\"Q3A\u0005\u0002\u0005\u0005\u0006BCAS/\tE\t\u0015!\u0003\u0002$\"9\u0011\u0011A\f\u0005\u0002\u0005\u001d\u0006\"CAY/\u0005\u0005I\u0011AAZ\u0011%\tIlFI\u0001\n\u0003\tY\fC\u0005\u0002R^\t\n\u0011\"\u0001\u0002T\"I\u0011q[\f\u0002\u0002\u0013\u0005\u0013\u0011\u001c\u0005\t\u0003S<\u0012\u0011!C\u0001'\"I\u00111^\f\u0002\u0002\u0013\u0005\u0011Q\u001e\u0005\n\u0003o<\u0012\u0011!C!\u0003sD\u0011Ba\u0002\u0018\u0003\u0003%\tA!\u0003\t\u0013\tMq#!A\u0005B\tU\u0001\"\u0003B\r/\u0005\u0005I\u0011\tB\u000e\u0011%\u0011ibFA\u0001\n\u0003\u0012y\u0002C\u0005\u0003\"]\t\t\u0011\"\u0011\u0003$\u001dI!q\u0005\u0001\u0002\u0002#%!\u0011\u0006\u0004\n\u0003\u007f\u0002\u0011\u0011!E\u0005\u0005WAq!!\u0001+\t\u0003\u0011\u0019\u0005C\u0005\u0003\u001e)\n\t\u0011\"\u0012\u0003 !I!Q\t\u0016\u0002\u0002\u0013\u0005%q\t\u0005\n\u0005\u001bR\u0013\u0011!CA\u0005\u001fB\u0011B!\u0018\u0001\u0005\u0004%IAa\u0018\t\u0011\tM\u0004\u0001)A\u0005\u0005CBqA!\u001e\u0001\t\u0003\u00129\bC\u0004\u0003v\u0001!IA!\u001f\t\u000f\tu\u0004\u0001\"\u0011\u0003x!9!q\u0010\u0001\u0005F\t\u0005\u0005B\u0002BG\u0001\u0011\u0005Q\nC\u0004\u0003\u000e\u0002!IAa$\t\u0011\t5\u0005\u0001\"\u0001?\u0005'C\u0001B!)\u0001\u0005\u0004%I!\u0014\u0005\b\u0005G\u0003\u0001\u0015!\u0003O\u0011\u001d\u0011)\u000b\u0001C\u0005\u0005O\u0013\u0011\u0004\u00155j\u0003\u000e\u001c'/^1m\r\u0006LG.\u001e:f\t\u0016$Xm\u0019;pe*\u0011QHP\u0001\u0007e\u0016lw\u000e^3\u000b\u0003}\nA!Y6lC\u000e\u00011c\u0001\u0001C\u0011B\u00111IR\u0007\u0002\t*\tQ)A\u0003tG\u0006d\u0017-\u0003\u0002H\t\n1\u0011I\\=SK\u001a\u0004\"!\u0013&\u000e\u0003qJ!a\u0013\u001f\u0003\u001f\u0019\u000b\u0017\u000e\\;sK\u0012+G/Z2u_J\f\u0011\u0002\u001e5sKNDw\u000e\u001c3\u0016\u00039\u0003\"aQ(\n\u0005A#%A\u0002#pk\ndW-\u0001\u0006uQJ,7\u000f[8mI\u0002\nQ\"\\1y'\u0006l\u0007\u000f\\3TSj,W#\u0001+\u0011\u0005\r+\u0016B\u0001,E\u0005\rIe\u000e^\u0001\u000f[\u0006D8+Y7qY\u0016\u001c\u0016N_3!\u0003=i\u0017N\\*uI\u0012+g/[1uS>tW#\u0001.\u0011\u0005m\u0003W\"\u0001/\u000b\u0005us\u0016\u0001\u00033ve\u0006$\u0018n\u001c8\u000b\u0005}#\u0015AC2p]\u000e,(O]3oi&\u0011\u0011\r\u0018\u0002\u000f\r&t\u0017\u000e^3EkJ\fG/[8o\u0003Ai\u0017N\\*uI\u0012+g/[1uS>t\u0007%\u0001\rbG\u000e,\u0007\u000f^1cY\u0016DU-\u0019:uE\u0016\fG\u000fU1vg\u0016\f\u0011$Y2dKB$\u0018M\u00197f\u0011\u0016\f'\u000f\u001e2fCR\u0004\u0016-^:fA\u00051b-\u001b:ti\"+\u0017M\u001d;cK\u0006$Xi\u001d;j[\u0006$X-A\fgSJ\u001cH\u000fS3beR\u0014W-\u0019;FgRLW.\u0019;fA\u0005YQM^3oiN#(/Z1n!\r\u0019\u0015n[\u0005\u0003U\u0012\u0013aa\u00149uS>t\u0007C\u00017p\u001b\u0005i'B\u00018?\u0003\u0015)g/\u001a8u\u0013\t\u0001XNA\u0006Fm\u0016tGo\u0015;sK\u0006l\u0017!B2m_\u000e\\\u0007CA:~\u001d\t!8P\u0004\u0002vu:\u0011a/_\u0007\u0002o*\u0011\u0001\u0010Q\u0001\u0007yI|w\u000e\u001e \n\u0003}J!!\u0010 \n\u0005qd\u0014a\u0004$bS2,(/\u001a#fi\u0016\u001cGo\u001c:\n\u0005y|(!B\"m_\u000e\\'B\u0001?=\u0003\u0019a\u0014N\\5u}Qq\u0011QAA\u0006\u0003\u001b\ty!!\u0005\u0002\u0014\u0005UA\u0003BA\u0004\u0003\u0013\u0001\"!\u0013\u0001\t\u000bEl\u00019\u0001:\t\u000b1k\u0001\u0019\u0001(\t\u000bIk\u0001\u0019\u0001+\t\u000bak\u0001\u0019\u0001.\t\u000b\rl\u0001\u0019\u0001.\t\u000b\u0015l\u0001\u0019\u0001.\t\u000b\u001dl\u0001\u0019\u00015\u0015\u0019\u0005e\u0011QDA\u0010\u0003C\t\u0019#!\n\u0015\t\u0005\u001d\u00111\u0004\u0005\u0006c:\u0001\u001dA\u001d\u0005\u0006\u0019:\u0001\rA\u0014\u0005\u0006%:\u0001\r\u0001\u0016\u0005\u00061:\u0001\rA\u0017\u0005\u0006G:\u0001\rA\u0017\u0005\u0006K:\u0001\rA\u0017\u000b\u0007\u0003\u000f\tI#a\u0010\t\u000f\u0005-r\u00021\u0001\u0002.\u000511m\u001c8gS\u001e\u0004B!a\f\u0002<5\u0011\u0011\u0011\u0007\u0006\u0005\u0003W\t\u0019D\u0003\u0003\u00026\u0005]\u0012\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0005\u0005e\u0012aA2p[&!\u0011QHA\u0019\u0005\u0019\u0019uN\u001c4jO\"1\u0011\u0011I\bA\u0002-\f!!\u001a<\u0002\u001d\u0019L'o\u001d;IK\u0006\u0014HOY3biV\u0011\u0011q\t\t\u0004\u0013\u0006%\u0013bAA&y\t\u0001\u0002*Z1si\n,\u0017\r\u001e%jgR|'/_\u0001\u0010M&\u00148\u000f\u001e%fCJ$(-Z1uA\u0005q\u0012mY2faR\f'\r\\3IK\u0006\u0014HOY3biB\u000bWo]3NS2d\u0017n]\u000b\u0003\u0003'\u00022aQA+\u0013\r\t9\u0006\u0012\u0002\u0005\u0019>tw-A\u0010bG\u000e,\u0007\u000f^1cY\u0016DU-\u0019:uE\u0016\fG\u000fU1vg\u0016l\u0015\u000e\u001c7jg\u0002\nq!\u00193ee\u0016\u001c8/\u0006\u0002\u0002`A!\u0011\u0011MA5\u001d\u0011\t\u0019'!\u001a\u0011\u0005Y$\u0015bAA4\t\u00061\u0001K]3eK\u001aLA!a\u001b\u0002n\t11\u000b\u001e:j]\u001eT1!a\u001aE\u0003-\tG\r\u001a:fgN|F%Z9\u0015\t\u0005M\u0014\u0011\u0010\t\u0004\u0007\u0006U\u0014bAA<\t\n!QK\\5u\u0011%\tY(FA\u0001\u0002\u0004\ty&A\u0002yIE\n\u0001\"\u00193ee\u0016\u001c8\u000f\t\u0002\u0006'R\fG/Z\n\u0007/\t\u000b\u0019)!#\u0011\u0007\r\u000b))C\u0002\u0002\b\u0012\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0003\u0002\f\u0006Ue\u0002BAG\u0003#s1A^AH\u0013\u0005)\u0015bAAJ\t\u00069\u0001/Y2lC\u001e,\u0017\u0002BAL\u00033\u0013AbU3sS\u0006d\u0017N_1cY\u0016T1!a%E\u0003\u001dA\u0017n\u001d;pef\f\u0001\u0002[5ti>\u0014\u0018\u0010I\u0001\ni&lWm\u001d;b[B,\"!a)\u0011\t\rK\u00171K\u0001\u000bi&lWm\u001d;b[B\u0004CCBAU\u0003[\u000by\u000bE\u0002\u0002,^i\u0011\u0001\u0001\u0005\b\u00037c\u0002\u0019AA$\u0011\u001d\ty\n\ba\u0001\u0003G\u000bAaY8qsR1\u0011\u0011VA[\u0003oC\u0011\"a'\u001e!\u0003\u0005\r!a\u0012\t\u0013\u0005}U\u0004%AA\u0002\u0005\r\u0016AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003{SC!a\u0012\u0002@.\u0012\u0011\u0011\u0019\t\u0005\u0003\u0007\fi-\u0004\u0002\u0002F*!\u0011qYAe\u0003%)hn\u00195fG.,GMC\u0002\u0002L\u0012\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\ty-!2\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005U'\u0006BAR\u0003\u007f\u000bQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAAn!\u0011\ti.a:\u000e\u0005\u0005}'\u0002BAq\u0003G\fA\u0001\\1oO*\u0011\u0011Q]\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002l\u0005}\u0017\u0001\u00049s_\u0012,8\r^!sSRL\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003_\f)\u0010E\u0002D\u0003cL1!a=E\u0005\r\te.\u001f\u0005\t\u0003w\u0012\u0013\u0011!a\u0001)\u0006y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002|B1\u0011Q B\u0002\u0003_l!!a@\u000b\u0007\t\u0005A)\u0001\u0006d_2dWm\u0019;j_:LAA!\u0002\u0002\u0000\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\u0011YA!\u0005\u0011\u0007\r\u0013i!C\u0002\u0003\u0010\u0011\u0013qAQ8pY\u0016\fg\u000eC\u0005\u0002|\u0011\n\t\u00111\u0001\u0002p\u0006\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\tYNa\u0006\t\u0011\u0005mT%!AA\u0002Q\u000b\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002)\u0006AAo\\*ue&tw\r\u0006\u0002\u0002\\\u00061Q-];bYN$BAa\u0003\u0003&!I\u00111\u0010\u0015\u0002\u0002\u0003\u0007\u0011q^\u0001\u0006'R\fG/\u001a\t\u0004\u0003WS3#\u0002\u0016\u0003.\te\u0002C\u0003B\u0018\u0005k\t9%a)\u0002*6\u0011!\u0011\u0007\u0006\u0004\u0005g!\u0015a\u0002:v]RLW.Z\u0005\u0005\u0005o\u0011\tDA\tBEN$(/Y2u\rVt7\r^5p]J\u0002BAa\u000f\u0003B5\u0011!Q\b\u0006\u0005\u0005\u007f\t\u0019/\u0001\u0002j_&!\u0011q\u0013B\u001f)\t\u0011I#A\u0003baBd\u0017\u0010\u0006\u0004\u0002*\n%#1\n\u0005\b\u00037k\u0003\u0019AA$\u0011\u001d\ty*\fa\u0001\u0003G\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003R\te\u0003\u0003B\"j\u0005'\u0002ra\u0011B+\u0003\u000f\n\u0019+C\u0002\u0003X\u0011\u0013a\u0001V;qY\u0016\u0014\u0004\"\u0003B.]\u0005\u0005\t\u0019AAU\u0003\rAH\u0005M\u0001\u0006gR\fG/Z\u000b\u0003\u0005C\u0002bAa\u0019\u0003p\u0005%VB\u0001B3\u0015\u0011\u00119G!\u001b\u0002\r\u0005$x.\\5d\u0015\ry&1\u000e\u0006\u0005\u0005[\n\u0019/\u0001\u0003vi&d\u0017\u0002\u0002B9\u0005K\u0012q\"\u0011;p[&\u001c'+\u001a4fe\u0016t7-Z\u0001\u0007gR\fG/\u001a\u0011\u0002\u0017%\u001c\u0018I^1jY\u0006\u0014G.Z\u000b\u0003\u0005\u0017!BAa\u0003\u0003|!9\u0011q\u0014\u001aA\u0002\u0005M\u0013\u0001D5t\u001b>t\u0017\u000e^8sS:<\u0017!\u00035fCJ$(-Z1u)\t\t\u0019\bK\u00025\u0005\u000b\u0003BAa\"\u0003\n6\u0011\u0011\u0011Z\u0005\u0005\u0005\u0017\u000bIMA\u0004uC&d'/Z2\u0002\u0007AD\u0017\u000eF\u0002O\u0005#Cq!a(7\u0001\u0004\t\u0019\u0006F\u0004O\u0005+\u0013IJ!(\t\u000f\t]u\u00071\u0001\u0002T\u0005AA/[7f\t&4g\r\u0003\u0004\u0003\u001c^\u0002\rAT\u0001\u0005[\u0016\fg\u000e\u0003\u0004\u0003 ^\u0002\rAT\u0001\rgR$G)\u001a<jCRLwN\\\u0001\u0016[&t7\u000b\u001e3EKZL\u0017\r^5p]6KG\u000e\\5t\u0003Yi\u0017N\\*uI\u0012+g/[1uS>tW*\u001b7mSN\u0004\u0013aF3ogV\u0014XMV1mS\u0012\u001cF\u000f\u001a#fm&\fG/[8o)\rq%\u0011\u0016\u0005\u0007\u0005?S\u0004\u0019\u0001(")
public class PhiAccrualFailureDetector
implements FailureDetector {
    private volatile PhiAccrualFailureDetector$State$ State$module;
    private final double threshold;
    private final int maxSampleSize;
    private final FiniteDuration minStdDeviation;
    private final FiniteDuration acceptableHeartbeatPause;
    private final FiniteDuration firstHeartbeatEstimate;
    private final Option<EventStream> eventStream;
    private final FailureDetector.Clock clock;
    private final HeartbeatHistory firstHeartbeat;
    private final long acceptableHeartbeatPauseMillis;
    private String address;
    private final AtomicReference<State> state;
    private final double minStdDeviationMillis;

    private PhiAccrualFailureDetector$State$ State() {
        if (this.State$module == null) {
            this.State$lzycompute$1();
        }
        return this.State$module;
    }

    public double threshold() {
        return this.threshold;
    }

    public int maxSampleSize() {
        return this.maxSampleSize;
    }

    public FiniteDuration minStdDeviation() {
        return this.minStdDeviation;
    }

    public FiniteDuration acceptableHeartbeatPause() {
        return this.acceptableHeartbeatPause;
    }

    public FiniteDuration firstHeartbeatEstimate() {
        return this.firstHeartbeatEstimate;
    }

    private HeartbeatHistory firstHeartbeat() {
        return this.firstHeartbeat;
    }

    private long acceptableHeartbeatPauseMillis() {
        return this.acceptableHeartbeatPauseMillis;
    }

    public String address() {
        return this.address;
    }

    public void address_$eq(String x$1) {
        this.address = x$1;
    }

    private AtomicReference<State> state() {
        return this.state;
    }

    @Override
    public boolean isAvailable() {
        return this.isAvailable(this.clock.apply$mcJ$sp());
    }

    private boolean isAvailable(long timestamp) {
        return this.phi(timestamp) < this.threshold();
    }

    @Override
    public boolean isMonitoring() {
        return this.state().get().timestamp().nonEmpty();
    }

    @Override
    public final void heartbeat() {
        State newState;
        State oldState;
        do {
            HeartbeatHistory heartbeatHistory;
            long timestamp = this.clock.apply$mcJ$sp();
            oldState = this.state().get();
            Option<Object> option = oldState.timestamp();
            if (None$.MODULE$.equals(option)) {
                heartbeatHistory = this.firstHeartbeat();
            } else if (option instanceof Some) {
                HeartbeatHistory heartbeatHistory2;
                Some some = (Some)option;
                long latestTimestamp = BoxesRunTime.unboxToLong((Object)some.value());
                long interval = timestamp - latestTimestamp;
                if (this.isAvailable(timestamp)) {
                    if (interval >= this.acceptableHeartbeatPauseMillis() / 3L * 2L && this.eventStream.isDefined()) {
                        ((SubchannelClassification)this.eventStream.get()).publish(Logging$Warning$.MODULE$.apply(this.toString(), this.getClass(), new StringBuilder(61).append("heartbeat interval is growing too large for address ").append(this.address()).append(": ").append(interval).append(" millis").toString(), Logging$.MODULE$.emptyMDC(), RemoteLogMarker$.MODULE$.failureDetectorGrowing(this.address())));
                    }
                    heartbeatHistory2 = oldState.history().$colon$plus(interval);
                } else {
                    heartbeatHistory2 = oldState.history();
                }
                heartbeatHistory = heartbeatHistory2;
            } else {
                throw new MatchError(option);
            }
            HeartbeatHistory newHistory = heartbeatHistory;
            newState = oldState.copy(newHistory, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)timestamp)));
        } while (!this.state().compareAndSet(oldState, newState));
    }

    public double phi() {
        return this.phi(this.clock.apply$mcJ$sp());
    }

    private double phi(long timestamp) {
        double d;
        State oldState = this.state().get();
        Option<Object> oldTimestamp = oldState.timestamp();
        if (oldTimestamp.isEmpty()) {
            d = 0.0;
        } else {
            long timeDiff = timestamp - BoxesRunTime.unboxToLong((Object)oldTimestamp.get());
            HeartbeatHistory history = oldState.history();
            double mean = history.mean();
            double stdDeviation = this.ensureValidStdDeviation(history.stdDeviation());
            d = this.phi(timeDiff, mean + (double)this.acceptableHeartbeatPauseMillis(), stdDeviation);
        }
        return d;
    }

    public double phi(long timeDiff, double mean, double stdDeviation) {
        double y = ((double)timeDiff - mean) / stdDeviation;
        double e = package$.MODULE$.exp(-y * (1.5976 + 0.070566 * y * y));
        return (double)timeDiff > mean ? -package$.MODULE$.log10(e / (1.0 + e)) : -package$.MODULE$.log10(1.0 - 1.0 / (1.0 + e));
    }

    private double minStdDeviationMillis() {
        return this.minStdDeviationMillis;
    }

    private double ensureValidStdDeviation(double stdDeviation) {
        return package$.MODULE$.max(stdDeviation, this.minStdDeviationMillis());
    }

    private final void State$lzycompute$1() {
        PhiAccrualFailureDetector phiAccrualFailureDetector = this;
        synchronized (phiAccrualFailureDetector) {
            if (this.State$module == null) {
                this.State$module = new PhiAccrualFailureDetector$State$(this);
            }
        }
    }

    public PhiAccrualFailureDetector(double threshold, int maxSampleSize, FiniteDuration minStdDeviation, FiniteDuration acceptableHeartbeatPause, FiniteDuration firstHeartbeatEstimate, Option<EventStream> eventStream, FailureDetector.Clock clock) {
        this.threshold = threshold;
        this.maxSampleSize = maxSampleSize;
        this.minStdDeviation = minStdDeviation;
        this.acceptableHeartbeatPause = acceptableHeartbeatPause;
        this.firstHeartbeatEstimate = firstHeartbeatEstimate;
        this.eventStream = eventStream;
        this.clock = clock;
        Predef$.MODULE$.require(threshold > 0.0, (Function0 & Serializable)() -> "failure-detector.threshold must be > 0");
        Predef$.MODULE$.require(maxSampleSize > 0, (Function0 & Serializable)() -> "failure-detector.max-sample-size must be > 0");
        Predef$.MODULE$.require(minStdDeviation.$greater((Object)Duration$.MODULE$.Zero()), (Function0 & Serializable)() -> "failure-detector.min-std-deviation must be > 0");
        Predef$.MODULE$.require(acceptableHeartbeatPause.$greater$eq((Object)Duration$.MODULE$.Zero()), (Function0 & Serializable)() -> "failure-detector.acceptable-heartbeat-pause must be >= 0");
        Predef$.MODULE$.require(firstHeartbeatEstimate.$greater((Object)Duration$.MODULE$.Zero()), (Function0 & Serializable)() -> "failure-detector.heartbeat-interval must be > 0");
        long mean = firstHeartbeatEstimate.toMillis();
        long stdDeviation = mean / 4L;
        this.firstHeartbeat = HeartbeatHistory$.MODULE$.apply(maxSampleSize).$colon$plus(mean - stdDeviation).$colon$plus(mean + stdDeviation);
        this.acceptableHeartbeatPauseMillis = acceptableHeartbeatPause.toMillis();
        this.address = "N/A";
        this.state = new AtomicReference<State>(new State(this, this.firstHeartbeat(), (Option<Object>)None$.MODULE$));
        this.minStdDeviationMillis = minStdDeviation.toMillis();
    }

    public PhiAccrualFailureDetector(double threshold, int maxSampleSize, FiniteDuration minStdDeviation, FiniteDuration acceptableHeartbeatPause, FiniteDuration firstHeartbeatEstimate, FailureDetector.Clock clock) {
        this(threshold, maxSampleSize, minStdDeviation, acceptableHeartbeatPause, firstHeartbeatEstimate, (Option<EventStream>)None$.MODULE$, clock);
    }

    public PhiAccrualFailureDetector(Config config, EventStream ev) {
        this(config.getDouble("threshold"), config.getInt("max-sample-size"), Helpers$ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "min-std-deviation"), Helpers$ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "acceptable-heartbeat-pause"), Helpers$ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "heartbeat-interval"), (Option<EventStream>)new Some((Object)ev), FailureDetector$.MODULE$.defaultClock());
    }

    private class State
    implements Product,
    Serializable {
        private final HeartbeatHistory history;
        private final Option<Object> timestamp;
        public final /* synthetic */ PhiAccrualFailureDetector $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public HeartbeatHistory history() {
            return this.history;
        }

        public Option<Object> timestamp() {
            return this.timestamp;
        }

        public State copy(HeartbeatHistory history, Option<Object> timestamp) {
            return new State(this.akka$remote$PhiAccrualFailureDetector$State$$$outer(), history, timestamp);
        }

        public HeartbeatHistory copy$default$1() {
            return this.history();
        }

        public Option<Object> copy$default$2() {
            return this.timestamp();
        }

        public String productPrefix() {
            return "State";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.history();
                    break;
                }
                case 1: {
                    object = this.timestamp();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof State;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "history";
                    break;
                }
                case 1: {
                    string = "timestamp";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof State)) return false;
            if (((State)object).akka$remote$PhiAccrualFailureDetector$State$$$outer() != this.akka$remote$PhiAccrualFailureDetector$State$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            State state = (State)x$1;
            HeartbeatHistory heartbeatHistory = this.history();
            HeartbeatHistory heartbeatHistory2 = state.history();
            if (heartbeatHistory == null) {
                if (heartbeatHistory2 != null) {
                    return false;
                }
            } else if (!((Object)heartbeatHistory).equals(heartbeatHistory2)) return false;
            Option<Object> option = this.timestamp();
            Option<Object> option2 = state.timestamp();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!state.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ PhiAccrualFailureDetector akka$remote$PhiAccrualFailureDetector$State$$$outer() {
            return this.$outer;
        }

        public State(PhiAccrualFailureDetector $outer, HeartbeatHistory history, Option<Object> timestamp) {
            this.history = history;
            this.timestamp = timestamp;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

