/*
 * Decompiled with CFR 0.152.
 */
package akka.remote.transport.netty;

import akka.ConfigurationException;
import akka.actor.ActorSystem;
import akka.actor.Address;
import akka.actor.Address$;
import akka.actor.ExtendedActorSystem;
import akka.dispatch.Dispatchers;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.event.MarkerLoggingAdapter;
import akka.remote.RARP;
import akka.remote.RARP$;
import akka.remote.transport.AssociationHandle;
import akka.remote.transport.Transport;
import akka.remote.transport.netty.ClientHandler;
import akka.remote.transport.netty.NettyFutureBridge$;
import akka.remote.transport.netty.NettySSLSupport$;
import akka.remote.transport.netty.NettyTransport$;
import akka.remote.transport.netty.NettyTransportException;
import akka.remote.transport.netty.NettyTransportExceptionNoStack;
import akka.remote.transport.netty.NettyTransportSettings;
import akka.remote.transport.netty.SSLEngineProvider;
import akka.remote.transport.netty.TcpClientHandler;
import akka.remote.transport.netty.TcpServerHandler;
import akka.util.OptionVal$;
import akka.util.OptionVal$Some$;
import com.typesafe.config.Config;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.netty.bootstrap.Bootstrap;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.bootstrap.ConnectionlessBootstrap;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.DefaultChannelPipeline;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.ChannelGroupFuture;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioWorkerPool;
import org.jboss.netty.channel.socket.nio.WorkerPool;
import org.jboss.netty.handler.codec.frame.LengthFieldBasedFrameDecoder;
import org.jboss.netty.handler.codec.frame.LengthFieldPrepender;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timer;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\r-rA\u0002\u001e<\u0011\u0003i4I\u0002\u0004Fw!\u0005QH\u0012\u0005\u0006\u001b\u0006!\ta\u0014\u0005\b!\u0006\u0011\r\u0011\"\u0001R\u0011\u0019)\u0016\u0001)A\u0005%\")a+\u0001C\u0001/\"9\u0001/\u0001b\u0001\n\u0003\t\bBB?\u0002A\u0003%!\u000fC\u0003\u007f\u0003\u0011\u0005q\u0010\u0003\u0004\u007f\u0003\u0011\u0005\u0011Q\n\u0004\u0006\u000bn\u0002\u0011q\f\u0005\u000b\u0003SR!Q1A\u0005\u0002\u0005-\u0004BCA:\u0015\t\u0005\t\u0015!\u0003\u0002n!Q\u0011Q\u000f\u0006\u0003\u0006\u0004%\t!a\u001e\t\u0015\u0005}$B!A!\u0002\u0013\tI\b\u0003\u0004N\u0015\u0011\u0005\u0011\u0011\u0011\u0005\u0007\u001b*!\t!!#\t\u0013\u0005\u0015&B1A\u0005\u0004\u0005\u001d\u0006bBAU\u0015\u0001\u0006IA\u0018\u0005\n\u0003KQ!\u0019!C!\u0003WC\u0001\"!,\u000bA\u0003%\u0011q\u0005\u0005\u0007\u0003_SA\u0011I)\t\u0017\u0005E&\u00021AA\u0002\u0013%\u00111\u0017\u0005\f\u0003kS\u0001\u0019!a\u0001\n\u0013\t9\fC\u0006\u0002>*\u0001\r\u0011!Q!\n\u0005\u001d\u0001bCAd\u0015\u0001\u0007\t\u0019!C\u0005\u0003\u0013D1\"a3\u000b\u0001\u0004\u0005\r\u0011\"\u0003\u0002N\"Q\u0011\u0011\u001b\u0006A\u0002\u0003\u0005\u000b\u0015\u00024\t\u0013\u0005U'B1A\u0005\n\u0005]\u0007\u0002CAs\u0015\u0001\u0006I!!7\t\u0015\u0005\u001d(B1A\u0005\u0006m\nI\u000f\u0003\u0005\u0003\u000e)\u0001\u000bQBAv\u0011\u001d\u0011yA\u0003C\u0005\u0005#A\u0011B!\u0007\u000b\u0005\u0004%\tAa\u0007\t\u0011\t%\"\u0002)A\u0005\u0005;A\u0011Ba\u000b\u000b\u0005\u0004%IA!\f\t\u0011\tU\"\u0002)A\u0005\u0005_A\u0011Ba\u000e\u000b\u0005\u0004%IA!\f\t\u0011\te\"\u0002)A\u0005\u0005_AqAa\u000f\u000b\t\u0013\u0011i\u0004C\u0005\u0003F)\u0011\r\u0011\"\u0003\u0003H!A!Q\f\u0006!\u0002\u0013\u0011I\u0005C\u0005\u0003`)\u0011\r\u0011\"\u0003\u0003b!A!1\u000f\u0006!\u0002\u0013\u0011\u0019\u0007C\u0004\u0003v)!IAa\u001e\t\u0013\tM%B1A\u0005\n\tU\u0005\u0002\u0003BO\u0015\u0001\u0006IAa&\t\u000f\t}%\u0002\"\u0003\u0003\"\"9!q\u0015\u0006\u0005\n\t%\u0006\"\u0003Bh\u0015\t\u0007I\u0011\u0002Bi\u0011!\u0011\u0019N\u0003Q\u0001\n\tu\u0006b\u0002Bk\u0015\u0011%!q\u001b\u0005\b\u0005CTA\u0011\tBr\u0011\u001d\u0011IO\u0003C\u0001\u0005WDqAa?\u000b\t\u0003\u0012i\u0010\u0003\u0005\u0004\b)!\t!QAZ\u0011\u001d\u0019IA\u0003C!\u0007\u0017Aqaa\u0006\u000b\t\u0003\u001aI\"\u0001\bOKR$\u0018\u0010\u0016:b]N\u0004xN\u001d;\u000b\u0005qj\u0014!\u00028fiRL(B\u0001 @\u0003%!(/\u00198ta>\u0014HO\u0003\u0002A\u0003\u00061!/Z7pi\u0016T\u0011AQ\u0001\u0005C.\\\u0017\r\u0005\u0002E\u00035\t1H\u0001\bOKR$\u0018\u0010\u0016:b]N\u0004xN\u001d;\u0014\u0005\u00059\u0005C\u0001%L\u001b\u0005I%\"\u0001&\u0002\u000bM\u001c\u0017\r\\1\n\u00051K%AB!osJ+g-\u0001\u0004=S:LGOP\u0002\u0001)\u0005\u0019\u0015A\u0006$sC6,G*\u001a8hi\"4\u0015.\u001a7e\u0019\u0016tw\r\u001e5\u0016\u0003I\u0003\"\u0001S*\n\u0005QK%aA%oi\u00069bI]1nK2+gn\u001a;i\r&,G\u000e\u001a'f]\u001e$\b\u000eI\u0001\u000eOJ\f7-\u001a4vY\u000ecwn]3\u0015\u0005a#GCA-]!\tA%,\u0003\u0002\\\u0013\n!QK\\5u\u0011\u0015iV\u0001q\u0001_\u0003\t)7\r\u0005\u0002`E6\t\u0001M\u0003\u0002b\u0013\u0006Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005\r\u0004'\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0011\u0015)W\u00011\u0001g\u0003\u001d\u0019\u0007.\u00198oK2\u0004\"a\u001a8\u000e\u0003!T!!Z5\u000b\u0005qR'BA6m\u0003\u0015Q'm\\:t\u0015\u0005i\u0017aA8sO&\u0011q\u000e\u001b\u0002\b\u0007\"\fgN\\3m\u0003=)h.[9vK&#7i\\;oi\u0016\u0014X#\u0001:\u0011\u0005M\\X\"\u0001;\u000b\u0005U4\u0018AB1u_6L7M\u0003\u0002bo*\u0011\u00010_\u0001\u0005kRLGNC\u0001{\u0003\u0011Q\u0017M^1\n\u0005q$(!D!u_6L7-\u00138uK\u001e,'/\u0001\tv]&\fX/Z%e\u0007>,h\u000e^3sA\u0005A\u0012\r\u001a3sKN\u001chI]8n'>\u001c7.\u001a;BI\u0012\u0014Xm]:\u0015\u0019\u0005\u0005\u00111CA\u0012\u0003{\t\t%a\u0012\u0011\u000b!\u000b\u0019!a\u0002\n\u0007\u0005\u0015\u0011J\u0001\u0004PaRLwN\u001c\t\u0005\u0003\u0013\ty!\u0004\u0002\u0002\f)\u0019\u0011QB!\u0002\u000b\u0005\u001cGo\u001c:\n\t\u0005E\u00111\u0002\u0002\b\u0003\u0012$'/Z:t\u0011\u001d\t)\u0002\u0003a\u0001\u0003/\tA!\u00193eeB!\u0011\u0011DA\u0010\u001b\t\tYBC\u0002\u0002\u001ee\f1A\\3u\u0013\u0011\t\t#a\u0007\u0003\u001bM{7m[3u\u0003\u0012$'/Z:t\u0011\u001d\t)\u0003\u0003a\u0001\u0003O\t\u0001c]2iK6,\u0017\nZ3oi&4\u0017.\u001a:\u0011\t\u0005%\u0012q\u0007\b\u0005\u0003W\t\u0019\u0004E\u0002\u0002.%k!!a\f\u000b\u0007\u0005Eb*\u0001\u0004=e>|GOP\u0005\u0004\u0003kI\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002:\u0005m\"AB*ue&twMC\u0002\u00026%Cq!a\u0010\t\u0001\u0004\t9#\u0001\u0006tsN$X-\u001c(b[\u0016Dq!a\u0011\t\u0001\u0004\t)%\u0001\u0005i_N$h*Y7f!\u0015A\u00151AA\u0014\u0011\u001d\tI\u0005\u0003a\u0001\u0003\u0017\nA\u0001]8siB!\u0001*a\u0001S))\t\t!a\u0014\u0002R\u0005M\u0013Q\u000b\u0005\b\u0003+I\u0001\u0019AA\f\u0011\u001d\t)#\u0003a\u0001\u0003OAq!a\u0010\n\u0001\u0004\t9\u0003C\u0004\u0002D%\u0001\r!!\u0012)\u0007\u0005\tI\u0006E\u0002I\u00037J1!!\u0018J\u0005)!W\r\u001d:fG\u0006$X\rZ\n\u0005\u0015\u001d\u000b\t\u0007\u0005\u0003\u0002d\u0005\u0015T\"A\u001f\n\u0007\u0005\u001dTHA\u0005Ue\u0006t7\u000f]8si\u0006A1/\u001a;uS:<7/\u0006\u0002\u0002nA\u0019A)a\u001c\n\u0007\u0005E4H\u0001\fOKR$\u0018\u0010\u0016:b]N\u0004xN\u001d;TKR$\u0018N\\4t\u0003%\u0019X\r\u001e;j]\u001e\u001c\b%\u0001\u0004tsN$X-\\\u000b\u0003\u0003s\u0002B!!\u0003\u0002|%!\u0011QPA\u0006\u0005M)\u0005\u0010^3oI\u0016$\u0017i\u0019;peNK8\u000f^3n\u0003\u001d\u0019\u0018p\u001d;f[\u0002\"b!a!\u0002\u0006\u0006\u001d\u0005C\u0001#\u000b\u0011\u001d\tIg\u0004a\u0001\u0003[Bq!!\u001e\u0010\u0001\u0004\tI\b\u0006\u0004\u0002\u0004\u0006-\u0015Q\u0012\u0005\b\u0003k\u0002\u0002\u0019AA=\u0011\u001d\ty\t\u0005a\u0001\u0003#\u000bAaY8oMB!\u00111SAQ\u001b\t\t)J\u0003\u0003\u0002\u0018\u0006e\u0015AB2p]\u001aLwM\u0003\u0003\u0002\u001c\u0006u\u0015\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0005\u0005}\u0015aA2p[&!\u00111UAK\u0005\u0019\u0019uN\u001c4jO\u0006\u0001R\r_3dkRLwN\\\"p]R,\u0007\u0010^\u000b\u0002=\u0006\tR\r_3dkRLwN\\\"p]R,\u0007\u0010\u001e\u0011\u0016\u0005\u0005\u001d\u0012!E:dQ\u0016lW-\u00133f]RLg-[3sA\u0005\u0019R.\u0019=j[Vl\u0007+Y=m_\u0006$')\u001f;fg\u00069!m\\;oIR{WCAA\u0004\u0003-\u0011w.\u001e8e)>|F%Z9\u0015\u0007e\u000bI\fC\u0005\u0002<^\t\t\u00111\u0001\u0002\b\u0005\u0019\u0001\u0010J\u0019\u0002\u0011\t|WO\u001c3U_\u0002B3\u0001GAa!\rA\u00151Y\u0005\u0004\u0003\u000bL%\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002\u001bM,'O^3s\u0007\"\fgN\\3m+\u00051\u0017!E:feZ,'o\u00115b]:,Gn\u0018\u0013fcR\u0019\u0011,a4\t\u0011\u0005m&$!AA\u0002\u0019\fab]3sm\u0016\u00148\t[1o]\u0016d\u0007\u0005K\u0002\u001c\u0003\u0003\f1\u0001\\8h+\t\tI\u000e\u0005\u0003\u0002\\\u0006\u0005XBAAo\u0015\r\ty.Q\u0001\u0006KZ,g\u000e^\u0005\u0005\u0003G\fiN\u0001\u000bNCJ\\WM\u001d'pO\u001eLgnZ!eCB$XM]\u0001\u0005Y><\u0007%\u0001\nvIB\u001cuN\u001c8fGRLwN\u001c+bE2,WCAAv!!\ti/a<\u0002\u0018\u0005MX\"\u0001<\n\u0007\u0005EhOA\tD_:\u001cWO\u001d:f]RD\u0015m\u001d5NCB\u0004B!!>\u0003\b9!\u0011q\u001fB\u0002\u001d\u0011\tIP!\u0001\u000f\t\u0005m\u0018q \b\u0005\u0003[\ti0C\u0001C\u0013\t\u0001\u0015)\u0003\u0002?\u007f%\u0019!QA\u001f\u0002#\u0005\u001b8o\\2jCRLwN\u001c%b]\u0012dW-\u0003\u0003\u0003\n\t-!a\u0005%b]\u0012dW-\u0012<f]Rd\u0015n\u001d;f]\u0016\u0014(b\u0001B\u0003{\u0005\u0019R\u000f\u001a9D_:tWm\u0019;j_:$\u0016M\u00197fA\u0005)2M]3bi\u0016,\u00050Z2vi>\u00148+\u001a:wS\u000e,GC\u0001B\n!\u0011\tiO!\u0006\n\u0007\t]aO\u0001\u0005Fq\u0016\u001cW\u000f^8s\u00031\u0019\u0007.\u00198oK2<%o\\;q+\t\u0011i\u0002\u0005\u0003\u0003 \t\u0015RB\u0001B\u0011\u0015\r\u0011\u0019\u0003[\u0001\u0006OJ|W\u000f]\u0005\u0005\u0005O\u0011\tCA\nEK\u001a\fW\u000f\u001c;DQ\u0006tg.\u001a7He>,\b/A\u0007dQ\u0006tg.\u001a7He>,\b\u000fI\u0001\u0015G2LWM\u001c;DQ\u0006tg.\u001a7GC\u000e$xN]=\u0016\u0005\t=\u0002cA4\u00032%\u0019!1\u00075\u0003\u001d\rC\u0017M\u001c8fY\u001a\u000b7\r^8ss\u0006)2\r\\5f]R\u001c\u0005.\u00198oK24\u0015m\u0019;pef\u0004\u0013\u0001F:feZ,'o\u00115b]:,GNR1di>\u0014\u00180A\u000btKJ4XM]\"iC:tW\r\u001c$bGR|'/\u001f\u0011\u0002\u00179,w\u000fU5qK2Lg.Z\u000b\u0003\u0005\u007f\u00012a\u001aB!\u0013\r\u0011\u0019\u0005\u001b\u0002\u0017\t\u00164\u0017-\u001e7u\u0007\"\fgN\\3m!&\u0004X\r\\5oK\u0006Q\u0012m]:pG&\fG/[8o\u0019&\u001cH/\u001a8feB\u0013x.\\5tKV\u0011!\u0011\n\t\u0006?\n-#qJ\u0005\u0004\u0005\u001b\u0002'a\u0002)s_6L7/\u001a\t\u0005\u0005#\u00129F\u0004\u0003\u0002x\nM\u0013b\u0001B+{\u0005IAK]1ogB|'\u000f^\u0005\u0005\u00053\u0012YF\u0001\rBgN|7-[1uS>tWI^3oi2K7\u000f^3oKJT1A!\u0016>\u0003m\t7o]8dS\u0006$\u0018n\u001c8MSN$XM\\3s!J|W.[:fA\u0005\t2o\u001d7F]\u001eLg.\u001a)s_ZLG-\u001a:\u0016\u0005\t\r\u0004C\u0002B3\u0005S\u0012i'\u0004\u0002\u0003h)\u0011\u00010Q\u0005\u0005\u0005W\u00129GA\u0005PaRLwN\u001c,bYB\u0019AIa\u001c\n\u0007\tE4HA\tT'2+enZ5oKB\u0013xN^5eKJ\f!c]:m\u000b:<\u0017N\\3Qe>4\u0018\u000eZ3sA\u0005Q1o\u001d7IC:$G.\u001a:\u0015\t\te$\u0011\u0012\t\u0005\u0005w\u0012))\u0004\u0002\u0003~)!!q\u0010BA\u0003\r\u00198\u000f\u001c\u0006\u0004\u0005\u0007K\u0017a\u00025b]\u0012dWM]\u0005\u0005\u0005\u000f\u0013iH\u0001\u0006Tg2D\u0015M\u001c3mKJDqAa#-\u0001\u0004\u0011i)\u0001\u0005jg\u000ec\u0017.\u001a8u!\rA%qR\u0005\u0004\u0005#K%a\u0002\"p_2,\u0017M\\\u0001\u0016g\u0016\u0014h/\u001a:QSB,G.\u001b8f\r\u0006\u001cGo\u001c:z+\t\u00119\nE\u0002h\u00053K1Aa'i\u0005Y\u0019\u0005.\u00198oK2\u0004\u0016\u000e]3mS:,g)Y2u_JL\u0018AF:feZ,'\u000fU5qK2Lg.\u001a$bGR|'/\u001f\u0011\u0002+\rd\u0017.\u001a8u!&\u0004X\r\\5oK\u001a\u000b7\r^8ssR!!q\u0013BR\u0011\u001d\u0011)k\fa\u0001\u0003\u000f\tQB]3n_R,\u0017\t\u001a3sKN\u001c\u0018AD:fiV\u0004(i\\8ugR\u0014\u0018\r]\u000b\u0005\u0005W\u0013\t\f\u0006\u0004\u0003.\n%'1\u001a\t\u0005\u0005_\u0013\t\f\u0004\u0001\u0005\u000f\tM\u0006G1\u0001\u00036\n\t!)\u0005\u0003\u00038\nu\u0006c\u0001%\u0003:&\u0019!1X%\u0003\u000f9{G\u000f[5oOB!!q\u0018Bc\u001b\t\u0011\tMC\u0002\u0003D&\f\u0011BY8piN$(/\u00199\n\t\t\u001d'\u0011\u0019\u0002\n\u0005>|Go\u001d;sCBDqAa11\u0001\u0004\u0011i\u000bC\u0004\u0003NB\u0002\rAa&\u0002\u001fAL\u0007/\u001a7j]\u00164\u0015m\u0019;pef\f\u0001#\u001b8c_VtGMQ8piN$(/\u00199\u0016\u0005\tu\u0016!E5oE>,h\u000e\u001a\"p_R\u001cHO]1qA\u0005\tr.\u001e;c_VtGMQ8piN$(/\u00199\u0015\t\te'q\u001c\t\u0005\u0005\u007f\u0013Y.\u0003\u0003\u0003^\n\u0005'aD\"mS\u0016tGOQ8piN$(/\u00199\t\u000f\t\u00156\u00071\u0001\u0002\b\u0005\u0001\u0012n\u001d*fgB|gn]5cY\u00164uN\u001d\u000b\u0005\u0005\u001b\u0013)\u000fC\u0004\u0003hR\u0002\r!a\u0002\u0002\u000f\u0005$GM]3tg\u00061\u0012\r\u001a3sKN\u001cHk\\*pG.,G/\u00113ee\u0016\u001c8\u000f\u0006\u0003\u0003n\ne\b#B0\u0003p\nM\u0018b\u0001ByA\n1a)\u001e;ve\u0016\u0004B!!\u0007\u0003v&!!q_A\u000e\u0005EIe.\u001a;T_\u000e\\W\r^!eIJ,7o\u001d\u0005\b\u0003+)\u0004\u0019AA\u0004\u0003\u0019a\u0017n\u001d;f]V\u0011!q \t\u0006?\n=8\u0011\u0001\t\b\u0011\u000e\r\u0011q\u0001B%\u0013\r\u0019)!\u0013\u0002\u0007)V\u0004H.\u001a\u001a\u0002\u0019\t|WO\u001c3BI\u0012\u0014Xm]:\u0002\u0013\u0005\u001c8o\\2jCR,G\u0003BB\u0007\u0007+\u0001Ra\u0018Bx\u0007\u001f\u0001B!a\u0019\u0004\u0012%\u001911C\u001f\u0003#\u0005\u001b8o\\2jCRLwN\u001c%b]\u0012dW\rC\u0004\u0003&b\u0002\r!a\u0002\u0002\u0011MDW\u000f\u001e3po:$\"aa\u0007\u0011\u000b}\u0013yO!$)\u0017)\tIfa\b\u0004\"\r\u00152qE\u0001\b[\u0016\u001c8/Y4fC\t\u0019\u0019#\u0001\u0016DY\u0006\u001c8/[2!e\u0016lw\u000e^5oO\u0002J7\u000f\t3faJ,7-\u0019;fI2\u0002So]3!\u0003J$XM]=\u0002\u000bMLgnY3\"\u0005\r%\u0012!\u0002\u001a/m9\u0002\u0004")
public class NettyTransport
implements Transport {
    private final NettyTransportSettings settings;
    private final ExtendedActorSystem system;
    private final ExecutionContext executionContext;
    private final String schemeIdentifier;
    private volatile Address boundTo;
    private volatile Channel serverChannel;
    private final MarkerLoggingAdapter akka$remote$transport$netty$NettyTransport$$log;
    private final ConcurrentHashMap<SocketAddress, AssociationHandle.HandleEventListener> udpConnectionTable;
    private final DefaultChannelGroup channelGroup;
    private final ChannelFactory clientChannelFactory;
    private final ChannelFactory serverChannelFactory;
    private final Promise<Transport.AssociationEventListener> akka$remote$transport$netty$NettyTransport$$associationListenerPromise;
    private final SSLEngineProvider sslEngineProvider;
    private final ChannelPipelineFactory serverPipelineFactory;
    private final Bootstrap inboundBootstrap;

    public static Option<Address> addressFromSocketAddress(SocketAddress addr, String schemeIdentifier, String systemName, Option<String> hostName) {
        return NettyTransport$.MODULE$.addressFromSocketAddress(addr, schemeIdentifier, systemName, hostName);
    }

    public static Option<Address> addressFromSocketAddress(SocketAddress addr, String schemeIdentifier, String systemName, Option<String> hostName, Option<Object> port) {
        return NettyTransport$.MODULE$.addressFromSocketAddress(addr, schemeIdentifier, systemName, hostName, port);
    }

    public static AtomicInteger uniqueIdCounter() {
        return NettyTransport$.MODULE$.uniqueIdCounter();
    }

    public static void gracefulClose(Channel channel, ExecutionContext ec) {
        NettyTransport$.MODULE$.gracefulClose(channel, ec);
    }

    public static int FrameLengthFieldLength() {
        return NettyTransport$.MODULE$.FrameLengthFieldLength();
    }

    @Override
    public Future<Object> managementCommand(Object cmd) {
        return Transport.managementCommand$(this, cmd);
    }

    public NettyTransportSettings settings() {
        return this.settings;
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    public ExecutionContext executionContext() {
        return this.executionContext;
    }

    @Override
    public String schemeIdentifier() {
        return this.schemeIdentifier;
    }

    @Override
    public int maximumPayloadBytes() {
        return this.settings().MaxFrameSize();
    }

    private Address boundTo() {
        return this.boundTo;
    }

    private void boundTo_$eq(Address x$1) {
        this.boundTo = x$1;
    }

    private Channel serverChannel() {
        return this.serverChannel;
    }

    private void serverChannel_$eq(Channel x$1) {
        this.serverChannel = x$1;
    }

    public MarkerLoggingAdapter akka$remote$transport$netty$NettyTransport$$log() {
        return this.akka$remote$transport$netty$NettyTransport$$log;
    }

    public final ConcurrentHashMap<SocketAddress, AssociationHandle.HandleEventListener> udpConnectionTable() {
        return this.udpConnectionTable;
    }

    private Executor createExecutorService() {
        Dispatchers dispatchers = this.system().dispatchers();
        return (Executor)this.settings().UseDispatcherForIo().map((Function1 & Serializable)id -> dispatchers.lookup((String)id)).getOrElse((Function0 & Serializable)() -> Executors.newCachedThreadPool(this.system().threadFactory()));
    }

    public DefaultChannelGroup channelGroup() {
        return this.channelGroup;
    }

    private ChannelFactory clientChannelFactory() {
        return this.clientChannelFactory;
    }

    private ChannelFactory serverChannelFactory() {
        return this.serverChannelFactory;
    }

    /*
     * WARNING - void declaration
     */
    public DefaultChannelPipeline akka$remote$transport$netty$NettyTransport$$newPipeline() {
        void var1_1;
        DefaultChannelPipeline pipeline = new DefaultChannelPipeline();
        pipeline.addLast("FrameDecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(this.maximumPayloadBytes(), 0, NettyTransport$.MODULE$.FrameLengthFieldLength(), 0, NettyTransport$.MODULE$.FrameLengthFieldLength(), true));
        pipeline.addLast("FrameEncoder", (ChannelHandler)new LengthFieldPrepender(NettyTransport$.MODULE$.FrameLengthFieldLength()));
        return var1_1;
    }

    public Promise<Transport.AssociationEventListener> akka$remote$transport$netty$NettyTransport$$associationListenerPromise() {
        return this.akka$remote$transport$netty$NettyTransport$$associationListenerPromise;
    }

    private SSLEngineProvider sslEngineProvider() {
        return this.sslEngineProvider;
    }

    public SslHandler akka$remote$transport$netty$NettyTransport$$sslHandler(boolean isClient) {
        SSLEngineProvider sSLEngineProvider = this.sslEngineProvider();
        SSLEngineProvider sSLEngineProvider2 = OptionVal$Some$.MODULE$.unapply(sSLEngineProvider);
        if (OptionVal$.MODULE$.isEmpty$extension(sSLEngineProvider2)) {
            throw new IllegalStateException("Expected enable-ssl=on");
        }
        SSLEngineProvider sslProvider = OptionVal$.MODULE$.get$extension(sSLEngineProvider2);
        SslHandler handler = NettySSLSupport$.MODULE$.apply(sslProvider, isClient);
        handler.setCloseOnSSLException(true);
        SslHandler sslHandler = handler;
        return sslHandler;
    }

    private ChannelPipelineFactory serverPipelineFactory() {
        return this.serverPipelineFactory;
    }

    private ChannelPipelineFactory clientPipelineFactory(Address remoteAddress) {
        return new ChannelPipelineFactory(this, remoteAddress){
            private final /* synthetic */ NettyTransport $outer;
            private final Address remoteAddress$1;

            /*
             * WARNING - void declaration
             */
            public ChannelPipeline getPipeline() {
                void var1_1;
                DefaultChannelPipeline pipeline = this.$outer.akka$remote$transport$netty$NettyTransport$$newPipeline();
                if (this.$outer.settings().EnableSsl()) {
                    pipeline.addFirst("SslHandler", (ChannelHandler)this.$outer.akka$remote$transport$netty$NettyTransport$$sslHandler(true));
                }
                TcpClientHandler handler = new TcpClientHandler(this.$outer, this.remoteAddress$1, this.$outer.akka$remote$transport$netty$NettyTransport$$log());
                pipeline.addLast("clienthandler", (ChannelHandler)handler);
                return var1_1;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.remoteAddress$1 = remoteAddress$1;
            }
        };
    }

    private <B extends Bootstrap> B setupBootstrap(B bootstrap, ChannelPipelineFactory pipelineFactory) {
        bootstrap.setPipelineFactory(pipelineFactory);
        bootstrap.setOption("backlog", (Object)BoxesRunTime.boxToInteger((int)this.settings().Backlog()));
        bootstrap.setOption("child.tcpNoDelay", (Object)BoxesRunTime.boxToBoolean((boolean)this.settings().TcpNodelay()));
        bootstrap.setOption("child.keepAlive", (Object)BoxesRunTime.boxToBoolean((boolean)this.settings().TcpKeepalive()));
        bootstrap.setOption("reuseAddress", (Object)BoxesRunTime.boxToBoolean((boolean)this.settings().TcpReuseAddr()));
        this.settings().ReceiveBufferSize().foreach((Function1)(JFunction1.mcVI.sp & Serializable)sz -> bootstrap.setOption("receiveBufferSize", (Object)BoxesRunTime.boxToInteger((int)sz)));
        this.settings().SendBufferSize().foreach((Function1)(JFunction1.mcVI.sp & Serializable)sz -> bootstrap.setOption("sendBufferSize", (Object)BoxesRunTime.boxToInteger((int)sz)));
        this.settings().WriteBufferHighWaterMark().foreach((Function1)(JFunction1.mcVI.sp & Serializable)sz -> bootstrap.setOption("writeBufferHighWaterMark", (Object)BoxesRunTime.boxToInteger((int)sz)));
        this.settings().WriteBufferLowWaterMark().foreach((Function1)(JFunction1.mcVI.sp & Serializable)sz -> bootstrap.setOption("writeBufferLowWaterMark", (Object)BoxesRunTime.boxToInteger((int)sz)));
        return bootstrap;
    }

    private Bootstrap inboundBootstrap() {
        return this.inboundBootstrap;
    }

    /*
     * WARNING - void declaration
     */
    private ClientBootstrap outboundBootstrap(Address remoteAddress) {
        void var2_2;
        ClientBootstrap bootstrap = this.setupBootstrap(new ClientBootstrap(this.clientChannelFactory()), this.clientPipelineFactory(remoteAddress));
        bootstrap.setOption("connectTimeoutMillis", (Object)BoxesRunTime.boxToLong((long)this.settings().ConnectionTimeout().toMillis()));
        bootstrap.setOption("tcpNoDelay", (Object)BoxesRunTime.boxToBoolean((boolean)this.settings().TcpNodelay()));
        bootstrap.setOption("keepAlive", (Object)BoxesRunTime.boxToBoolean((boolean)this.settings().TcpKeepalive()));
        this.settings().ReceiveBufferSize().foreach((Function1)(JFunction1.mcVI.sp & Serializable)sz -> bootstrap.setOption("receiveBufferSize", (Object)BoxesRunTime.boxToInteger((int)sz)));
        this.settings().SendBufferSize().foreach((Function1)(JFunction1.mcVI.sp & Serializable)sz -> bootstrap.setOption("sendBufferSize", (Object)BoxesRunTime.boxToInteger((int)sz)));
        this.settings().WriteBufferHighWaterMark().foreach((Function1)(JFunction1.mcVI.sp & Serializable)sz -> bootstrap.setOption("writeBufferHighWaterMark", (Object)BoxesRunTime.boxToInteger((int)sz)));
        this.settings().WriteBufferLowWaterMark().foreach((Function1)(JFunction1.mcVI.sp & Serializable)sz -> bootstrap.setOption("writeBufferLowWaterMark", (Object)BoxesRunTime.boxToInteger((int)sz)));
        return var2_2;
    }

    @Override
    public boolean isResponsibleFor(Address address) {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Future<InetSocketAddress> addressToSocketAddress(Address addr) {
        Address address = addr;
        if (address == null) return Future$.MODULE$.failed((Throwable)new IllegalArgumentException(new StringBuilder(53).append("Address [").append(addr).append("] does not contain host or port information.").toString()));
        Option<String> option = address.host();
        Option<Object> option2 = address.port();
        if (!(option instanceof Some)) return Future$.MODULE$.failed((Throwable)new IllegalArgumentException(new StringBuilder(53).append("Address [").append(addr).append("] does not contain host or port information.").toString()));
        Some some = (Some)option;
        String host = (String)some.value();
        if (!(option2 instanceof Some)) return Future$.MODULE$.failed((Throwable)new IllegalArgumentException(new StringBuilder(53).append("Address [").append(addr).append("] does not contain host or port information.").toString()));
        Some some2 = (Some)option2;
        int port = BoxesRunTime.unboxToInt((Object)some2.value());
        return Future$.MODULE$.apply((Function0 & Serializable)() -> (InetSocketAddress)scala.concurrent.package$.MODULE$.blocking((Function0 & Serializable)() -> new InetSocketAddress(InetAddress.getByName(host), port)), this.executionContext());
    }

    @Override
    public Future<Tuple2<Address, Promise<Transport.AssociationEventListener>>> listen() {
        int bindPort = this.settings().BindPortSelector();
        return this.addressToSocketAddress(Address$.MODULE$.apply("", "", this.settings().BindHostname(), bindPort)).map((Function1 & Serializable)address -> {
            Tuple2 tuple2;
            try {
                Address address2;
                Channel channel;
                Bootstrap bootstrap = this.inboundBootstrap();
                if (bootstrap instanceof ServerBootstrap) {
                    ServerBootstrap serverBootstrap = (ServerBootstrap)bootstrap;
                    channel = serverBootstrap.bind((SocketAddress)address);
                } else if (bootstrap instanceof ConnectionlessBootstrap) {
                    ConnectionlessBootstrap connectionlessBootstrap = (ConnectionlessBootstrap)bootstrap;
                    channel = connectionlessBootstrap.bind((SocketAddress)address);
                } else {
                    throw new IllegalStateException();
                }
                Channel newServerChannel = channel;
                newServerChannel.setReadable(false);
                this.channelGroup().add(newServerChannel);
                this.serverChannel_$eq(newServerChannel);
                None$ port = this.settings().PortSelector() == 0 ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToInteger((int)this.settings().PortSelector()));
                Option<Address> option = NettyTransport$.MODULE$.addressFromSocketAddress(newServerChannel.getLocalAddress(), this.schemeIdentifier(), this.system().name(), (Option<String>)new Some((Object)this.settings().Hostname()), (Option<Object>)port);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    address2 = (Address)some.value();
                    Option<Address> option2 = NettyTransport$.MODULE$.addressFromSocketAddress(newServerChannel.getLocalAddress(), this.schemeIdentifier(), this.system().name(), (Option<String>)None$.MODULE$, (Option<Object>)None$.MODULE$);
                    if (!(option2 instanceof Some)) {
                        if (None$.MODULE$.equals(option2)) {
                            throw new NettyTransportException(new StringBuilder(29).append("Unknown local address type [").append(newServerChannel.getLocalAddress().getClass().getName()).append("]").toString());
                        }
                        throw new MatchError(option2);
                    }
                    Some some2 = (Some)option2;
                    Address address3 = (Address)some2.value();
                    this.boundTo_$eq(address3);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    if (None$.MODULE$.equals(option)) {
                        throw new NettyTransportException(new StringBuilder(29).append("Unknown local address type [").append(newServerChannel.getLocalAddress().getClass().getName()).append("]").toString());
                    }
                    throw new MatchError(option);
                }
                this.akka$remote$transport$netty$NettyTransport$$associationListenerPromise().future().foreach((Function1 & Serializable)x$6 -> newServerChannel.setReadable(true), this.executionContext());
                Tuple2 tuple22 = new Tuple2((Object)address2, this.akka$remote$transport$netty$NettyTransport$$associationListenerPromise());
                tuple2 = tuple22;
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    BoxedUnit boxedUnit;
                    Throwable e = (Throwable)option.get();
                    this.akka$remote$transport$netty$NettyTransport$$log().error("failed to bind to {}, shutting down Netty transport", address);
                    try {
                        boxedUnit = this.shutdown();
                    }
                    catch (Throwable throwable3) {
                        Option option3;
                        Throwable throwable4 = throwable3;
                        if (throwable4 == null || (option3 = NonFatal$.MODULE$.unapply(throwable4)).isEmpty()) {
                            throw throwable3;
                        }
                        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                        boxedUnit = boxedUnit2;
                    }
                    throw e;
                }
                throw throwable;
            }
            return tuple2;
        }, this.executionContext());
    }

    public Address boundAddress() {
        return this.boundTo();
    }

    @Override
    public Future<AssociationHandle> associate(Address remoteAddress) {
        Future future;
        if (!this.serverChannel().isBound()) {
            future = Future$.MODULE$.failed((Throwable)new NettyTransportException("Transport is not bound"));
        } else {
            ClientBootstrap bootstrap = this.outboundBootstrap(remoteAddress);
            future = this.addressToSocketAddress(remoteAddress).flatMap((Function1 & Serializable)socketAddress -> NettyFutureBridge$.MODULE$.apply(bootstrap.connect((SocketAddress)socketAddress)).map((Function1 & Serializable)channel -> {
                Object object = this.settings().EnableSsl() ? scala.concurrent.package$.MODULE$.blocking((Function0 & Serializable)() -> ((SslHandler)channel.getPipeline().get(SslHandler.class)).handshake().awaitUninterruptibly()) : BoxedUnit.UNIT;
                channel.setReadable(false);
                return channel;
            }, this.executionContext()).flatMap((Function1 & Serializable)readyChannel -> ((ClientHandler)readyChannel.getPipeline().get(ClientHandler.class)).statusFuture().map((Function1 & Serializable)handle -> handle, this.executionContext()), this.executionContext()), this.executionContext()).recover((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Option option;
                    A1 A1 = x1;
                    if (A1 instanceof CancellationException) {
                        throw new NettyTransportExceptionNoStack("Connection was cancelled");
                    }
                    if (A1 != null && !(option = NonFatal$.MODULE$.unapply(A1)).isEmpty()) {
                        Throwable t = (Throwable)option.get();
                        String msg = t.getCause() == null ? t.getMessage() : (t.getCause().getCause() == null ? new StringBuilder(13).append(t.getMessage()).append(", caused by: ").append(t.getCause()).toString() : new StringBuilder(26).append(t.getMessage()).append(", caused by: ").append(t.getCause()).append(", caused by: ").append(t.getCause().getCause()).toString());
                        throw new NettyTransportExceptionNoStack(new StringBuilder(2).append(t.getClass().getName()).append(": ").append(msg).toString(), t.getCause());
                    }
                    Object object = function1.apply(x1);
                    return (B1)object;
                }

                public final boolean isDefinedAt(Throwable x1) {
                    Option option;
                    Throwable throwable = x1;
                    boolean bl = throwable instanceof CancellationException ? true : throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty();
                    return bl;
                }
            }, this.executionContext());
        }
        return future;
    }

    @Override
    public Future<Object> shutdown() {
        return this.always$2(this.channelGroup().unbind()).flatMap((Function1 & Serializable)unbindStatus -> NettyTransport.$anonfun$shutdown$2(this, BoxesRunTime.unboxToBoolean((Object)unbindStatus)), this.executionContext());
    }

    public static final /* synthetic */ boolean $anonfun$shutdown$1(ChannelGroup x$7) {
        return true;
    }

    private final Future always$2(ChannelGroupFuture c) {
        return NettyFutureBridge$.MODULE$.apply(c).map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)NettyTransport.$anonfun$shutdown$1(x$7)), this.executionContext()).recover((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Boolean bl = BoxesRunTime.boxToBoolean((boolean)false);
                return (B1)bl;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = true;
                return bl;
            }
        }, this.executionContext());
    }

    public static final /* synthetic */ boolean $anonfun$shutdown$5(NettyTransport $this, boolean lastWriteStatus$1, boolean unbindStatus$1, boolean disconnectStatus$1, boolean closeStatus) {
        if ($this.settings().UseDispatcherForIo().isDefined()) {
            $this.clientChannelFactory().shutdown();
            $this.serverChannelFactory().shutdown();
        } else {
            $this.clientChannelFactory().releaseExternalResources();
            $this.serverChannelFactory().releaseExternalResources();
        }
        return lastWriteStatus$1 && unbindStatus$1 && disconnectStatus$1 && closeStatus;
    }

    public static final /* synthetic */ Future $anonfun$shutdown$4(NettyTransport $this, boolean lastWriteStatus$1, boolean unbindStatus$1, boolean disconnectStatus) {
        return $this.always$2($this.channelGroup().close()).map((Function1 & Serializable)closeStatus -> BoxesRunTime.boxToBoolean((boolean)NettyTransport.$anonfun$shutdown$5($this, lastWriteStatus$1, unbindStatus$1, disconnectStatus, BoxesRunTime.unboxToBoolean((Object)closeStatus))), $this.executionContext());
    }

    public static final /* synthetic */ Future $anonfun$shutdown$3(NettyTransport $this, boolean unbindStatus$1, boolean lastWriteStatus) {
        return $this.always$2($this.channelGroup().disconnect()).flatMap((Function1 & Serializable)disconnectStatus -> NettyTransport.$anonfun$shutdown$4($this, lastWriteStatus, unbindStatus$1, BoxesRunTime.unboxToBoolean((Object)disconnectStatus)), $this.executionContext());
    }

    public static final /* synthetic */ Future $anonfun$shutdown$2(NettyTransport $this, boolean unbindStatus) {
        return $this.always$2($this.channelGroup().write((Object)ChannelBuffers.buffer((int)0))).flatMap((Function1 & Serializable)lastWriteStatus -> NettyTransport.$anonfun$shutdown$3($this, unbindStatus, BoxesRunTime.unboxToBoolean((Object)lastWriteStatus)), $this.executionContext());
    }

    public NettyTransport(NettyTransportSettings settings, ExtendedActorSystem system) {
        SSLEngineProvider sSLEngineProvider;
        this.settings = settings;
        this.system = system;
        Transport.$init$(this);
        Dispatchers dispatchers = system.dispatchers();
        this.executionContext = (ExecutionContext)settings.UseDispatcherForIo().orElse((Function0 & Serializable)() -> {
            None$ none$;
            block3: {
                String string = ((RARP)RARP$.MODULE$.apply(this.system())).provider().remoteSettings().Dispatcher();
                switch (string == null ? 0 : string.hashCode()) {
                    case 0: {
                        if (!"".equals(string)) break;
                        none$ = None$.MODULE$;
                        break block3;
                    }
                }
                none$ = new Some((Object)string);
            }
            return none$;
        }).map((Function1 & Serializable)id -> dispatchers.lookup((String)id)).getOrElse((Function0 & Serializable)() -> this.system().dispatcher());
        this.schemeIdentifier = new StringBuilder(3).append(settings.EnableSsl() ? "ssl." : "").append("tcp").toString();
        this.akka$remote$transport$netty$NettyTransport$$log = Logging$.MODULE$.withMarker(system, NettyTransport.class, LogSource$.MODULE$.fromAnyClass());
        this.udpConnectionTable = new ConcurrentHashMap();
        this.channelGroup = new DefaultChannelGroup(new StringBuilder(41).append("akka-netty-transport-driver-channelgroup-").append(NettyTransport$.MODULE$.uniqueIdCounter().getAndIncrement()).toString());
        Executor boss = this.createExecutorService();
        Executor worker = this.createExecutorService();
        this.clientChannelFactory = new NioClientSocketChannelFactory(boss, 1, (WorkerPool)new NioWorkerPool(worker, settings.ClientSocketWorkerPoolSize()), (Timer)new HashedWheelTimer(system.threadFactory()));
        Executor boss2 = this.createExecutorService();
        Executor worker2 = this.createExecutorService();
        this.serverChannelFactory = new NioServerSocketChannelFactory(boss2, worker2, settings.ServerSocketWorkerPoolSize());
        this.akka$remote$transport$netty$NettyTransport$$associationListenerPromise = Promise$.MODULE$.apply();
        if (settings.EnableSsl()) {
            sSLEngineProvider = (SSLEngineProvider)OptionVal$Some$.MODULE$.apply(system.dynamicAccess().createInstanceFor(settings.SSLEngineProviderClassName(), (Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2(ActorSystem.class, (Object)system)})), ClassTag$.MODULE$.apply(SSLEngineProvider.class)).recover((PartialFunction)new Serializable(this){
                private static final long serialVersionUID = 0L;
                private final /* synthetic */ NettyTransport $outer;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    throw new ConfigurationException(new StringBuilder(37).append("Could not create SSLEngineProvider [").append(this.$outer.settings().SSLEngineProviderClassName()).append("]").toString(), A1);
                }

                public final boolean isDefinedAt(Throwable x1) {
                    Throwable throwable = x1;
                    boolean bl = true;
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }).get());
        } else {
            OptionVal$.MODULE$.None();
            sSLEngineProvider = null;
        }
        this.sslEngineProvider = sSLEngineProvider;
        this.serverPipelineFactory = new ChannelPipelineFactory(this){
            private final /* synthetic */ NettyTransport $outer;

            /*
             * WARNING - void declaration
             */
            public ChannelPipeline getPipeline() {
                void var1_1;
                DefaultChannelPipeline pipeline = this.$outer.akka$remote$transport$netty$NettyTransport$$newPipeline();
                if (this.$outer.settings().EnableSsl()) {
                    pipeline.addFirst("SslHandler", (ChannelHandler)this.$outer.akka$remote$transport$netty$NettyTransport$$sslHandler(false));
                }
                TcpServerHandler handler = new TcpServerHandler(this.$outer, (Future<Transport.AssociationEventListener>)this.$outer.akka$remote$transport$netty$NettyTransport$$associationListenerPromise().future(), this.$outer.akka$remote$transport$netty$NettyTransport$$log());
                pipeline.addLast("ServerHandler", (ChannelHandler)handler);
                return var1_1;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        this.inboundBootstrap = this.setupBootstrap(new ServerBootstrap(this.serverChannelFactory()), this.serverPipelineFactory());
    }

    public NettyTransport(ExtendedActorSystem system, Config conf) {
        this(new NettyTransportSettings(conf), system);
    }
}

