/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.augment;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.yangtools.yang.common.Empty;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.AugmentEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.AugmentStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DataDefinitionStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.opendaylight.yangtools.yang.model.api.stmt.UsesStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.augment.AbstractAugmentStatementSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.augment.AugmentImplicitHandlingNamespace;
import org.opendaylight.yangtools.yang.parser.spi.ParserNamespaces;
import org.opendaylight.yangtools.yang.parser.spi.meta.CopyType;
import org.opendaylight.yangtools.yang.parser.spi.meta.InferenceException;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelActionBuilder;
import org.opendaylight.yangtools.yang.parser.spi.meta.RootStmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.validation.ValidationBundles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AugmentInferenceAction
implements ModelActionBuilder.InferenceAction {
    private static final Logger LOG = LoggerFactory.getLogger(AugmentInferenceAction.class);
    private static final ImmutableSet<YangStmtMapping> NOCOPY_DEF_SET = ImmutableSet.of((Object)YangStmtMapping.USES, (Object)YangStmtMapping.WHEN, (Object)YangStmtMapping.DESCRIPTION, (Object)YangStmtMapping.REFERENCE, (Object)YangStmtMapping.STATUS);
    private final StmtContext.Mutable<SchemaNodeIdentifier, AugmentStatement, AugmentEffectiveStatement> augmentNode;
    private final ModelActionBuilder.Prerequisite<StmtContext.Mutable<?, ?, EffectiveStatement<?, ?>>> target;
    private final AbstractAugmentStatementSupport statementSupport;
    private boolean targetUnavailable;

    AugmentInferenceAction(AbstractAugmentStatementSupport statementSupport, StmtContext.Mutable<SchemaNodeIdentifier, AugmentStatement, AugmentEffectiveStatement> augmentNode, ModelActionBuilder.Prerequisite<StmtContext.Mutable<?, ?, EffectiveStatement<?, ?>>> target) {
        this.statementSupport = Objects.requireNonNull(statementSupport);
        this.augmentNode = Objects.requireNonNull(augmentNode);
        this.target = Objects.requireNonNull(target);
    }

    public void apply(ModelActionBuilder.InferenceContext ctx) {
        if (this.targetUnavailable) {
            this.augmentNode.setUnsupported();
            return;
        }
        StmtContext.Mutable augmentTargetCtx = (StmtContext.Mutable)this.target.resolve(ctx);
        if (!AugmentInferenceAction.isSupportedAugmentTarget(augmentTargetCtx) || StmtContextUtils.isInExtensionBody((StmtContext)augmentTargetCtx)) {
            this.augmentNode.setUnsupported();
            return;
        }
        if (augmentTargetCtx.hasImplicitParentSupport()) {
            this.augmentNode.addToNs(AugmentImplicitHandlingNamespace.INSTANCE, (Object)Empty.value(), (Object)augmentTargetCtx);
        }
        this.copyFromSourceToTarget((StmtContext<?, ?, ?>)this.augmentNode, (StmtContext.Mutable<?, ?, ?>)augmentTargetCtx);
        augmentTargetCtx.addEffectiveSubstatement(this.augmentNode.replicaAsChildOf(augmentTargetCtx));
    }

    public void prerequisiteFailed(Collection<? extends ModelActionBuilder.Prerequisite<?>> failed) {
        if (YangStmtMapping.USES == this.augmentNode.coerceParentContext().publicDefinition()) {
            if (!this.augmentNode.isSupportedToBuildEffective()) {
                return;
            }
            SchemaNodeIdentifier augmentArg = (SchemaNodeIdentifier)this.augmentNode.getArgument();
            Optional targetNode = ParserNamespaces.findSchemaTreeStatement(AbstractAugmentStatementSupport.getSearchRoot(this.augmentNode), (SchemaNodeIdentifier)augmentArg);
            if (targetNode.isPresent() && StmtContextUtils.isUnknownStatement((StmtContext)((StmtContext)targetNode.orElseThrow()))) {
                this.augmentNode.setUnsupported();
                LOG.warn("Uses-augment to unknown node {}. Augmentation has not been performed. At line: {}", (Object)augmentArg, (Object)this.augmentNode.sourceReference());
                return;
            }
        }
        throw new InferenceException(this.augmentNode, "Augment target '%s' not found", new Object[]{this.augmentNode.argument()});
    }

    public void prerequisiteUnavailable(ModelActionBuilder.Prerequisite<?> unavail) {
        if (this.target.equals(unavail)) {
            this.targetUnavailable = true;
        } else {
            this.prerequisiteFailed(List.of(unavail));
        }
    }

    private void copyFromSourceToTarget(StmtContext<?, ?, ?> sourceCtx, StmtContext.Mutable<?, ?, ?> targetCtx) {
        CopyType typeOfCopy = sourceCtx.coerceParentContext().producesDeclared(UsesStatement.class) ? CopyType.ADDED_BY_USES_AUGMENTATION : CopyType.ADDED_BY_AUGMENTATION;
        boolean skipCheckOfMandatoryNodes = this.statementSupport.allowsMandatory(sourceCtx);
        boolean unsupported = !sourceCtx.isSupportedByFeatures();
        Collection declared = sourceCtx.declaredSubstatements();
        Collection effective = sourceCtx.effectiveSubstatements();
        ArrayList buffer = new ArrayList(declared.size() + effective.size());
        for (StmtContext originalStmtCtx : declared) {
            AugmentInferenceAction.copyStatement(originalStmtCtx, targetCtx, typeOfCopy, buffer, skipCheckOfMandatoryNodes, unsupported || !originalStmtCtx.isSupportedByFeatures());
        }
        for (StmtContext originalStmtCtx : effective) {
            AugmentInferenceAction.copyStatement(originalStmtCtx, targetCtx, typeOfCopy, buffer, skipCheckOfMandatoryNodes, unsupported);
        }
        targetCtx.addEffectiveSubstatements(buffer);
    }

    private static void copyStatement(StmtContext<?, ?, ?> original, StmtContext.Mutable<?, ?, ?> target, CopyType typeOfCopy, Collection<StmtContext.Mutable<?, ?, ?>> buffer, boolean skipCheckOfMandatoryNodes, boolean unsupported) {
        if (!NOCOPY_DEF_SET.contains((Object)original.publicDefinition())) {
            AugmentInferenceAction.validateNodeCanBeCopiedByAugment(original, target, typeOfCopy, skipCheckOfMandatoryNodes);
            StmtContext.Mutable copy = target.childCopyOf(original, typeOfCopy);
            if (unsupported) {
                copy.setUnsupported();
            }
            buffer.add(copy);
        } else if (!unsupported && original.publicDefinition() == YangStmtMapping.TYPEDEF) {
            buffer.add(original.replicaAsChildOf(target));
        }
    }

    private static void validateNodeCanBeCopiedByAugment(StmtContext<?, ?, ?> sourceCtx, StmtContext.Mutable<?, ?, ?> targetCtx, CopyType typeOfCopy, boolean skipCheckOfMandatoryNodes) {
        if (!skipCheckOfMandatoryNodes && typeOfCopy == CopyType.ADDED_BY_AUGMENTATION && AugmentInferenceAction.requireCheckOfMandatoryNodes(sourceCtx, targetCtx)) {
            AugmentInferenceAction.checkForMandatoryNodes(sourceCtx);
        }
        if (sourceCtx.producesDeclared(DataDefinitionStatement.class)) {
            for (StmtContext subStatement : targetCtx.allSubstatements()) {
                if (!subStatement.producesDeclared(DataDefinitionStatement.class)) continue;
                InferenceException.throwIf((boolean)Objects.equals(sourceCtx.argument(), subStatement.argument()), sourceCtx, (String)"An augment cannot add node named '%s' because this name is already used in target", (Object[])new Object[]{sourceCtx.rawArgument()});
            }
        }
    }

    private static void checkForMandatoryNodes(StmtContext<?, ?, ?> sourceCtx) {
        if (StmtContextUtils.isNonPresenceContainer(sourceCtx)) {
            sourceCtx.allSubstatementsStream().forEach(AugmentInferenceAction::checkForMandatoryNodes);
        }
        InferenceException.throwIf((boolean)StmtContextUtils.isMandatoryNode(sourceCtx), sourceCtx, (String)"An augment cannot add node '%s' because it is mandatory and in module different than target", (Object[])new Object[]{sourceCtx.rawArgument()});
    }

    private static boolean requireCheckOfMandatoryNodes(StmtContext<?, ?, ?> sourceCtx, StmtContext.Mutable<?, ?, ?> targetCtx) {
        Object arg = sourceCtx.argument();
        if (!(arg instanceof QName)) {
            return false;
        }
        QName sourceStmtQName = (QName)arg;
        RootStmtContext.Mutable root = targetCtx.getRoot();
        do {
            Optional optPrevCopy;
            Object targetArg = targetCtx.argument();
            Verify.verify((boolean)(targetArg instanceof QName), (String)"Argument of augment target statement must be QName, not %s", (Object)targetArg);
            QName targetStmtQName = (QName)targetArg;
            if (!targetStmtQName.getModule().equals((Object)sourceStmtQName.getModule())) {
                return true;
            }
            if (StmtContextUtils.isPresenceContainer(targetCtx) || StmtContextUtils.isNotMandatoryNodeOfType(targetCtx, (StatementDefinition)YangStmtMapping.CHOICE) || StmtContextUtils.isNotMandatoryNodeOfType(targetCtx, (StatementDefinition)YangStmtMapping.LIST)) {
                return false;
            }
            if (targetCtx.history().getLastOperation() != CopyType.ADDED_BY_AUGMENTATION || !(optPrevCopy = targetCtx.getPreviousCopyCtx()).isPresent()) continue;
            StmtContext original = (StmtContext)optPrevCopy.orElseThrow();
            Object origArg = original.getArgument();
            Verify.verify((boolean)(origArg instanceof QName), (String)"Unexpected statement argument %s", (Object)origArg);
            if (!sourceStmtQName.getModule().equals((Object)((QName)origArg).getModule()) || !AbstractAugmentStatementSupport.hasWhenSubstatement(AugmentInferenceAction.getParentAugmentation(original))) continue;
            return false;
        } while ((targetCtx = targetCtx.getParentContext()) != root);
        return false;
    }

    private static StmtContext<?, ?, ?> getParentAugmentation(StmtContext<?, ?, ?> child) {
        StmtContext parent = (StmtContext)Verify.verifyNotNull((Object)child.getParentContext(), (String)"Child %s has not parent", (Object[])new Object[]{child});
        while (parent.publicDefinition() != YangStmtMapping.AUGMENT) {
            parent = (StmtContext)Verify.verifyNotNull((Object)parent.getParentContext(), (String)"Failed to find augmentation parent of %s", (Object[])new Object[]{child});
        }
        return parent;
    }

    private static boolean isSupportedAugmentTarget(StmtContext<?, ?, ?> substatementCtx) {
        Collection allowedAugmentTargets = (Collection)substatementCtx.getFromNamespace(ValidationBundles.NAMESPACE, (Object)ValidationBundles.ValidationBundleType.SUPPORTED_AUGMENT_TARGETS);
        return allowedAugmentTargets == null || allowedAugmentTargets.isEmpty() || allowedAugmentTargets.contains(substatementCtx.publicDefinition());
    }
}

