/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.eos.binding.dom.adapter;

import com.google.common.base.Verify;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterContext;
import org.opendaylight.mdsal.eos.binding.api.Entity;
import org.opendaylight.mdsal.eos.binding.api.EntityOwnershipChange;
import org.opendaylight.mdsal.eos.binding.api.EntityOwnershipListener;
import org.opendaylight.mdsal.eos.dom.api.DOMEntity;
import org.opendaylight.mdsal.eos.dom.api.DOMEntityOwnershipChange;
import org.opendaylight.mdsal.eos.dom.api.DOMEntityOwnershipListener;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DOMEntityOwnershipListenerAdapter
implements DOMEntityOwnershipListener {
    private static final Logger LOG = LoggerFactory.getLogger(DOMEntityOwnershipListenerAdapter.class);
    private final EntityOwnershipListener bindingListener;
    private final AdapterContext adapterContext;

    DOMEntityOwnershipListenerAdapter(EntityOwnershipListener bindingListener, AdapterContext adapterContext) {
        this.bindingListener = Objects.requireNonNull(bindingListener);
        this.adapterContext = Objects.requireNonNull(adapterContext);
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST_OF_RETURN_VALUE"}, justification="generic getEntity()")
    public void ownershipChanged(DOMEntityOwnershipChange ownershipChange) {
        InstanceIdentifier bindingId;
        DOMEntity domEntity = (DOMEntity)ownershipChange.getEntity();
        YangInstanceIdentifier domId = (YangInstanceIdentifier)domEntity.getIdentifier();
        try {
            bindingId = (InstanceIdentifier)Verify.verifyNotNull((Object)this.adapterContext.currentSerializer().fromYangInstanceIdentifier(domId));
        }
        catch (RuntimeException e) {
            LOG.error("Error converting DOM entity ID {} to binding InstanceIdentifier", (Object)domId, (Object)e);
            return;
        }
        Entity bindingEntity = new Entity(domEntity.getType(), bindingId);
        EntityOwnershipChange change = new EntityOwnershipChange(bindingEntity, ownershipChange.getState(), ownershipChange.inJeopardy());
        try {
            this.bindingListener.ownershipChanged(change);
        }
        catch (Exception e) {
            LOG.error("Listener {} failed during change notification {}", new Object[]{this.bindingListener, change, e});
        }
    }
}

