/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.ri.type;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.ri.type.AbstractBaseType;
import org.opendaylight.yangtools.yang.model.ri.type.AbstractDerivedType;
import org.opendaylight.yangtools.yang.model.ri.type.AbstractRestrictedType;
import org.opendaylight.yangtools.yang.model.ri.type.TypeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DerivedTypeBuilder<T extends TypeDefinition<T>>
extends TypeBuilder<T> {
    private static final Logger LOG = LoggerFactory.getLogger(DerivedTypeBuilder.class);
    private Object defaultValue;
    private String description;
    private String reference;
    private Status status = Status.CURRENT;
    private String units;

    DerivedTypeBuilder(T baseType, QName qname) {
        super((TypeDefinition)Objects.requireNonNull(baseType), qname);
        Preconditions.checkArgument((baseType instanceof AbstractBaseType || baseType instanceof AbstractDerivedType || baseType instanceof AbstractRestrictedType ? 1 : 0) != 0, (String)"Derived type can be built only from a base, derived, or restricted type, not %s", baseType);
        this.defaultValue = baseType.getDefaultValue().orElse(null);
        this.units = baseType.getUnits().orElse(null);
    }

    public void setDefaultValue(@NonNull Object defaultValue) {
        this.defaultValue = Objects.requireNonNull(defaultValue);
    }

    public final void setDescription(@NonNull String description) {
        this.description = Objects.requireNonNull(description);
    }

    public final void setReference(@NonNull String reference) {
        this.reference = Objects.requireNonNull(reference);
    }

    public final void setStatus(@NonNull Status status) {
        this.status = Objects.requireNonNull(status);
    }

    public final void setUnits(String units) {
        Objects.requireNonNull(units);
        Optional baseUnits = this.getBaseType().getUnits();
        if (baseUnits.isPresent() && !units.equals(baseUnits.get())) {
            LOG.warn("Type {} uverrides 'units' of type {} to \"{}\"", new Object[]{this.getQName(), this.getBaseType(), units});
        }
        this.units = units;
    }

    final Object getDefaultValue() {
        return this.defaultValue;
    }

    final String getDescription() {
        return this.description;
    }

    final String getReference() {
        return this.reference;
    }

    final Status getStatus() {
        return this.status;
    }

    final String getUnits() {
        return this.units;
    }
}

