/*
 * Decompiled with CFR 0.152.
 */
package tech.pantheon.triemap;

import tech.pantheon.triemap.ImmutableTrieMap;
import tech.pantheon.triemap.LNodeEntries;
import tech.pantheon.triemap.LNodeEntry;
import tech.pantheon.triemap.MainNode;
import tech.pantheon.triemap.TNode;
import tech.pantheon.triemap.VerifyException;

final class LNode<K, V>
extends MainNode<K, V> {
    private final LNodeEntries<K, V> entries;
    private final int size;

    private LNode(LNodeEntries<K, V> entries, int size) {
        this.entries = entries;
        this.size = size;
    }

    LNode(K k1, V v1, K k2, V v2) {
        this(LNodeEntries.map(k1, v1, k2, v2), 2);
    }

    LNode<K, V> insertChild(K key, V value) {
        return new LNode<K, V>(this.entries.insert(key, value), this.size + 1);
    }

    MainNode<K, V> removeChild(LNodeEntry<K, V> entry, int hc) {
        LNodeEntries<K, V> map = VerifyException.throwIfNull(this.entries.remove(entry));
        if (this.size == 2) {
            return new TNode(map.getKey(), map.getValue(), hc);
        }
        return new LNode<K, V>(map, this.size - 1);
    }

    MainNode<K, V> replaceChild(LNodeEntry<K, V> entry, V value) {
        return new LNode<K, V>(this.entries.replace(entry, value), this.size);
    }

    LNodeEntry<K, V> get(K key) {
        return this.entries.findEntry(key);
    }

    LNodeEntries<K, V> entries() {
        return this.entries;
    }

    @Override
    int trySize() {
        return this.size;
    }

    @Override
    int size(ImmutableTrieMap<?, ?> ct) {
        return this.size;
    }
}

