/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.binfmt;

import com.google.common.collect.ImmutableList;
import java.io.DataInput;
import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.data.codec.binfmt.ForwardingDataInput;
import org.opendaylight.yangtools.yang.data.codec.binfmt.NormalizedNodeDataInput;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;

abstract class AbstractNormalizedNodeDataInput
extends ForwardingDataInput
implements NormalizedNodeDataInput {
    final @NonNull DataInput input;

    AbstractNormalizedNodeDataInput(DataInput input) {
        this.input = Objects.requireNonNull(input);
    }

    @Override
    final DataInput delegate() {
        return this.input;
    }

    @Override
    public final SchemaNodeIdentifier readSchemaNodeIdentifier() throws IOException {
        boolean absolute = this.input.readBoolean();
        int size = this.input.readInt();
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)size);
        for (int i = 0; i < size; ++i) {
            builder.add((Object)this.readQName());
        }
        ImmutableList qnames = builder.build();
        return absolute ? SchemaNodeIdentifier.Absolute.of((Collection)qnames) : SchemaNodeIdentifier.Descendant.of((Collection)qnames);
    }
}

