/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.storage.journal;

import com.google.common.base.Preconditions;
import java.io.File;

public final class JournalSegmentFile {
    private static final char PART_SEPARATOR = '-';
    private static final char EXTENSION_SEPARATOR = '.';
    private static final String EXTENSION = "log";
    private final File file;

    public static boolean isSegmentFile(String name, File file) {
        return JournalSegmentFile.isSegmentFile(name, file.getName());
    }

    public static boolean isSegmentFile(String journalName, String fileName) {
        Preconditions.checkNotNull((Object)journalName, (Object)"journalName cannot be null");
        Preconditions.checkNotNull((Object)fileName, (Object)"fileName cannot be null");
        int partSeparator = fileName.lastIndexOf(45);
        int extensionSeparator = fileName.lastIndexOf(46);
        if (extensionSeparator == -1 || partSeparator == -1 || extensionSeparator < partSeparator || !fileName.endsWith(EXTENSION)) {
            return false;
        }
        for (int i = partSeparator + 1; i < extensionSeparator; ++i) {
            if (Character.isDigit(fileName.charAt(i))) continue;
            return false;
        }
        return fileName.startsWith(journalName);
    }

    static File createSegmentFile(String name, File directory, long id) {
        return new File(directory, String.format("%s-%d.log", Preconditions.checkNotNull((Object)name, (Object)"name cannot be null"), id));
    }

    JournalSegmentFile(File file) {
        this.file = file;
    }

    public File file() {
        return this.file;
    }
}

