/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema;

import com.google.common.base.Verify;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ChoiceNode;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.SystemMapNode;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListNode;
import org.opendaylight.yangtools.yang.data.api.schema.UserMapNode;
import org.opendaylight.yangtools.yang.data.api.schema.builder.CollectionNodeBuilder;
import org.opendaylight.yangtools.yang.data.api.schema.builder.DataContainerNodeBuilder;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.api.schema.stream.YangInstanceIdentifierWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.Builders;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.NormalizedNodeResult;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableLeafNodeBuilder;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;

public final class ImmutableNodes {
    private static final YangInstanceIdentifier.NodeIdentifier SCHEMACONTEXT_NAME = YangInstanceIdentifier.NodeIdentifier.create((QName)SchemaContext.NAME);

    private ImmutableNodes() {
    }

    public static @NonNull CollectionNodeBuilder<MapEntryNode, SystemMapNode> mapNodeBuilder() {
        return Builders.mapBuilder();
    }

    public static @NonNull CollectionNodeBuilder<MapEntryNode, SystemMapNode> mapNodeBuilder(QName name) {
        return ImmutableNodes.mapNodeBuilder(YangInstanceIdentifier.NodeIdentifier.create((QName)name));
    }

    public static @NonNull CollectionNodeBuilder<MapEntryNode, SystemMapNode> mapNodeBuilder(YangInstanceIdentifier.NodeIdentifier name) {
        return Builders.mapBuilder().withNodeIdentifier(name);
    }

    public static @NonNull SystemMapNode mapNode(QName name) {
        return ImmutableNodes.mapNode(YangInstanceIdentifier.NodeIdentifier.create((QName)name));
    }

    public static @NonNull SystemMapNode mapNode(YangInstanceIdentifier.NodeIdentifier name) {
        return (SystemMapNode)ImmutableNodes.mapNodeBuilder(name).build();
    }

    public static @NonNull UserMapNode orderedMapNode(QName name) {
        return ImmutableNodes.orderedMapNode(YangInstanceIdentifier.NodeIdentifier.create((QName)name));
    }

    public static @NonNull UserMapNode orderedMapNode(YangInstanceIdentifier.NodeIdentifier name) {
        return (UserMapNode)Builders.orderedMapBuilder().withNodeIdentifier(name).build();
    }

    public static <T> @NonNull LeafNode<T> leafNode(YangInstanceIdentifier.NodeIdentifier name, T value) {
        return ImmutableLeafNodeBuilder.createNode(name, value);
    }

    public static <T> @NonNull LeafNode<T> leafNode(QName name, T value) {
        return ImmutableNodes.leafNode(YangInstanceIdentifier.NodeIdentifier.create((QName)name), value);
    }

    public static @NonNull DataContainerNodeBuilder<// Could not load outer class - annotation placement on inner may be incorrect
    YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode> mapEntryBuilder(QName nodeName, QName keyName, Object keyValue) {
        return Builders.mapEntryBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)YangInstanceIdentifier.NodeIdentifierWithPredicates.of((QName)nodeName, (QName)keyName, (Object)keyValue)).withChild(ImmutableNodes.leafNode(keyName, keyValue));
    }

    public static @NonNull DataContainerNodeBuilder<// Could not load outer class - annotation placement on inner may be incorrect
    YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode> mapEntryBuilder() {
        return Builders.mapEntryBuilder();
    }

    public static @NonNull MapEntryNode mapEntry(QName nodeName, QName keyName, Object keyValue) {
        return (MapEntryNode)ImmutableNodes.mapEntryBuilder(nodeName, keyName, keyValue).build();
    }

    public static @NonNull ContainerNode containerNode(QName name) {
        return ImmutableNodes.containerNode(YangInstanceIdentifier.NodeIdentifier.create((QName)name));
    }

    public static @NonNull ContainerNode containerNode(YangInstanceIdentifier.NodeIdentifier name) {
        return (ContainerNode)Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)name).build();
    }

    public static @NonNull ChoiceNode choiceNode(QName name) {
        return ImmutableNodes.choiceNode(YangInstanceIdentifier.NodeIdentifier.create((QName)name));
    }

    public static @NonNull ChoiceNode choiceNode(YangInstanceIdentifier.NodeIdentifier name) {
        return (ChoiceNode)Builders.choiceBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)name).build();
    }

    public static @NonNull UnkeyedListNode listNode(QName name) {
        return ImmutableNodes.listNode(YangInstanceIdentifier.NodeIdentifier.create((QName)name));
    }

    public static @NonNull UnkeyedListNode listNode(YangInstanceIdentifier.NodeIdentifier name) {
        return (UnkeyedListNode)Builders.unkeyedListBuilder().withNodeIdentifier(name).build();
    }

    public static @NonNull NormalizedNode fromInstanceId(EffectiveModelContext ctx, YangInstanceIdentifier id) {
        if (id.isEmpty()) {
            return ImmutableNodes.containerNode(SCHEMACONTEXT_NAME);
        }
        NormalizedNodeResult result = new NormalizedNodeResult();
        try (NormalizedNodeStreamWriter writer = ImmutableNormalizedNodeStreamWriter.from(result);
             YangInstanceIdentifierWriter iidWriter = YangInstanceIdentifierWriter.open((NormalizedNodeStreamWriter)writer, (DataNodeContainer)ctx, (YangInstanceIdentifier)id);){
            YangInstanceIdentifier.PathArgument lastArg = id.getLastPathArgument();
            if (lastArg instanceof YangInstanceIdentifier.NodeWithValue) {
                YangInstanceIdentifier.NodeWithValue withValue = (YangInstanceIdentifier.NodeWithValue)lastArg;
                writer.scalarValue(withValue.getValue());
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to convert " + id, e);
        }
        Verify.verify((boolean)result.isFinished());
        return result.getResult();
    }
}

