/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.spi.meta;

import com.google.common.annotations.Beta;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.BoundStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

@Beta
public abstract class AbstractBooleanStatementSupport<D extends DeclaredStatement<Boolean>, E extends EffectiveStatement<Boolean, D>>
extends AbstractStatementSupport<Boolean, D, E> {
    private final @NonNull E emptyEffectiveFalse;
    private final @NonNull E emptyEffectiveTrue;
    private final @NonNull D emptyDeclaredFalse;
    private final @NonNull D emptyDeclaredTrue;

    protected AbstractBooleanStatementSupport(StatementDefinition publicDefinition, E emptyEffectiveFalse, E emptyEffectiveTrue, StatementSupport.StatementPolicy<Boolean, D> policy, YangParserConfiguration config, @Nullable SubstatementValidator validator) {
        super(publicDefinition, policy, config, validator);
        this.emptyEffectiveFalse = (EffectiveStatement)Objects.requireNonNull(emptyEffectiveFalse);
        this.emptyEffectiveTrue = (EffectiveStatement)Objects.requireNonNull(emptyEffectiveTrue);
        this.emptyDeclaredFalse = (DeclaredStatement)Verify.verifyNotNull((Object)emptyEffectiveFalse.getDeclared());
        this.emptyDeclaredTrue = (DeclaredStatement)Verify.verifyNotNull((Object)emptyEffectiveTrue.getDeclared());
    }

    @Override
    public final Boolean parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        if ("true".equals(value)) {
            return Boolean.TRUE;
        }
        if ("false".equals(value)) {
            return Boolean.FALSE;
        }
        throw new SourceException(ctx, "Invalid '%s' statement %s '%s', it can be either 'true' or 'false'", this.statementName(), this.argumentName(), value);
    }

    @Override
    public final String internArgument(String rawArgument) {
        if ("true".equals(rawArgument)) {
            return "true";
        }
        if ("false".equals(rawArgument)) {
            return "false";
        }
        return rawArgument;
    }

    @Override
    protected final D createDeclared(BoundStmtCtx<Boolean> ctx, ImmutableList<DeclaredStatement<?>> substatements) {
        Boolean argument = ctx.getArgument();
        if (substatements.isEmpty()) {
            return argument != false ? this.emptyDeclaredTrue : this.emptyDeclaredFalse;
        }
        return this.createDeclared(argument, substatements);
    }

    protected abstract @NonNull D createDeclared(@NonNull Boolean var1, @NonNull ImmutableList<DeclaredStatement<?>> var2);

    @Override
    protected final E createEffective(EffectiveStmtCtx.Current<Boolean, D> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return substatements.isEmpty() ? this.createEmptyEffective(stmt) : this.createEffective(stmt.declared(), substatements);
    }

    protected abstract @NonNull E createEffective(@NonNull D var1, ImmutableList<? extends EffectiveStatement<?, ?>> var2);

    protected abstract @NonNull E createEmptyEffective(@NonNull D var1);

    private @NonNull E createEmptyEffective(EffectiveStmtCtx.Current<Boolean, D> stmt) {
        DeclaredStatement declared = stmt.declared();
        if (this.emptyDeclaredTrue.equals(declared)) {
            return this.emptyEffectiveTrue;
        }
        if (this.emptyDeclaredFalse.equals(declared)) {
            return this.emptyEffectiveFalse;
        }
        return this.createEmptyEffective(declared);
    }
}

