/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.eos.akka.registry.candidate;

import akka.actor.ClassicActorSystemProvider;
import akka.actor.typed.ActorSystem;
import akka.actor.typed.Behavior;
import akka.actor.typed.javadsl.AbstractBehavior;
import akka.actor.typed.javadsl.ActorContext;
import akka.actor.typed.javadsl.Behaviors;
import akka.actor.typed.javadsl.Receive;
import akka.cluster.Cluster;
import akka.cluster.ddata.Key;
import akka.cluster.ddata.ORMap;
import akka.cluster.ddata.ORMapKey;
import akka.cluster.ddata.ORSet;
import akka.cluster.ddata.ReplicatedData;
import akka.cluster.ddata.SelfUniqueAddress;
import akka.cluster.ddata.typed.javadsl.DistributedData;
import akka.cluster.ddata.typed.javadsl.Replicator;
import akka.cluster.ddata.typed.javadsl.ReplicatorMessageAdapter;
import akka.japi.function.Function;
import java.io.Serializable;
import java.util.Set;
import org.opendaylight.controller.eos.akka.registry.candidate.command.CandidateRegistryCommand;
import org.opendaylight.controller.eos.akka.registry.candidate.command.InternalUpdateResponse;
import org.opendaylight.controller.eos.akka.registry.candidate.command.RegisterCandidate;
import org.opendaylight.controller.eos.akka.registry.candidate.command.UnregisterCandidate;
import org.opendaylight.mdsal.eos.dom.api.DOMEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CandidateRegistry
extends AbstractBehavior<CandidateRegistryCommand> {
    private static final Logger LOG = LoggerFactory.getLogger(CandidateRegistry.class);
    private static final String DATACENTER_PREFIX = "dc-";
    public static final Key<ORMap<DOMEntity, ORSet<String>>> KEY = new ORMapKey("candidateRegistry");
    private final ReplicatorMessageAdapter<CandidateRegistryCommand, ORMap<DOMEntity, ORSet<String>>> replicatorAdapter;
    private final SelfUniqueAddress node;
    private final String selfRole;

    private CandidateRegistry(ActorContext<CandidateRegistryCommand> context, ReplicatorMessageAdapter<CandidateRegistryCommand, ORMap<DOMEntity, ORSet<String>>> replicatorAdapter) {
        super(context);
        this.replicatorAdapter = replicatorAdapter;
        this.node = DistributedData.get((ActorSystem)context.getSystem()).selfUniqueAddress();
        this.selfRole = CandidateRegistry.extractRole(Cluster.get((ClassicActorSystemProvider)context.getSystem()).selfMember().getRoles());
        LOG.debug("{} : Candidate registry started", (Object)this.selfRole);
    }

    public static Behavior<CandidateRegistryCommand> create() {
        return Behaviors.setup((Function & Serializable)ctx -> DistributedData.withReplicatorMessageAdapter(replicatorAdapter -> new CandidateRegistry((ActorContext<CandidateRegistryCommand>)ctx, (ReplicatorMessageAdapter<CandidateRegistryCommand, ORMap<DOMEntity, ORSet<String>>>)replicatorAdapter)));
    }

    public Receive<CandidateRegistryCommand> createReceive() {
        return this.newReceiveBuilder().onMessage(RegisterCandidate.class, this::onRegisterCandidate).onMessage(UnregisterCandidate.class, this::onUnregisterCandidate).onMessage(InternalUpdateResponse.class, this::onInternalUpdateResponse).build();
    }

    private Behavior<CandidateRegistryCommand> onRegisterCandidate(RegisterCandidate registerCandidate) {
        LOG.debug("{} - Registering candidate({}) for entity: {}", new Object[]{this.selfRole, registerCandidate.getCandidate(), registerCandidate.getEntity()});
        this.replicatorAdapter.askUpdate(askReplyTo -> new Replicator.Update(KEY, (ReplicatedData)ORMap.empty(), Replicator.writeLocal(), askReplyTo, map -> map.update(this.node, (Object)registerCandidate.getEntity(), (ReplicatedData)ORSet.empty(), value -> value.add(this.node, (Object)registerCandidate.getCandidate()))), InternalUpdateResponse::new);
        return this;
    }

    private Behavior<CandidateRegistryCommand> onUnregisterCandidate(UnregisterCandidate unregisterCandidate) {
        LOG.debug("{} - Removing candidate({}) from entity: {}", new Object[]{this.selfRole, unregisterCandidate.getCandidate(), unregisterCandidate.getEntity()});
        this.replicatorAdapter.askUpdate(askReplyTo -> new Replicator.Update(KEY, (ReplicatedData)ORMap.empty(), Replicator.writeLocal(), askReplyTo, map -> map.update(this.node, (Object)unregisterCandidate.getEntity(), (ReplicatedData)ORSet.empty(), value -> value.remove(this.node, (Object)unregisterCandidate.getCandidate()))), InternalUpdateResponse::new);
        return this;
    }

    private Behavior<CandidateRegistryCommand> onInternalUpdateResponse(InternalUpdateResponse updateResponse) {
        LOG.debug("{} : Received update response: {}", (Object)this.selfRole, updateResponse.getRsp());
        return this;
    }

    private static String extractRole(Set<String> roles) {
        return roles.stream().filter(role -> !role.contains(DATACENTER_PREFIX)).findFirst().orElseThrow(() -> new IllegalArgumentException("No valid role found."));
    }
}

