/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.blueprint.ext;

import org.opendaylight.mdsal.binding.api.NotificationService;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.binding.NotificationListener;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationListenerBean {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationListenerBean.class);
    static final String NOTIFICATION_LISTENER = "notification-listener";
    private Bundle bundle;
    private NotificationService notificationService;
    private NotificationListener notificationListener;
    private ListenerRegistration<?> registration;

    public void setNotificationService(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    public void setNotificationListener(NotificationListener notificationListener) {
        this.notificationListener = notificationListener;
    }

    public void setBundle(Bundle bundle) {
        this.bundle = bundle;
    }

    public void init() {
        LOG.debug("{}: init - registering NotificationListener {}", (Object)this.bundle.getSymbolicName(), (Object)this.notificationListener);
        this.registration = this.notificationService.registerNotificationListener(this.notificationListener);
    }

    public void destroy() {
        if (this.registration != null) {
            LOG.debug("{}: destroy - closing ListenerRegistration {}", (Object)this.bundle.getSymbolicName(), (Object)this.notificationListener);
            this.registration.close();
        } else {
            LOG.debug("{}: destroy - listener was not registered", (Object)this.bundle.getSymbolicName());
        }
    }
}

