/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import java.io.IOException;
import org.opendaylight.mdsal.binding.dom.codec.impl.AbstractBindingNormalizedNodeCache;
import org.opendaylight.mdsal.binding.dom.codec.impl.AbstractBindingNormalizedNodeCacheHolder;
import org.opendaylight.mdsal.binding.dom.codec.impl.AnydataBindingStreamWriter;
import org.opendaylight.mdsal.binding.dom.codec.impl.BindingSerializer;
import org.opendaylight.mdsal.binding.dom.codec.impl.BindingToNormalizedStreamWriter;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataContainerCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataObjectCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.ForwardingBindingStreamEventWriter;
import org.opendaylight.mdsal.binding.dom.codec.impl.LeafNodeCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.NormalizedNodeWriterWithAddChild;
import org.opendaylight.mdsal.binding.dom.codec.impl.ValueNodeCodecContext;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.TypeObject;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.NormalizedNodeResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CachingNormalizedNodeSerializer
extends ForwardingBindingStreamEventWriter
implements BindingSerializer<Object, DataObject> {
    private static final Logger LOG = LoggerFactory.getLogger(CachingNormalizedNodeSerializer.class);
    private final NormalizedNodeResult domResult;
    private final NormalizedNodeWriterWithAddChild domWriter;
    private final BindingToNormalizedStreamWriter delegate;
    private final AbstractBindingNormalizedNodeCacheHolder cacheHolder;

    CachingNormalizedNodeSerializer(AbstractBindingNormalizedNodeCacheHolder cacheHolder, DataContainerCodecContext<?, ?> subtreeRoot) {
        this.cacheHolder = cacheHolder;
        this.domResult = new NormalizedNodeResult();
        this.domWriter = new NormalizedNodeWriterWithAddChild(this.domResult);
        this.delegate = BindingToNormalizedStreamWriter.create(subtreeRoot, (NormalizedNodeStreamWriter)this.domWriter);
    }

    @Override
    protected AnydataBindingStreamWriter delegate() {
        return this.delegate;
    }

    NormalizedNode build() {
        return this.domResult.getResult();
    }

    @Override
    public void leafNode(String localName, Object value) throws IOException {
        TypeObject typed;
        Class<?> type;
        if (value instanceof TypeObject && this.cacheHolder.isCached(type = (typed = (TypeObject)value).getClass())) {
            ValueNodeCodecContext context = ((DataObjectCodecContext)this.delegate.current()).getLeafChild(localName);
            if (context instanceof LeafNodeCodecContext.OfTypeObject) {
                AbstractBindingNormalizedNodeCache<TypeObject, LeafNodeCodecContext.OfTypeObject> cache = this.cacheHolder.getCachingSerializer((LeafNodeCodecContext.OfTypeObject)context);
                if (cache != null) {
                    this.domWriter.addChild(cache.get(typed));
                    return;
                }
                LOG.debug("Unexpected failure to acquire cache for context {}, skipping caching", (Object)context);
            } else {
                LOG.debug("Context {} does not match expected TypeObject {}, skipping caching", (Object)context, (Object)typed);
            }
        }
        super.leafNode(localName, value);
    }

    @Override
    public NormalizedNode serialize(DataObject input) {
        AbstractBindingNormalizedNodeCache<DataObject, ?> cachingSerializer = this.getCacheSerializer(input.implementedInterface());
        if (cachingSerializer != null) {
            NormalizedNode domData = cachingSerializer.get(input);
            this.domWriter.addChild(domData);
            return domData;
        }
        return null;
    }

    private AbstractBindingNormalizedNodeCache<DataObject, ?> getCacheSerializer(Class<? extends DataObject> type) {
        if (this.cacheHolder.isCached(type)) {
            DataContainerCodecContext currentCtx = (DataContainerCodecContext)this.delegate.current();
            if (type.equals(currentCtx.getBindingClass())) {
                return this.cacheHolder.getCachingSerializer(currentCtx);
            }
            return this.cacheHolder.getCachingSerializer(currentCtx.streamChild(type));
        }
        return null;
    }

    static NormalizedNode serializeUsingStreamWriter(AbstractBindingNormalizedNodeCacheHolder cacheHolder, DataContainerCodecContext<?, ?> subtreeRoot, DataObject data) {
        CachingNormalizedNodeSerializer writer = new CachingNormalizedNodeSerializer(cacheHolder, subtreeRoot);
        try {
            subtreeRoot.eventStreamSerializer().serialize(data, writer);
            return writer.build();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

