/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataContainerCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataContainerCodecPrototype;
import org.opendaylight.mdsal.binding.dom.codec.impl.NodeCodecContext;
import org.opendaylight.mdsal.binding.model.api.JavaTypeName;
import org.opendaylight.mdsal.binding.runtime.api.BindingRuntimeContext;
import org.opendaylight.mdsal.binding.runtime.api.CaseRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.ChoiceRuntimeType;
import org.opendaylight.yangtools.yang.binding.DataContainer;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ChoiceNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextNode;
import org.opendaylight.yangtools.yang.data.util.NormalizedNodeSchemaUtils;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DocumentedNode;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ChoiceNodeCodecContext<D extends DataObject>
extends DataContainerCodecContext<D, ChoiceRuntimeType> {
    private static final Logger LOG = LoggerFactory.getLogger(ChoiceNodeCodecContext.class);
    private final ImmutableMap<YangInstanceIdentifier.PathArgument, DataContainerCodecPrototype<?>> byYangCaseChild;
    private final ImmutableListMultimap<Class<?>, DataContainerCodecPrototype<?>> ambiguousByCaseChildClass;
    private final ImmutableMap<Class<?>, DataContainerCodecPrototype<?>> byCaseChildClass;
    private final ImmutableMap<Class<?>, DataContainerCodecPrototype<?>> byClass;
    private final Set<Class<?>> ambiguousByCaseChildWarnings;

    ChoiceNodeCodecContext(DataContainerCodecPrototype<ChoiceRuntimeType> prototype) {
        super(prototype);
        HashMap<Object, Object> byYangCaseChildBuilder = new HashMap<Object, Object>();
        HashMap<Class<Object>, Object> byClassBuilder = new HashMap<Class<Object>, Object>();
        SetMultimap childToCase = MultimapBuilder.SetMultimapBuilder.hashKeys().hashSetValues().build();
        ChoiceRuntimeType choiceType = prototype.getType();
        NodeCodecContext.CodecContextFactory factory = prototype.getFactory();
        HashSet<JavaTypeName> localCases = new HashSet<JavaTypeName>();
        for (CaseRuntimeType caseType : choiceType.validCaseChildren()) {
            DataContainerCodecPrototype<CaseRuntimeType> cazeDef = ChoiceNodeCodecContext.loadCase(factory, caseType);
            localCases.add(caseType.getIdentifier());
            byClassBuilder.put(cazeDef.getBindingClass(), cazeDef);
            Class<?> clazz = cazeDef.getBindingClass();
            for (Class<DataObject> cazeChild : ChoiceNodeCodecContext.getChildrenClasses(clazz)) {
                childToCase.put(cazeChild, (Object)cazeDef);
            }
            for (EffectiveStatement stmt : ((CaseRuntimeType)cazeDef.getType()).statement().effectiveSubstatements()) {
                AugmentationSchemaNode augment;
                if (!(stmt instanceof DataSchemaNode)) continue;
                DataSchemaNode cazeChild = (DataSchemaNode)stmt;
                if (cazeChild.isAugmenting() && (augment = NormalizedNodeSchemaUtils.findCorrespondingAugment((DataSchemaNode)((DataSchemaNode)((CaseRuntimeType)cazeDef.getType()).statement()), (DataSchemaNode)cazeChild)) != null) {
                    byYangCaseChildBuilder.put(DataSchemaContextNode.augmentationIdentifierFrom((AugmentationSchemaNode)augment), cazeDef);
                    continue;
                }
                byYangCaseChildBuilder.put(YangInstanceIdentifier.NodeIdentifier.create((QName)cazeChild.getQName()), cazeDef);
            }
        }
        this.byYangCaseChild = ImmutableMap.copyOf(byYangCaseChildBuilder);
        ImmutableListMultimap.Builder ambiguousByCaseBuilder = ImmutableListMultimap.builder();
        ImmutableMap.Builder unambiguousByCaseBuilder = ImmutableMap.builder();
        for (Map.Entry entry : Multimaps.asMap((SetMultimap)childToCase).entrySet()) {
            Set cases = (Set)entry.getValue();
            if (cases.size() != 1) {
                ArrayList<DataContainerCodecPrototype> list = new ArrayList<DataContainerCodecPrototype>((Collection)entry.getValue());
                list.sort(Comparator.comparing(proto -> proto.getBindingClass().getCanonicalName()));
                ambiguousByCaseBuilder.putAll((Object)((Class)entry.getKey()), list);
                continue;
            }
            unambiguousByCaseBuilder.put((Object)((Class)entry.getKey()), (Object)((DataContainerCodecPrototype)cases.iterator().next()));
        }
        this.byCaseChildClass = unambiguousByCaseBuilder.build();
        this.ambiguousByCaseChildClass = ambiguousByCaseBuilder.build();
        this.ambiguousByCaseChildWarnings = this.ambiguousByCaseChildClass.isEmpty() ? ImmutableSet.of() : ConcurrentHashMap.newKeySet();
        HashMap bySubstitutionBuilder = new HashMap();
        BindingRuntimeContext bindingRuntimeContext = factory.getRuntimeContext();
        block4: for (CaseRuntimeType caseType : bindingRuntimeContext.getTypes().allCaseChildren(choiceType)) {
            JavaTypeName caseName = caseType.getIdentifier();
            if (localCases.contains(caseName)) continue;
            Class<?> substitution = ChoiceNodeCodecContext.loadCase(bindingRuntimeContext, caseType);
            for (Map.Entry real : byClassBuilder.entrySet()) {
                if (!ChoiceNodeCodecContext.isSubstitutionFor(substitution, (Class)real.getKey())) continue;
                bySubstitutionBuilder.put(substitution, (DataContainerCodecPrototype)real.getValue());
                continue block4;
            }
        }
        byClassBuilder.putAll(bySubstitutionBuilder);
        this.byClass = ImmutableMap.copyOf(byClassBuilder);
    }

    private static DataContainerCodecPrototype<CaseRuntimeType> loadCase(NodeCodecContext.CodecContextFactory factory, CaseRuntimeType caseType) {
        return DataContainerCodecPrototype.from(ChoiceNodeCodecContext.loadCase(factory.getRuntimeContext(), caseType), caseType, factory);
    }

    private static Class<?> loadCase(BindingRuntimeContext context, CaseRuntimeType caseType) {
        JavaTypeName className = caseType.getIdentifier();
        try {
            return context.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new LinkageError("Failed to load class for " + className, e);
        }
    }

    public DocumentedNode.WithStatus getSchema() {
        return (DocumentedNode.WithStatus)((ChoiceRuntimeType)this.getType()).statement();
    }

    @Override
    public <C extends DataObject> DataContainerCodecContext<C, ?> streamChild(Class<C> childClass) {
        DataContainerCodecPrototype child = (DataContainerCodecPrototype)this.byClass.get(childClass);
        return this.childNonNull(child, childClass, "Supplied class %s is not valid case in %s", childClass, this.bindingArg()).get();
    }

    @Override
    public <C extends DataObject> Optional<DataContainerCodecContext<C, ?>> possibleStreamChild(Class<C> childClass) {
        DataContainerCodecPrototype child = (DataContainerCodecPrototype)this.byClass.get(childClass);
        if (child != null) {
            return Optional.of(child.get());
        }
        return Optional.empty();
    }

    Iterable<Class<?>> getCaseChildrenClasses() {
        return Iterables.concat((Iterable)this.byCaseChildClass.keySet(), (Iterable)this.ambiguousByCaseChildClass.keySet());
    }

    @Override
    public NodeCodecContext yangPathArgumentChild(YangInstanceIdentifier.PathArgument arg) {
        DataContainerCodecPrototype cazeProto = arg instanceof YangInstanceIdentifier.NodeIdentifierWithPredicates ? (DataContainerCodecPrototype)this.byYangCaseChild.get((Object)new YangInstanceIdentifier.NodeIdentifier(arg.getNodeType())) : (DataContainerCodecPrototype)this.byYangCaseChild.get((Object)arg);
        return ((DataContainerCodecContext)this.childNonNull(cazeProto, arg, "Argument %s is not valid child of %s", arg, this.getSchema()).get()).yangPathArgumentChild(arg);
    }

    @SuppressFBWarnings(value={"NP_NONNULL_RETURN_VIOLATION"}, justification="See FIXME below")
    public D deserialize(NormalizedNode data) {
        ChoiceNode casted = ChoiceNodeCodecContext.checkDataArgument(ChoiceNode.class, data);
        NormalizedNode first = (NormalizedNode)Iterables.getFirst((Iterable)casted.body(), null);
        if (first == null) {
            return null;
        }
        DataContainerCodecPrototype caze = (DataContainerCodecPrototype)this.byYangCaseChild.get((Object)first.getIdentifier());
        return (D)((DataObject)caze.get().deserialize(data));
    }

    @Override
    protected Object deserializeObject(NormalizedNode normalizedNode) {
        return this.deserialize(normalizedNode);
    }

    public InstanceIdentifier.PathArgument deserializePathArgument(YangInstanceIdentifier.PathArgument arg) {
        Preconditions.checkArgument((boolean)this.getDomPathArgument().equals(arg));
        return null;
    }

    public YangInstanceIdentifier.PathArgument serializePathArgument(InstanceIdentifier.PathArgument arg) {
        return this.getDomPathArgument();
    }

    DataContainerCodecContext<?, ?> getCaseByChildClass(@NonNull Class<? extends DataObject> type) {
        ImmutableList inexact;
        DataContainerCodecPrototype result = (DataContainerCodecPrototype)this.byCaseChildClass.get(type);
        if (result == null && !(inexact = this.ambiguousByCaseChildClass.get(type)).isEmpty()) {
            result = (DataContainerCodecPrototype)inexact.get(0);
            if (this.ambiguousByCaseChildWarnings.add(type)) {
                LOG.warn("Ambiguous reference {} to child of {} resolved to {}, the first case in {} This mapping is not guaranteed to be stable and is subject to variations based on runtime circumstances. Please see the stack trace for hints about the source of ambiguity.", new Object[]{type, this.bindingArg(), result.getBindingClass(), Lists.transform((List)inexact, DataContainerCodecPrototype::getBindingClass), new Throwable()});
            }
        }
        return this.childNonNull(result, type, "Class %s is not child of any cases for %s", type, this.bindingArg()).get();
    }

    private static Iterable<Class<? extends DataObject>> getChildrenClasses(Class<? extends DataContainer> type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"Target type must not be null");
        Preconditions.checkArgument((boolean)DataContainer.class.isAssignableFrom(type), (Object)"Supplied type must be derived from DataContainer");
        LinkedList<Class<? extends DataObject>> ret = new LinkedList<Class<? extends DataObject>>();
        for (Method method : type.getMethods()) {
            Optional<Class<DataContainer>> entity = ChoiceNodeCodecContext.getYangModeledReturnType(method, "get");
            if (!entity.isPresent()) continue;
            ret.add(entity.get());
        }
        return ret;
    }
}

