/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingDataObjectCodecTreeNode;
import org.opendaylight.mdsal.binding.dom.codec.api.IncorrectNestingException;
import org.opendaylight.mdsal.binding.dom.codec.impl.ChoiceNodeCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.CodecDataObject;
import org.opendaylight.mdsal.binding.dom.codec.impl.CodecDataObjectGenerator;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataContainerCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataContainerCodecPrototype;
import org.opendaylight.mdsal.binding.dom.codec.impl.NodeCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.NodeContextSupplier;
import org.opendaylight.mdsal.binding.dom.codec.impl.PropertyInfo;
import org.opendaylight.mdsal.binding.dom.codec.impl.ValueNodeCodecContext;
import org.opendaylight.mdsal.binding.model.api.GeneratedType;
import org.opendaylight.mdsal.binding.model.api.JavaTypeName;
import org.opendaylight.mdsal.binding.model.api.Type;
import org.opendaylight.mdsal.binding.runtime.api.AugmentRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.AugmentableRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.BindingRuntimeContext;
import org.opendaylight.mdsal.binding.runtime.api.ChoiceRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.CompositeRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.GeneratedRuntimeType;
import org.opendaylight.mdsal.binding.spec.reflect.BindingReflections;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataContainer;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.OpaqueObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.AugmentationNode;
import org.opendaylight.yangtools.yang.data.api.schema.DistinctNodeContainer;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.model.api.DocumentedNode;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaTreeEffectiveStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public abstract class DataObjectCodecContext<D extends DataObject, T extends CompositeRuntimeType>
extends DataContainerCodecContext<D, T> {
    private static final Logger LOG = LoggerFactory.getLogger(DataObjectCodecContext.class);
    private static final MethodType CONSTRUCTOR_TYPE = MethodType.methodType(Void.TYPE, DataObjectCodecContext.class, DistinctNodeContainer.class);
    private static final MethodType DATAOBJECT_TYPE = MethodType.methodType(DataObject.class, DataObjectCodecContext.class, DistinctNodeContainer.class);
    private static final VarHandle MISMATCHED_AUGMENTED;
    private final ImmutableMap<String, ValueNodeCodecContext> leafChild;
    private final ImmutableMap<YangInstanceIdentifier.PathArgument, NodeContextSupplier> byYang;
    private final ImmutableMap<Class<?>, DataContainerCodecPrototype<?>> byStreamClass;
    private final ImmutableMap<Class<?>, DataContainerCodecPrototype<?>> byBindingArgClass;
    private final ImmutableMap<YangInstanceIdentifier.PathArgument, DataContainerCodecPrototype<?>> augmentationByYang;
    private final ImmutableMap<Class<?>, DataContainerCodecPrototype<?>> augmentationByStream;
    private final @NonNull Class<? extends CodecDataObject<?>> generatedClass;
    private final MethodHandle proxyConstructor;
    private volatile ImmutableMap<Class<?>, DataContainerCodecPrototype<?>> mismatchedAugmented = ImmutableMap.of();

    DataObjectCodecContext(DataContainerCodecPrototype<T> prototype) {
        this(prototype, null);
    }

    DataObjectCodecContext(DataContainerCodecPrototype<T> prototype, Method keyMethod) {
        super(prototype);
        MethodHandle ctor;
        List possibleAugmentations;
        Method method;
        Class bindingClass = this.getBindingClass();
        ImmutableMap<Method, ValueNodeCodecContext> tmpLeaves = this.factory().getLeafNodes(bindingClass, ((CompositeRuntimeType)this.getType()).statement());
        Map<Class<DataContainer>, Method> clsToMethod = DataObjectCodecContext.getChildrenClassToMethod(bindingClass);
        HashMap<Object, Object> byYangBuilder = new HashMap<Object, Object>();
        HashMap byStreamClassBuilder = new HashMap();
        HashMap byBindingArgClassBuilder = new HashMap();
        ImmutableMap.Builder leafChildBuilder = ImmutableMap.builderWithExpectedSize((int)tmpLeaves.size());
        for (Iterator<Map.Entry<Class<DataContainer>, Method>> leaf : tmpLeaves.values()) {
            leafChildBuilder.put((Object)((ValueNodeCodecContext)((Object)leaf)).getSchema().getQName().getLocalName(), (Object)leaf);
            byYangBuilder.put(((ValueNodeCodecContext)((Object)leaf)).getDomPathArgument(), leaf);
        }
        this.leafChild = leafChildBuilder.build();
        HashMap daoProperties = new HashMap();
        for (Map.Entry entry : clsToMethod.entrySet()) {
            method = (Method)entry.getValue();
            Verify.verify((!method.isDefault() ? 1 : 0) != 0, (String)"Unexpected default method %s in %s", (Object)method, bindingClass);
            Class retClass = (Class)entry.getKey();
            if (OpaqueObject.class.isAssignableFrom(retClass)) continue;
            daoProperties.put(retClass, new PropertyInfo.Getter(method));
            DataContainerCodecPrototype<?> childProto = this.loadChildPrototype(retClass);
            byStreamClassBuilder.put(childProto.getBindingClass(), childProto);
            byYangBuilder.put(childProto.getYangArg(), childProto);
            if (!(childProto.getType() instanceof ChoiceRuntimeType)) continue;
            ChoiceNodeCodecContext choice = (ChoiceNodeCodecContext)childProto.get();
            for (Class<?> cazeChild : choice.getCaseChildrenClasses()) {
                byBindingArgClassBuilder.put(cazeChild, childProto);
            }
        }
        for (Map.Entry<Class<DataContainer>, Method> entry : DataObjectCodecContext.getChildrenClassToNonnullMethod(bindingClass).entrySet()) {
            method = entry.getValue();
            if (method.isDefault()) continue;
            daoProperties.compute(entry.getKey(), (key, value) -> new PropertyInfo.GetterAndNonnull(((PropertyInfo)Verify.verifyNotNull((Object)value, (String)"No getter for %s", (Object[])new Object[]{key})).getterMethod(), method));
        }
        this.byYang = ImmutableMap.copyOf(byYangBuilder);
        this.byStreamClass = ImmutableMap.copyOf(byStreamClassBuilder);
        byBindingArgClassBuilder.putAll(byStreamClassBuilder);
        ImmutableMap immutableMap = this.byBindingArgClass = byStreamClassBuilder.equals(byBindingArgClassBuilder) ? this.byStreamClass : ImmutableMap.copyOf(byBindingArgClassBuilder);
        if (Augmentable.class.isAssignableFrom(bindingClass)) {
            CompositeRuntimeType compositeRuntimeType = (CompositeRuntimeType)this.getType();
            Verify.verify((boolean)(compositeRuntimeType instanceof AugmentableRuntimeType), (String)"Unexpected type %s backing augmenable %s", (Object)compositeRuntimeType, bindingClass);
            possibleAugmentations = ((AugmentableRuntimeType)compositeRuntimeType).augments();
            this.generatedClass = CodecDataObjectGenerator.generateAugmentable(prototype.getFactory().getLoader(), bindingClass, tmpLeaves, daoProperties, keyMethod);
        } else {
            possibleAugmentations = List.of();
            this.generatedClass = CodecDataObjectGenerator.generate(prototype.getFactory().getLoader(), bindingClass, tmpLeaves, daoProperties, keyMethod);
        }
        HashMap hashMap = new HashMap();
        HashMap augByStream = new HashMap();
        for (AugmentRuntimeType augment : possibleAugmentations) {
            Class<?> augBindingClass;
            DataContainerCodecPrototype<?> augProto = this.loadAugmentPrototype(augment);
            if (augProto == null) continue;
            YangInstanceIdentifier.PathArgument augYangArg = augProto.getYangArg();
            if (hashMap.putIfAbsent(augYangArg, augProto) == null) {
                LOG.trace("Discovered new YANG mapping {} -> {} in {}", new Object[]{augYangArg, augProto, this});
            }
            if (augByStream.putIfAbsent(augBindingClass = augProto.getBindingClass(), augProto) != null) continue;
            LOG.trace("Discovered new class mapping {} -> {} in {}", new Object[]{augBindingClass, augProto, this});
        }
        this.augmentationByYang = ImmutableMap.copyOf(hashMap);
        this.augmentationByStream = ImmutableMap.copyOf(augByStream);
        try {
            ctor = MethodHandles.publicLookup().findConstructor(this.generatedClass, CONSTRUCTOR_TYPE);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new LinkageError("Failed to find contructor for class " + this.generatedClass, e);
        }
        this.proxyConstructor = ctor.asType(DATAOBJECT_TYPE);
    }

    public final DocumentedNode.WithStatus getSchema() {
        return (DocumentedNode.WithStatus)((CompositeRuntimeType)this.getType()).statement();
    }

    @Override
    public <C extends DataObject> DataContainerCodecContext<C, ?> streamChild(Class<C> childClass) {
        return this.childNonNull(this.streamChildPrototype(childClass), childClass, "Child %s is not valid child of %s", this.getBindingClass(), childClass).get();
    }

    private DataContainerCodecPrototype<?> streamChildPrototype(Class<?> childClass) {
        DataContainerCodecPrototype childProto = (DataContainerCodecPrototype)this.byStreamClass.get(childClass);
        if (childProto != null) {
            return childProto;
        }
        if (Augmentation.class.isAssignableFrom(childClass)) {
            return this.augmentationByClass(childClass);
        }
        return null;
    }

    @Override
    public <C extends DataObject> Optional<DataContainerCodecContext<C, ?>> possibleStreamChild(Class<C> childClass) {
        DataContainerCodecPrototype<C> childProto = this.streamChildPrototype(childClass);
        if (childProto != null) {
            return Optional.of(childProto.get());
        }
        return Optional.empty();
    }

    @Override
    public DataContainerCodecContext<?, ?> bindingPathArgumentChild(InstanceIdentifier.PathArgument arg, List<YangInstanceIdentifier.PathArgument> builder) {
        NodeCodecContext context;
        Class argType = arg.getType();
        DataContainerCodecPrototype<?> ctxProto = (DataContainerCodecPrototype<?>)this.byBindingArgClass.get((Object)argType);
        if (ctxProto == null && Augmentation.class.isAssignableFrom(argType)) {
            ctxProto = this.augmentationByClass(argType);
        }
        if ((context = this.childNonNull(ctxProto, argType, "Class %s is not valid child of %s", argType, this.getBindingClass()).get()) instanceof ChoiceNodeCodecContext) {
            ChoiceNodeCodecContext choice = (ChoiceNodeCodecContext)context;
            choice.addYangPathArgument(arg, builder);
            Optional caseType = arg.getCaseType();
            Class type = arg.getType();
            BindingDataObjectCodecTreeNode caze = caseType.isPresent() ? choice.streamChild((Class)caseType.get()) : choice.getCaseByChildClass(type);
            caze.addYangPathArgument(arg, builder);
            return caze.bindingPathArgumentChild(arg, (List)builder);
        }
        context.addYangPathArgument(arg, builder);
        return context;
    }

    @Override
    public NodeCodecContext yangPathArgumentChild(YangInstanceIdentifier.PathArgument arg) {
        NodeContextSupplier childSupplier = arg instanceof YangInstanceIdentifier.NodeIdentifierWithPredicates ? (NodeContextSupplier)this.byYang.get((Object)new YangInstanceIdentifier.NodeIdentifier(arg.getNodeType())) : (arg instanceof YangInstanceIdentifier.AugmentationIdentifier ? (NodeContextSupplier)this.augmentationByYang.get((Object)arg) : (NodeContextSupplier)this.byYang.get((Object)arg));
        return this.childNonNull(childSupplier, arg, "Argument %s is not valid child of %s", arg, this.getSchema()).get();
    }

    protected final ValueNodeCodecContext getLeafChild(String name) {
        ValueNodeCodecContext value = (ValueNodeCodecContext)this.leafChild.get((Object)name);
        if (value == null) {
            throw IncorrectNestingException.create((String)"Leaf %s is not valid for %s", (Object[])new Object[]{name, this.getBindingClass()});
        }
        return value;
    }

    private DataContainerCodecPrototype<?> loadChildPrototype(Class<? extends DataContainer> childClass) {
        CompositeRuntimeType type = (CompositeRuntimeType)this.getType();
        GeneratedRuntimeType child = this.childNonNull(type.bindingChild(JavaTypeName.create(childClass)), childClass, "Node %s does not have child named %s", type, childClass);
        return DataContainerCodecPrototype.from(this.createBindingArg(childClass, child.statement()), (CompositeRuntimeType)child, this.factory());
    }

    InstanceIdentifier.Item<?> createBindingArg(Class<?> childClass, EffectiveStatement<?, ?> childSchema) {
        return InstanceIdentifier.Item.of(childClass);
    }

    private @Nullable DataContainerCodecPrototype<?> augmentationByClass(@NonNull Class<?> childClass) {
        DataContainerCodecPrototype<?> childProto = (DataContainerCodecPrototype<?>)this.augmentationByStream.get(childClass);
        return childProto != null ? childProto : this.mismatchedAugmentationByClass(childClass);
    }

    private @Nullable DataContainerCodecPrototype<?> mismatchedAugmentationByClass(@NonNull Class<?> childClass) {
        ImmutableMap local = MISMATCHED_AUGMENTED.getAcquire(this);
        DataContainerCodecPrototype<?> mismatched = (DataContainerCodecPrototype<?>)local.get(childClass);
        return mismatched != null ? mismatched : this.loadMismatchedAugmentation(local, childClass);
    }

    private @Nullable DataContainerCodecPrototype<?> loadMismatchedAugmentation(ImmutableMap<Class<?>, DataContainerCodecPrototype<?>> oldMismatched, @NonNull Class<?> childClass) {
        Class augTarget = BindingReflections.findAugmentationTarget(childClass);
        if (this.getBindingClass().equals(augTarget) && this.belongsToRuntimeContext(childClass)) {
            for (DataContainerCodecPrototype realChild : this.augmentationByStream.values()) {
                if (!Augmentation.class.isAssignableFrom(realChild.getBindingClass()) || !DataObjectCodecContext.isSubstitutionFor(childClass, realChild.getBindingClass())) continue;
                return this.cacheMismatched(oldMismatched, childClass, realChild);
            }
        }
        LOG.trace("Failed to resolve {} as a valid augmentation in {}", childClass, (Object)this);
        return null;
    }

    private @NonNull DataContainerCodecPrototype<?> cacheMismatched(@NonNull ImmutableMap<Class<?>, DataContainerCodecPrototype<?>> oldMismatched, @NonNull Class<?> childClass, @NonNull DataContainerCodecPrototype<?> prototype) {
        ImmutableMap witness;
        DataContainerCodecPrototype existing;
        ImmutableMap expected = oldMismatched;
        do {
            ImmutableMap newMismatched;
            if ((witness = MISMATCHED_AUGMENTED.compareAndExchangeRelease(this, expected, (Map)(newMismatched = ImmutableMap.builderWithExpectedSize((int)(expected.size() + 1)).putAll(expected).put(childClass, prototype).build()))) != expected) continue;
            LOG.trace("Cached mismatched augmentation {} -> {} in {}", new Object[]{childClass, prototype, this});
            return prototype;
        } while ((existing = (DataContainerCodecPrototype)(expected = witness).get(childClass)) == null);
        LOG.trace("Using raced mismatched augmentation {} -> {} in {}", new Object[]{childClass, existing, this});
        return existing;
    }

    private boolean belongsToRuntimeContext(Class<?> cls) {
        Class loaded;
        BindingRuntimeContext ctx = this.factory().getRuntimeContext();
        try {
            loaded = ctx.loadClass(Type.of(cls));
        }
        catch (ClassNotFoundException e) {
            LOG.debug("Proposed {} cannot be loaded in {}", new Object[]{cls, ctx, e});
            return false;
        }
        return cls.equals(loaded);
    }

    private @Nullable DataContainerCodecPrototype<?> loadAugmentPrototype(AugmentRuntimeType augment) {
        Class augClass;
        ImmutableSet possibleChildren = (ImmutableSet)augment.statement().streamEffectiveSubstatements(SchemaTreeEffectiveStatement.class).map(stmt -> (QName)stmt.argument()).collect(ImmutableSet.toImmutableSet());
        if (possibleChildren.isEmpty()) {
            return null;
        }
        NodeCodecContext.CodecContextFactory factory = this.factory();
        GeneratedType javaType = augment.javaType();
        try {
            augClass = factory.getRuntimeContext().loadClass((Type)javaType);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("RuntimeContext references type " + javaType + " but failed to load its class", e);
        }
        return DataContainerCodecPrototype.from(augClass, new YangInstanceIdentifier.AugmentationIdentifier(possibleChildren), augment, factory);
    }

    protected final @NonNull D createBindingProxy(DistinctNodeContainer<?, ?> node) {
        try {
            return (D)this.proxyConstructor.invokeExact(this, node);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    Map<Class<? extends Augmentation<?>>, Augmentation<?>> getAllAugmentationsFrom(DistinctNodeContainer<YangInstanceIdentifier.PathArgument, NormalizedNode> data) {
        HashMap map = new HashMap();
        for (NormalizedNode childValue : data.body()) {
            AugmentationNode augDomNode;
            DataContainerCodecPrototype codecProto;
            if (!(childValue instanceof AugmentationNode) || (codecProto = (DataContainerCodecPrototype)this.augmentationByYang.get((Object)(augDomNode = (AugmentationNode)childValue).getIdentifier())) == null) continue;
            NodeCodecContext codec = codecProto.get();
            map.put((Class<Augmentation<?>>)((DataContainerCodecContext)codec).getBindingClass(), (Augmentation<?>)codec.deserializeObject((NormalizedNode)augDomNode));
        }
        for (DataContainerCodecPrototype value : this.augmentationByStream.values()) {
            NormalizedNode augData;
            Class<?> augClass = value.getBindingClass();
            if (map.containsKey(augClass) || !((AugmentableRuntimeType)this.getType()).augments().contains(value.getType()) || (augData = data.childByArg(value.getYangArg())) == null) continue;
            map.putIfAbsent((Class<Augmentation<?>>)augClass, (Augmentation<?>)value.get().deserializeObject(augData));
        }
        return map;
    }

    final @NonNull Class<? extends CodecDataObject<?>> generatedClass() {
        return this.generatedClass;
    }

    public InstanceIdentifier.PathArgument deserializePathArgument(YangInstanceIdentifier.PathArgument arg) {
        Preconditions.checkArgument((boolean)this.getDomPathArgument().equals(arg));
        return this.bindingArg();
    }

    public YangInstanceIdentifier.PathArgument serializePathArgument(InstanceIdentifier.PathArgument arg) {
        Preconditions.checkArgument((boolean)this.bindingArg().equals(arg));
        return this.getDomPathArgument();
    }

    private static Map<Class<? extends DataContainer>, Method> getChildrenClassToMethod(Class<?> type) {
        return DataObjectCodecContext.getChildClassToMethod(type, "get");
    }

    private static Map<Class<? extends DataContainer>, Method> getChildrenClassToNonnullMethod(Class<?> type) {
        return DataObjectCodecContext.getChildClassToMethod(type, "nonnull");
    }

    private static Map<Class<? extends DataContainer>, Method> getChildClassToMethod(Class<?> type, String prefix) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"Target type must not be null");
        Preconditions.checkArgument((boolean)DataContainer.class.isAssignableFrom(type), (String)"Supplied type %s must be derived from DataContainer", type);
        HashMap<Class<? extends DataContainer>, Method> ret = new HashMap<Class<? extends DataContainer>, Method>();
        for (Method method : type.getMethods()) {
            DataObjectCodecContext.getYangModeledReturnType(method, prefix).ifPresent(entity -> ret.put((Class<? extends DataContainer>)entity, method));
        }
        return ret;
    }

    static {
        try {
            MISMATCHED_AUGMENTED = MethodHandles.lookup().findVarHandle(DataObjectCodecContext.class, "mismatchedAugmented", ImmutableMap.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

